/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.DateRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.DeletionGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityTypeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DisplayedOrSelectedIdHolderCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityWithDeletionInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;

public final class RevertDeletionConfirmationDialog
extends AbstractDataConfirmationDialog<Void> {
    private static final int LABEL_WIDTH = 60;
    private static final int FIELD_WIDTH = 180;
    private IViewContext<ICommonClientServiceAsync> viewContext;
    private AsyncCallback<Void> callback;
    private IEntityWithDeletionInformation deletedEntityOrNull;
    private DeletionGrid.DisplayedAndSelectedDeletions selectedAndDisplayedItemsOrNull;
    private Radio onlySelectedRadio;
    private Radio allRadio;

    public RevertDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, DeletionGrid.DisplayedAndSelectedDeletions selectedAndDisplayedItems, AsyncCallback<Void> callback) {
        this(viewContext, callback);
        this.selectedAndDisplayedItemsOrNull = selectedAndDisplayedItems;
    }

    public RevertDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, IEntityWithDeletionInformation deletedEntity, AsyncCallback<Void> callback) {
        this(viewContext, callback);
        this.deletedEntityOrNull = deletedEntity;
    }

    private RevertDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, AsyncCallback<Void> callback) {
        super(viewContext, null, viewContext.getMessage("revert_deletions_confirmation_title", new Object[0]));
        this.addStyleName("revertDeletionConfirmationDialog");
        this.viewContext = viewContext;
        this.callback = callback;
    }

    @Override
    protected void executeConfirmedAction() {
        AsyncCallbackWithProgressBar<Void> callbackWithProgress = AsyncCallbackWithProgressBar.decorate(this.callback, this.viewContext.getMessage("revert_deletions_progress", new Object[0]));
        if (this.selectedAndDisplayedItemsOrNull != null) {
            DisplayedOrSelectedIdHolderCriteria<TableModelRowWithObject<Deletion>> criteria = this.selectedAndDisplayedItemsOrNull.createCriteria(WidgetUtils.isSelected(this.onlySelectedRadio));
            this.viewContext.getCommonService().revertDeletions(criteria, callbackWithProgress);
        } else if (this.deletedEntityOrNull != null) {
            TechId techId = TechId.create((IIdHolder)this.deletedEntityOrNull.getDeletion());
            this.viewContext.getCommonService().revertDeletions(Collections.singletonList(techId), callbackWithProgress);
        }
    }

    @Override
    protected String createMessage() {
        if (this.selectedAndDisplayedItemsOrNull != null) {
            if (WidgetUtils.isSelected(this.onlySelectedRadio)) {
                return this.viewContext.getMessage("revert_deletions_selected_confirmation_msg", this.selectedAndDisplayedItemsOrNull.getSelectedDeletions().size());
            }
            return this.viewContext.getMessage("revert_deletions_all_confirmation_msg", new Object[0]);
        }
        if (this.deletedEntityOrNull != null) {
            String deletedEntity = EntityTypeUtils.translatedEntityKindForUI(this.viewContext, this.deletedEntityOrNull.getEntityKind()) + " '" + this.deletedEntityOrNull.getCode() + "'";
            Deletion deletion = this.deletedEntityOrNull.getDeletion();
            String deletedBy = deletion.getRegistrator().toString();
            String deletionDate = DateRenderer.renderDate(deletion.getRegistrationDate(), "yyyy-MM-dd HH:mm:ss");
            String deletionReason = StringEscapeUtils.unescapeHtml(deletion.getReason());
            return this.viewContext.getMessage("revert_entity_deletion_confirmation_msg", deletedEntity, deletedBy, deletionDate, deletionReason);
        }
        return null;
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(60);
        this.formPanel.setFieldWidth(180);
        if (this.selectedAndDisplayedItemsOrNull != null) {
            this.onlySelectedRadio = WidgetUtils.createRadio(this.viewContext.getMessage("only_selected_radio", this.selectedAndDisplayedItemsOrNull.getSelectedDeletions().size()));
            this.allRadio = WidgetUtils.createRadio(this.viewContext.getMessage("all_radio", this.selectedAndDisplayedItemsOrNull.getDisplayedItemsCount()));
            RadioGroup radioGroup = WidgetUtils.createAllOrSelectedRadioGroup(this.onlySelectedRadio, this.allRadio, this.viewContext.getMessage("deletion_radio_group_label", new Object[0]), this.selectedAndDisplayedItemsOrNull.getSelectedDeletions().size(), this.createRefreshMessageAction());
            radioGroup.setStyleName("gray-delete-radios");
            this.formPanel.add((Widget)radioGroup);
        }
    }
}

