/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;

public abstract class AbstractEditEntityTypeDialog<T extends EntityType>
extends AbstractRegistrationDialog {
    public static final String DIALOG_ID = "openbis_edit-type-dialog";
    private final T type;
    private final DescriptionField descriptionField;
    private ScriptChooserField scriptChooser;
    private final EntityKind entityKind;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    protected AbstractEditEntityTypeDialog(IViewContext<ICommonClientServiceAsync> viewContext, String title, IDelegatedAction postRegistrationCallback, EntityKind entityKind, T entityType) {
        super(viewContext, title, postRegistrationCallback);
        this.viewContext = viewContext;
        this.entityKind = entityKind;
        this.setId(DIALOG_ID);
        this.type = entityType;
        this.descriptionField = AbstractEditEntityTypeDialog.createDescriptionField(viewContext);
        this.descriptionField.setId("openbis_edit-type-dialog-description");
        FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, ((AbstractType)((Object)entityType)).getDescription());
        this.addField((Widget)this.descriptionField);
        this.scriptChooser = this.createScriptChooserField(viewContext, null, true, ScriptType.ENTITY_VALIDATION, entityKind);
        this.scriptChooser.setId("openbis_edit-type-dialog-script-chooser");
        this.addField((Widget)this.scriptChooser);
        this.scriptChooser.setValue(((BasicEntityType)((Object)entityType)).getValidationScript() != null ? ((BasicEntityType)((Object)entityType)).getValidationScript().getName() : "");
    }

    @Override
    protected void register(AsyncCallback<Void> registrationCallback) {
        ((AbstractType)((Object)this.type)).setDescription((String)this.descriptionField.getValue());
        Script script = new Script();
        script.setName((String)this.scriptChooser.getValue());
        ((BasicEntityType)((Object)this.type)).setValidationScript(script);
        this.setSpecificAttributes(this.type);
        this.viewContext.getCommonService().updateEntityType(this.entityKind, (EntityType)((Object)this.type), registrationCallback);
    }

    protected abstract void setSpecificAttributes(T var1);

    private ScriptChooserField createScriptChooserField(IViewContext<ICommonClientServiceAsync> context, String initialValue, boolean visible, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        ScriptChooserField field = ScriptChooserField.create(context.getMessage("validation_script", new Object[0]), false, initialValue, context, scriptTypeOrNull, entityKindOrNull);
        FieldUtil.setVisibility(visible, new Field[]{field});
        return field;
    }
}

