/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.DisplayedAndSelectedEntities;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentBrowserToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentDataSetArchivingMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ProjectSelectionTreeGridContainer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractEntityGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.GridUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListExperimentsCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ExperimentBrowserGrid
extends AbstractEntityGrid<Experiment> {
    private static final String PREFIX = "experiment-browser";
    public static final String BROWSER_ID = "openbis_experiment-browser";
    public static final String GRID_ID = "openbis_experiment-browser-grid";
    public static final String EDIT_BUTTON_ID = "openbis_experiment-browser_edit-button";
    public static final String SHOW_DETAILS_BUTTON_ID = "openbis_experiment-browser_show-details-button";
    public static final String DELETE_BUTTON_ID = "openbis_experiment-browser_delete-button";
    private final ICriteriaProvider<ListExperimentsCriteria> criteriaProvider;

    public static DisposableEntityChooser<TableModelRowWithObject<Experiment>> createChooser(IViewContext<ICommonClientServiceAsync> viewContext) {
        ProjectSelectionTreeGridContainer tree = new ProjectSelectionTreeGridContainer(viewContext);
        ExperimentBrowserToolbar toolbar = new ExperimentBrowserToolbar(viewContext, tree);
        ExperimentBrowserGrid browserGrid = new ExperimentBrowserGrid((IViewContext)viewContext, (ICriteriaProvider)toolbar, false){

            @Override
            protected ICellListenerAndLinkGenerator<Experiment> tryGetCellListenerAndLinkGenerator(String columnId) {
                return null;
            }

            @Override
            protected boolean isEditable(BaseEntityModel<TableModelRowWithObject<Experiment>> model, String columnID) {
                return false;
            }

            @Override
            protected void showNonEditableTableCellMessage(BaseEntityModel<TableModelRowWithObject<Experiment>> model, String columnID) {
            }
        };
        return ExperimentBrowserGrid.createExperimentBrowser(tree, toolbar, browserGrid, viewContext);
    }

    public static ExperimentBrowserGrid createForMetaproject(IViewContext<?> viewContext, TechId metaprojectId) {
        final ListExperimentsCriteria criteria = new ListExperimentsCriteria();
        criteria.setMetaprojectId(metaprojectId);
        ExperimentBrowserGrid browserGrid = new ExperimentBrowserGrid(viewContext.getCommonViewContext(), new ICriteriaProvider<ListExperimentsCriteria>(){

            @Override
            public ListExperimentsCriteria tryGetCriteria() {
                return criteria;
            }

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback dataRefreshCallback) {
                dataRefreshCallback.postRefresh(true);
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return new DatabaseModificationKind[0];
            }
        }, true);
        browserGrid.addEntityOperationsLabel();
        browserGrid.addTaggingButtons(false);
        browserGrid.addEntityOperationsSeparator();
        browserGrid.allowMultipleSelection();
        return browserGrid;
    }

    private static DisposableEntityChooser<TableModelRowWithObject<Experiment>> createExperimentBrowser(ProjectSelectionTreeGridContainer tree, ExperimentBrowserToolbar toolbar, ExperimentBrowserGrid browserGrid, IMessageProvider messageProvider) {
        browserGrid.addGridRefreshListener(toolbar);
        return browserGrid.asDisposableWithToolbarAndTree(toolbar, (Component)tree, messageProvider.getMessage("experiments_grid_header", new Object[0]));
    }

    public static DisposableEntityChooser<TableModelRowWithObject<Experiment>> create(IViewContext<ICommonClientServiceAsync> viewContext, String initialSpaceOrNull, String initialProjectOrNull, String initialExperimentTypeOrNull) {
        ProjectSelectionTreeGridContainer tree = new ProjectSelectionTreeGridContainer(viewContext, initialSpaceOrNull, initialProjectOrNull);
        ExperimentBrowserToolbar toolbar = new ExperimentBrowserToolbar(viewContext, tree, initialExperimentTypeOrNull);
        ExperimentBrowserGrid browserGrid = new ExperimentBrowserGrid(viewContext, toolbar, false);
        browserGrid.extendBottomToolbar();
        return ExperimentBrowserGrid.createExperimentBrowser(tree, toolbar, browserGrid, viewContext);
    }

    public static DisposableEntityChooser<TableModelRowWithObject<Experiment>> create(IViewContext<ICommonClientServiceAsync> viewContext) {
        return ExperimentBrowserGrid.create(viewContext, null, null, null);
    }

    private ExperimentBrowserGrid(IViewContext<ICommonClientServiceAsync> viewContext, ICriteriaProvider<ListExperimentsCriteria> criteriaProvider, boolean refreshAutomatically) {
        super(viewContext, GRID_ID, refreshAutomatically, DisplayTypeIDGenerator.ENTITY_BROWSER_GRID);
        this.criteriaProvider = criteriaProvider;
        this.registerLinkClickListenerFor("EXPERIMENT_IDENTIFIER", this.showEntityViewerLinkClickListener);
        this.linkProject();
        this.setId(BROWSER_ID);
    }

    @Override
    protected boolean supportsExportForUpdate() {
        return true;
    }

    private void linkProject() {
        ICellListenerAndLinkGenerator<Experiment> listenerAndLinkGenerator = new ICellListenerAndLinkGenerator<Experiment>(){

            @Override
            public void handle(TableModelRowWithObject<Experiment> rowItem, boolean specialKeyPressed) {
                Project project = rowItem.getObjectOrNull().getProject();
                String href = LinkExtractor.tryExtract(project);
                OpenEntityDetailsTabHelper.open(ExperimentBrowserGrid.this.viewContext, project, specialKeyPressed, href);
            }

            @Override
            public String tryGetLink(Experiment entity, ISerializableComparable comparableValue) {
                return LinkExtractor.tryExtract(entity.getProject());
            }
        };
        this.registerListenerAndLinkGenerator("PROJECT", listenerAndLinkGenerator);
        this.registerListenerAndLinkGenerator("PROJECT_IDENTIFIER", listenerAndLinkGenerator);
    }

    private void extendBottomToolbar() {
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            return;
        }
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add", this.viewContext.getMessage("experiment", new Object[0])), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                ExperimentBrowserGrid.this.openExperimentRegistrationTab();
            }
        });
        this.addButton(addButton);
        String showDetailsTitle = this.viewContext.getMessage("button_show_details", new Object[0]);
        Button showDetailsButton = this.createSelectedItemButton(showDetailsTitle, this.asShowEntityInvoker(false));
        showDetailsButton.setId(SHOW_DETAILS_BUTTON_ID);
        this.addButton(showDetailsButton);
        this.addTaggingButtons();
        String editTitle = this.viewContext.getMessage("edit", new Object[0]);
        Button editButton = this.createSelectedItemButton(editTitle, this.asShowEntityInvoker(true));
        editButton.setId(EDIT_BUTTON_ID);
        this.addButton(editButton);
        String deleteTitle = this.viewContext.getMessage("button_delete", new Object[0]);
        String deleteAllTitle = deleteTitle + " All";
        Button deleteButton = new Button(deleteAllTitle, (SelectionListener)new TypedTableGrid.AbstractCreateDialogListener(){

            protected Dialog createDialog(List<TableModelRowWithObject<Experiment>> experiments, IBrowserGridActionInvoker invoker) {
                return new ExperimentListDeletionConfirmationDialog((IViewContext<ICommonClientServiceAsync>)ExperimentBrowserGrid.this.viewContext, (AsyncCallback<Void>)ExperimentBrowserGrid.this.createRefreshCallback(invoker), ExperimentBrowserGrid.this.getDisplayedAndSelectedItemsAction().execute());
            }
        });
        this.changeButtonTitleOnSelectedItems(deleteButton, deleteAllTitle, deleteTitle);
        deleteButton.setId(DELETE_BUTTON_ID);
        this.addButton(deleteButton);
        if (this.viewContext.getModel().getApplicationInfo().isArchivingConfigured() && !this.viewContext.isSimpleOrEmbeddedMode()) {
            this.addButton(this.createArchivingMenu());
        }
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    private final TextToolItem createArchivingMenu() {
        return new ExperimentDataSetArchivingMenu(this.viewContext, this.getSelectedAndDisplayedItemsAction(), this.createRefreshGridAction());
    }

    private final IDelegatedActionWithResult<ExperimentDataSetArchivingMenu.SelectedAndDisplayedItems> getSelectedAndDisplayedItemsAction() {
        return new IDelegatedActionWithResult<ExperimentDataSetArchivingMenu.SelectedAndDisplayedItems>(){

            @Override
            public ExperimentDataSetArchivingMenu.SelectedAndDisplayedItems execute() {
                return new ExperimentDataSetArchivingMenu.SelectedAndDisplayedItems(ExperimentBrowserGrid.this.getSelectedBaseObjects(), ExperimentBrowserGrid.this.createTableExportCriteria(), ExperimentBrowserGrid.this.getTotalCount());
            }
        };
    }

    private void openExperimentRegistrationTab() {
        ActionContext context = new ActionContext();
        ListExperimentsCriteria criteriaOrNull = this.criteriaProvider.tryGetCriteria();
        if (criteriaOrNull != null) {
            ExperimentType experimentType = criteriaOrNull.getExperimentType();
            context.setExperimentType(experimentType);
            Project projectOrNull = criteriaOrNull.tryGetProject();
            context.setProject(projectOrNull);
            String spaceCodeOrNull = criteriaOrNull.getSpaceCode();
            context.setSpaceCode(spaceCodeOrNull);
        }
        DispatcherHelper.dispatchNaviEvent(new ComponentProvider(this.viewContext).getExperimentRegistration(context));
    }

    private void addGridRefreshListener(ExperimentBrowserToolbar topToolbar) {
        topToolbar.setCriteriaChangedListeners(this.createGridRefreshDelegatedAction());
    }

    private final IDelegatedAction createGridRefreshDelegatedAction() {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                if (ExperimentBrowserGrid.this.criteriaProvider.tryGetCriteria() != null) {
                    ExperimentBrowserGrid.this.refreshGridWithFilters();
                }
            }
        };
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Experiment>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Experiment>> callback) {
        ListExperimentsCriteria criteria = this.criteriaProvider.tryGetCriteria();
        criteria.copyPagingConfig(resultSetConfig);
        ((ICommonClientServiceAsync)this.viewContext.getService()).listExperiments(criteria, callback);
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Experiment>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Experiment>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        schema.setGridCellRendererFor("MODIFIER", PersonRenderer.MODIFIER_RENDERER);
        schema.setGridCellRendererFor("SHOW_DETAILS_LINK", this.createShowDetailsLinkCellRenderer());
        return schema;
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Experiment>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportExperiments(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return GridUtils.getRelevantModifications(DatabaseModificationKind.ObjectKind.EXPERIMENT, this.criteriaProvider);
    }

    @Override
    protected EntityKind getEntityKindOrNull() {
        return EntityKind.EXPERIMENT;
    }

    @Override
    public void update(final Set<DatabaseModificationKind> observedModifications) {
        this.criteriaProvider.update(observedModifications, new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
                ExperimentBrowserGrid.super.update(observedModifications);
            }
        });
    }

    protected final IDelegatedActionWithResult<DisplayedAndSelectedExperiments> getDisplayedAndSelectedItemsAction() {
        return new IDelegatedActionWithResult<DisplayedAndSelectedExperiments>(){

            @Override
            public DisplayedAndSelectedExperiments execute() {
                return new DisplayedAndSelectedExperiments(ExperimentBrowserGrid.this.getSelectedBaseObjects(), ExperimentBrowserGrid.this.createTableExportCriteria(), ExperimentBrowserGrid.this.getTotalCount());
            }
        };
    }

    public final class DisplayedAndSelectedExperiments
    extends DisplayedAndSelectedEntities<TableModelRowWithObject<Experiment>> {
        public DisplayedAndSelectedExperiments(List<TableModelRowWithObject<Experiment>> selectedItems, TableExportCriteria<TableModelRowWithObject<Experiment>> displayedItemsConfig, int displayedItemsCount) {
            super(selectedItems, displayedItemsConfig, displayedItemsCount);
        }

        public List<Experiment> getExperiments() {
            ArrayList<Experiment> experiments = new ArrayList<Experiment>();
            List rows = this.getSelectedItems();
            for (TableModelRowWithObject row : rows) {
                experiments.add((Experiment)row.getObjectOrNull());
            }
            return experiments;
        }
    }
}

