/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.ExperimentTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ProjectSelectionTreeGridContainer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListExperimentsCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;
import java.util.Set;

class ExperimentBrowserToolbar
extends ToolBar
implements IDisposableComponent,
ICriteriaProvider<ListExperimentsCriteria> {
    public static final String ID = "experiment-browser-toolbar";
    private final ExperimentTypeSelectionWidget selectExperimentTypeCombo;
    private final ProjectSelectionTreeGridContainer selectProjectTree;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public ExperimentBrowserToolbar(IViewContext<ICommonClientServiceAsync> viewContext, ProjectSelectionTreeGridContainer tree, String initialExperimentTypeOrNull) {
        this.viewContext = viewContext;
        this.selectExperimentTypeCombo = new ExperimentTypeSelectionWidget(viewContext, ID, true, initialExperimentTypeOrNull);
        this.selectProjectTree = tree;
        this.display();
    }

    public ExperimentBrowserToolbar(IViewContext<ICommonClientServiceAsync> viewContext, ProjectSelectionTreeGridContainer tree) {
        this(viewContext, tree, null);
    }

    public void setCriteriaChangedListeners(final IDelegatedAction refreshAction) {
        this.selectExperimentTypeCombo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<ExperimentTypeModel>(){

            public void selectionChanged(SelectionChangedEvent<ExperimentTypeModel> se) {
                refreshAction.execute();
            }
        });
        this.selectProjectTree.setSelectionChangedListener(new SelectionChangedListener<ModelData>(){

            public void selectionChanged(SelectionChangedEvent<ModelData> se) {
                refreshAction.execute();
            }
        });
    }

    protected void display() {
        this.setBorders(true);
        this.add((Component)new LabelToolItem(this.viewContext.getMessage("experiment_type", new Object[0]) + ":"));
        this.add((Component)this.selectExperimentTypeCombo);
    }

    @Override
    public final ListExperimentsCriteria tryGetCriteria() {
        ExperimentType selectedType = this.selectExperimentTypeCombo.tryGetSelectedExperimentType();
        if (selectedType == null) {
            return null;
        }
        Project selectedProjectOrNull = this.selectProjectTree.tryGetSelectedProject();
        Space selectedSpaceOrNull = this.selectProjectTree.tryGetSelectedSpace();
        if (selectedProjectOrNull == null && selectedSpaceOrNull == null) {
            return null;
        }
        ListExperimentsCriteria criteria = new ListExperimentsCriteria();
        criteria.setExperimentType(selectedType);
        criteria.setProject(selectedProjectOrNull);
        criteria.setSpace(selectedSpaceOrNull);
        return criteria;
    }

    protected final void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROJECT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROJECT), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback entityTypeRefreshCallback) {
        if (observedModifications.contains(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROJECT)) || observedModifications.contains(DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROJECT))) {
            this.selectProjectTree.update(observedModifications);
        } else if (observedModifications.contains(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT_TYPE)) || observedModifications.contains(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)) || observedModifications.contains(DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT))) {
            this.selectExperimentTypeCombo.refreshStore(entityTypeRefreshCallback);
        } else {
            entityTypeRefreshCallback.postRefresh(true);
        }
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        this.selectExperimentTypeCombo.dispose();
        this.selectProjectTree.dispose();
    }
}

