/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.ExperimentTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import java.util.List;

public final class ExperimentTypeSelectionWidget
extends DropDownList<ExperimentTypeModel, ExperimentType> {
    public static final String SUFFIX = "experiment-type";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final boolean withAll;
    private final String initialCodeOrNull;

    public ExperimentTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix, boolean withAll, String initialCodeOrNull) {
        super(viewContext, SUFFIX + idSuffix, "experiment_type", "code", viewContext.getMessage("experiment_type", new Object[0]).toLowerCase(), viewContext.getMessage("experiment_types", new Object[0]).toLowerCase());
        this.viewContext = viewContext;
        this.withAll = withAll;
        this.initialCodeOrNull = initialCodeOrNull;
        this.setAutoSelectFirst(withAll && initialCodeOrNull == null);
        this.setTemplate(GWTUtils.getTooltipTemplate("code", "tooltip"));
    }

    public ExperimentTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix, String initialCodeOrNull) {
        this(viewContext, idSuffix, false, initialCodeOrNull);
    }

    public final ExperimentType tryGetSelectedExperimentType() {
        return (ExperimentType)((Object)super.tryGetSelected());
    }

    @Override
    protected List<ExperimentTypeModel> convertItems(List<ExperimentType> result) {
        return ExperimentTypeModel.convert(result, this.withAll);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<ExperimentType>> callback) {
        this.viewContext.getService().listExperimentTypes(new ListExperimentTypesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.EXPERIMENT_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.EXPERIMENT_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    private void selectInitialValue() {
        if (this.initialCodeOrNull != null) {
            this.trySelectByPropertyValue("code", this.initialCodeOrNull, this.viewContext.getMessage("experiment_type", new Object[0]) + " '" + this.initialCodeOrNull + "' doesn't exist.");
            this.updateOriginalValue();
        }
    }

    private class ListExperimentTypesCallback
    extends DropDownList.ListItemsCallback {
        protected ListExperimentTypesCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        public void process(List<ExperimentType> result) {
            super.process(result);
            ExperimentTypeSelectionWidget.this.selectInitialValue();
        }
    }
}

