/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.store.ListStore;
import java.util.ArrayList;
import java.util.List;

public final class ProjectSelectionWidget
extends DropDownList<ProjectComboModel, TableModelRowWithObject<Project>> {
    private static final String EMPTY_RESULT_SUFFIX = "projects";
    private static final String CHOOSE_SUFFIX = "project";
    static final String DISPLAY_COLUMN_ID = "id";
    public static final String SUFFIX = "project";
    private final IViewContext<?> viewContext;
    private final String spaceCodeOrNull;
    private String initialProjectIdentifierOrNull;
    private boolean dataLoaded = false;

    public ProjectSelectionWidget(IViewContext<?> viewContext, String idSuffix) {
        this(viewContext, idSuffix, null, null);
    }

    public ProjectSelectionWidget(IViewContext<?> viewContext, String idSuffix, String initialProjectIdentifier) {
        this(viewContext, idSuffix, null, initialProjectIdentifier);
    }

    public ProjectSelectionWidget(IViewContext<?> viewContext, String idSuffix, String spaceCodeOrNull, String initialProjectIdentifier) {
        super(viewContext, "project" + idSuffix, "project", DISPLAY_COLUMN_ID, "project", EMPTY_RESULT_SUFFIX);
        this.viewContext = viewContext;
        this.spaceCodeOrNull = spaceCodeOrNull;
        this.initialProjectIdentifierOrNull = initialProjectIdentifier;
    }

    public final Project tryGetSelectedProject() {
        Object selected = super.tryGetSelected();
        return selected instanceof Project ? (Project)selected : null;
    }

    public void selectProjectAndUpdateOriginal(String newProjectIdentifier) {
        this.initialProjectIdentifierOrNull = newProjectIdentifier;
        if (this.dataLoaded && this.initialProjectIdentifierOrNull != null) {
            this.trySelectByIdentifier(this.initialProjectIdentifierOrNull);
            this.updateOriginalValue();
        }
    }

    @Override
    protected List<ProjectComboModel> convertItems(List<TableModelRowWithObject<Project>> projects) {
        ArrayList<ProjectComboModel> result = new ArrayList<ProjectComboModel>();
        for (TableModelRowWithObject<Project> p : projects) {
            if (!this.matchesTheGroup(p.getObjectOrNull())) continue;
            result.add(new ProjectComboModel(p.getObjectOrNull(), this.spaceCodeOrNull == null));
        }
        return result;
    }

    private boolean matchesTheGroup(Project project) {
        if (this.spaceCodeOrNull == null) {
            return true;
        }
        Space projectGroup = project.getSpace();
        return projectGroup.getCode().equals(this.spaceCodeOrNull);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<TableModelRowWithObject<Project>>> callback) {
        DefaultResultSetConfig<String, TableModelRowWithObject<Project>> config = DefaultResultSetConfig.createFetchAll();
        this.viewContext.getCommonService().listProjects(config, new ListProjectsCallback(this.viewContext));
        callback.ignore();
    }

    public void trySelectByIdentifier(String projectIdentifier) {
        List projects = this.getStore().findModels("projectIdentifier", (Object)projectIdentifier);
        if (projects != null && projects.size() > 0) {
            GWTUtils.setSelectedItem(this, "projectIdentifier", projectIdentifier);
        } else {
            this.setValue(null);
        }
    }

    public String getSpaceCodeOrNull() {
        return this.spaceCodeOrNull;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROJECT);
    }

    private final class ListProjectsCallback
    extends AbstractAsyncCallback<TypedTableResultSet<Project>> {
        ListProjectsCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(TypedTableResultSet<Project> result) {
            ProjectSelectionWidget.this.resultSetKey = result.getResultSet().getResultSetKey();
            ListStore projectStore = ProjectSelectionWidget.this.getStore();
            projectStore.removeAll();
            projectStore.add(ProjectSelectionWidget.this.convertItems(result.getResultSet().getList().extractOriginalObjects()));
            if (projectStore.getCount() > 0) {
                ProjectSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_choose", "project"));
                ProjectSelectionWidget.this.setReadOnly(false);
            } else {
                ProjectSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_empty", ProjectSelectionWidget.EMPTY_RESULT_SUFFIX));
                ProjectSelectionWidget.this.setReadOnly(true);
            }
            ProjectSelectionWidget.this.applyEmptyText();
            ProjectSelectionWidget.this.dataLoaded = true;
            if (ProjectSelectionWidget.this.initialProjectIdentifierOrNull != null) {
                ProjectSelectionWidget.this.selectProjectAndUpdateOriginal(ProjectSelectionWidget.this.initialProjectIdentifierOrNull);
            } else {
                ProjectSelectionWidget.this.selectProjectAndUpdateOriginal(this.viewContext.getDisplaySettingsManager().getDefaultProject());
            }
            ProjectSelectionWidget.this.removeResultSetFromCache();
        }
    }

    public static class ProjectComboModel
    extends SimplifiedBaseModelData {
        private static final long serialVersionUID = 1L;

        public ProjectComboModel(Project project, boolean withGroup) {
            if (withGroup) {
                this.set(ProjectSelectionWidget.DISPLAY_COLUMN_ID, this.renderProjectWithGroup(project));
            } else {
                this.set(ProjectSelectionWidget.DISPLAY_COLUMN_ID, this.renderProject(project));
            }
            this.set("projectIdentifier", project.getIdentifier());
            this.set("object", project);
        }

        private String renderProjectWithGroup(Project p) {
            return p.getCode() + " (" + p.getSpace().getCode() + ")";
        }

        private String renderProject(Project p) {
            return p.getCode();
        }
    }
}

