/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ChosenEntitySetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.EntityChooserDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesSetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.AttributeSearchFieldKindProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.ArrayList;
import java.util.List;

public class DataSetChooserField
extends ChosenEntitySetter<AbstractExternalData> {
    public static DataSetChooserField create(String labelField, boolean mandatory, final IViewContext<ICommonClientServiceAsync> viewContext) {
        DataSetChooserField field = new DataSetChooserField(mandatory, viewContext){

            protected void onTriggerClick(ComponentEvent ce) {
                super.onTriggerClick(ce);
                DataSetChooserField.browse(viewContext, this);
            }
        };
        field.setFieldLabel(labelField);
        return field;
    }

    private static void browse(IViewContext<ICommonClientServiceAsync> viewContext, final ChosenEntitySetter<AbstractExternalData> field) {
        ArrayList<DetailedSearchCriterion> criterionList = new ArrayList<DetailedSearchCriterion>();
        DetailedSearchCriteria searchCriteria = new DetailedSearchCriteria();
        searchCriteria.setConnection(SearchCriteriaConnection.MATCH_ANY);
        DetailedSearchCriterion searchCriterion = new DetailedSearchCriterion(DetailedSearchField.createAttributeField(AttributeSearchFieldKindProvider.getAttributeFieldKind(EntityKind.DATA_SET, "CODE")), "*");
        criterionList.add(searchCriterion);
        searchCriteria.setCriteria(criterionList);
        DisposableEntityChooser<TableModelRowWithObject<AbstractExternalData>> browser = DataSetSearchHitGrid.createWithInitialSearchCriteria(viewContext, searchCriteria, true);
        new EntityChooserDialog<TableModelRowWithObject<AbstractExternalData>>(browser, new IChosenEntitiesSetter<TableModelRowWithObject<AbstractExternalData>>(){

            @Override
            public void setChosenEntities(List<TableModelRowWithObject<AbstractExternalData>> row) {
                field.setChosenEntities(TableModelRowWithObject.getObjects(row));
            }
        }, "Choose data set", viewContext, new Button[0]).show();
    }

    @Override
    public String renderEntity(AbstractExternalData entity) {
        return entity.getCode();
    }

    private DataSetChooserField(boolean mandatory, IViewContext<ICommonClientServiceAsync> viewContext) {
        FieldUtil.setMandatoryFlag(this, mandatory);
        this.setValidateOnBlur(true);
        this.setAutoValidate(true);
    }
}

