/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ChosenEntitySetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.EntityChooserDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialBrowserGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.button.Button;

public class MaterialChooserField
extends ChosenEntitySetter<TableModelRowWithObject<Material>> {
    private static final String CODE_AND_TYPE_PATTERN = "^[^\\s]+ \\([a-zA-Z0-9_\\-\\.]+\\)$";

    public static MaterialChooserField create(String labelField, boolean mandatory, final MaterialType materialTypeOrNull, String initialValueOrNull, final IViewContext<ICommonClientServiceAsync> viewContext) {
        MaterialChooserField chosenMaterialField = new MaterialChooserField(mandatory, materialTypeOrNull, initialValueOrNull, viewContext){

            protected void onTriggerClick(ComponentEvent ce) {
                super.onTriggerClick(ce);
                MaterialChooserField.browseMaterials(viewContext, this, materialTypeOrNull);
            }
        };
        chosenMaterialField.setFieldLabel(labelField);
        return chosenMaterialField;
    }

    private static void browseMaterials(IViewContext<ICommonClientServiceAsync> viewContext, ChosenEntitySetter<TableModelRowWithObject<Material>> chosenMaterialField, MaterialType materialTypeOrNull) {
        DisposableEntityChooser<TableModelRowWithObject<Material>> materialBrowser = MaterialBrowserGrid.create(viewContext, materialTypeOrNull);
        String title = viewContext.getMessage("title_choose_material", new Object[0]);
        new EntityChooserDialog<TableModelRowWithObject<Material>>(materialBrowser, chosenMaterialField, title, viewContext, new Button[0]).show();
    }

    @Override
    public String renderEntity(TableModelRowWithObject<Material> materialOrNull) {
        String identifier = materialOrNull.getObjectOrNull().getIdentifier();
        return StringEscapeUtils.unescapeHtml(identifier);
    }

    private MaterialChooserField(boolean mandatory, MaterialType materialTypeOrNull, String initialValueOrNull, IViewContext<ICommonClientServiceAsync> viewContext) {
        FieldUtil.setMandatoryFlag(this, mandatory);
        this.setValidateOnBlur(true);
        this.setAutoValidate(true);
        this.setRegex(CODE_AND_TYPE_PATTERN);
        this.getMessages().setRegexText(viewContext.getMessage("incorrect_material_syntax", new Object[0]));
        if (initialValueOrNull != null) {
            this.setValue(initialValueOrNull);
        }
    }
}

