/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.TableCellElement;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.dom.client.TableRowElement;
import com.google.gwt.dom.client.TextAreaElement;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Timer;
import java.util.List;

public class MultilineItemsField
extends MultilineVarcharField {
    private DivElement itemCounter;
    private Timer itemCounterRefreshTimer;

    public MultilineItemsField(String label, boolean mandatory) {
        super(label, mandatory);
        this.initItemCounter();
    }

    public MultilineItemsField(String label, boolean mandatory, int lines) {
        super(label, mandatory, lines);
        this.initItemCounter();
    }

    public final String[] tryGetModifiedItemList() {
        if (!this.isDirty()) {
            return null;
        }
        return this.getItems();
    }

    public final String[] getItems() {
        String text = (String)this.getValue();
        if (!StringUtils.isBlank((String)text)) {
            return text.split("\n|\r\n|, *");
        }
        return new String[0];
    }

    public final void setItems(List<String> items) {
        String textValue = MultilineItemsField.createTextValue(items);
        this.setValue(textValue);
        this.setOriginalValue(textValue);
        this.refreshItemCounter();
    }

    public final void appendItem(String item) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getValue() == null ? "" : (String)this.getValue());
        MultilineItemsField.appendItem(sb, item);
        this.setValue(sb.toString());
        this.refreshItemCounter();
    }

    private void initItemCounter() {
        this.itemCounter = Document.get().createDivElement();
        this.itemCounter.setClassName("textarea-item-counter");
        this.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                MultilineItemsField.this.scheduleItemCounterRefresh();
            }
        });
        this.addListener(Events.KeyUp, (Listener)new Listener<FieldEvent>(){

            public void handleEvent(FieldEvent be) {
                MultilineItemsField.this.scheduleItemCounterRefresh();
            }
        });
        this.refreshItemCounter();
    }

    private void scheduleItemCounterRefresh() {
        if (this.itemCounterRefreshTimer == null) {
            this.itemCounterRefreshTimer = new Timer(){

                public void run() {
                    MultilineItemsField.this.refreshItemCounter();
                    MultilineItemsField.this.itemCounterRefreshTimer = null;
                }
            };
            this.itemCounterRefreshTimer.schedule(300);
        }
    }

    private void refreshItemCounter() {
        String[] items = this.getItems();
        int count = 0;
        for (String item : items) {
            if (StringUtils.isBlank((String)item)) continue;
            ++count;
        }
        this.itemCounter.setInnerText("(" + count + ")");
    }

    private static String createTextValue(List<String> items) {
        StringBuilder sb = new StringBuilder();
        for (String item : items) {
            MultilineItemsField.appendItem(sb, item);
        }
        return sb.toString();
    }

    private static final void appendItem(StringBuilder sb, String item) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(item);
    }

    protected void onRender(Element target, int index) {
        if (this.el() == null) {
            Document doc = Document.get();
            DivElement wrapper = doc.createDivElement();
            TableElement table = doc.createTableElement();
            table.setCellPadding(0);
            table.setCellSpacing(0);
            TableRowElement row = doc.createTRElement();
            TextAreaElement textArea = doc.createTextAreaElement();
            TableCellElement textAreaCell = doc.createTDElement();
            textAreaCell.appendChild((Node)textArea);
            TableCellElement itemCounterCell = doc.createTDElement();
            itemCounterCell.appendChild((Node)this.itemCounter);
            row.appendChild((Node)textAreaCell);
            row.appendChild((Node)itemCounterCell);
            table.appendChild((Node)row);
            wrapper.appendChild((Node)table);
            this.setElement((Element)wrapper.cast(), target, index);
            this.input = this.el().firstChild().firstChild().firstChild().firstChild();
        }
        super.onRender(target, index);
    }
}

