/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.ParameterValueModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IParameterField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IParameterValuesLoader;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ParameterValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ParameterWithValue;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TriggerField;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.List;

public class ParameterField
extends TriggerField<ModelData>
implements IParameterField {
    public static String PARAMETER_METADATA_SEPARATOR = "::";
    private static String ENUM_LIST_EXPRESSION_PREFIX = "list=";
    private static String ENUM_LIST_SEPARATOR = ",";
    private static String QUERY_LIST_EXPRESSION_PREFIX = "query=";
    private static String TYPE_EXPRESSION_PREFIX = "type=";
    private final String parameterName;
    private final IDelegatedAction onValueChangeAction;
    private final String initialValueOrNull;

    public static IParameterField create(IViewContext<?> viewContextOrNull, String parameterName, String initialValueOrNull, IDelegatedAction onValueChangeAction, IParameterValuesLoader loaderOrNull) {
        String[] split = parameterName.split(PARAMETER_METADATA_SEPARATOR, 2);
        String name = split[0];
        if (split.length == 2) {
            String[] expressionParts = split[1].split(PARAMETER_METADATA_SEPARATOR);
            String idSuffix = name.replaceAll(" ", "_");
            ParameterField.checkMetadata(name, expressionParts);
            for (String expressionPart : expressionParts) {
                if (expressionPart.startsWith(ENUM_LIST_EXPRESSION_PREFIX)) {
                    String itemList = expressionPart.substring(ENUM_LIST_EXPRESSION_PREFIX.length());
                    String[] values = itemList.split(ENUM_LIST_SEPARATOR);
                    ArrayList<ParameterValue> parameterValues = new ArrayList<ParameterValue>();
                    for (String value : values) {
                        parameterValues.add(new ParameterValue(value, null));
                    }
                    return ParameterSelectionField.createWithValues(name, idSuffix, parameterValues, initialValueOrNull, onValueChangeAction);
                }
                if (!expressionPart.startsWith(QUERY_LIST_EXPRESSION_PREFIX)) continue;
                String queryExpression = expressionPart.substring(QUERY_LIST_EXPRESSION_PREFIX.length());
                return ParameterSelectionField.createWithLoader(name, queryExpression, idSuffix, viewContextOrNull, loaderOrNull, initialValueOrNull, onValueChangeAction);
            }
        }
        return new ParameterField(name, onValueChangeAction, initialValueOrNull);
    }

    static void checkMetadata(String namePart, String[] expressionParts) {
        for (String expressionPart : expressionParts) {
            if (expressionPart.startsWith(ENUM_LIST_EXPRESSION_PREFIX) || expressionPart.startsWith(QUERY_LIST_EXPRESSION_PREFIX) || expressionPart.startsWith(TYPE_EXPRESSION_PREFIX)) continue;
            GWTUtils.alert("Error", "Filter parameter '" + namePart + "' is not defined properly.");
        }
    }

    private ParameterField(String parameterName, IDelegatedAction onValueChangeAction, String initialValueOrNull) {
        this.parameterName = parameterName;
        this.onValueChangeAction = onValueChangeAction;
        this.initialValueOrNull = initialValueOrNull;
        this.setEmptyText(parameterName);
        this.setToolTip(parameterName);
        this.setFieldLabel(parameterName);
        this.setTriggerStyle("x-form-clear-trigger");
        FieldUtil.setMandatoryFlag(this, true);
        this.setAutoValidate(true);
        this.setValidateOnBlur(true);
        this.setWidth(100);
    }

    @Override
    public ParameterWithValue getParameterWithValue() {
        return new ParameterWithValue(this.parameterName, this.getRawValue());
    }

    @Override
    public Field<?> asWidget() {
        return this;
    }

    protected void onRender(Element target, int index) {
        super.onRender(target, index);
        this.setRawValue(this.initialValueOrNull);
    }

    protected void onKeyUp(FieldEvent fe) {
        super.onKeyUp(fe);
        this.onValueChangeAction.execute();
    }

    protected void onTriggerClick(ComponentEvent ce) {
        super.onTriggerClick(ce);
        this.setValue(null);
        this.onValueChangeAction.execute();
    }

    private static class ParameterSelectionField
    extends DropDownList<ParameterValueModel, ParameterValue>
    implements IParameterField {
        private static final String VALUE_NOT_IN_LIST_MSG = "Value not in the list";
        private static final String EMPTY_MSG = "- No values found -";
        private final IViewContext<?> viewContextOrNull;
        private final IParameterValuesLoader loaderOrNull;
        private final String parameterName;
        private String initialValueOrNull;
        private final String queryExpressionOrNull;
        private final IDelegatedAction onValueChangeAction;

        public static IParameterField createWithLoader(String parameterName, String queryExpression, String idSuffix, IViewContext<?> viewContextOrNull, IParameterValuesLoader loader, String initialValueOrNull, IDelegatedAction onValueChangeAction) {
            return new ParameterSelectionField(parameterName, idSuffix, viewContextOrNull, loader, queryExpression, null, initialValueOrNull, onValueChangeAction);
        }

        public static IParameterField createWithValues(String parameterName, String idSuffix, List<ParameterValue> initialValues, String initialValueOrNull, IDelegatedAction onValueChangeAction) {
            return new ParameterSelectionField(parameterName, idSuffix, null, null, null, initialValues, initialValueOrNull, onValueChangeAction);
        }

        protected ParameterSelectionField(String parameterName, String idSuffix, IViewContext<?> viewContextOrNull, IParameterValuesLoader loaderOrNull, String queryExpressionOrNull, List<ParameterValue> valuesOrNull, String initialValueOrNull, final IDelegatedAction onValueChangeAction) {
            super(idSuffix, "code", parameterName, parameterName, EMPTY_MSG, VALUE_NOT_IN_LIST_MSG, true, viewContextOrNull, valuesOrNull == null);
            this.parameterName = parameterName;
            this.queryExpressionOrNull = queryExpressionOrNull;
            this.viewContextOrNull = viewContextOrNull;
            this.loaderOrNull = loaderOrNull;
            this.initialValueOrNull = initialValueOrNull;
            this.onValueChangeAction = onValueChangeAction;
            if (valuesOrNull != null) {
                this.setValues(valuesOrNull);
            }
            this.setTemplate(GWTUtils.getTooltipTemplate("code", "tooltip"));
            FieldUtil.setMandatoryFlag(this, true);
            this.setAllowValueNotFromList(true);
            this.setToolTip(parameterName);
            this.setWidth(100);
            this.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<ParameterValueModel>(){

                public void selectionChanged(SelectionChangedEvent<ParameterValueModel> se) {
                    onValueChangeAction.execute();
                }
            });
        }

        private void setValues(List<ParameterValue> values) {
            ArrayList<ParameterValueModel> models = new ArrayList<ParameterValueModel>();
            models.addAll(this.convertItems(values));
            this.updateStore(models);
            this.getPropertyEditor().setList(this.store.getModels());
            this.selectInitialValue();
        }

        @Override
        protected List<ParameterValueModel> convertItems(List<ParameterValue> result) {
            return ParameterValueModel.convert(result);
        }

        @Override
        protected void loadData(AbstractAsyncCallback<List<ParameterValue>> callback) {
            if (this.viewContextOrNull != null && this.loaderOrNull != null && this.queryExpressionOrNull != null) {
                this.loaderOrNull.loadData(this.queryExpressionOrNull, new ListParameterValuesCallback(this.viewContextOrNull));
            }
            callback.ignore();
        }

        @Override
        public DatabaseModificationKind[] getRelevantModifications() {
            return new DatabaseModificationKind[0];
        }

        public void selectInitialValue() {
            if (this.initialValueOrNull != null) {
                this.trySelectByValue(this.initialValueOrNull);
                this.updateOriginalValue();
            }
        }

        public void trySelectByValue(String parameterValue) {
            GWTUtils.setSelectedItem(this, "code", parameterValue);
        }

        @Override
        public ParameterWithValue getParameterWithValue() {
            return new ParameterWithValue(this.parameterName, this.getRawValue());
        }

        @Override
        public Field<?> asWidget() {
            return this;
        }

        protected void onKeyUp(FieldEvent fe) {
            super.onKeyUp(fe);
            this.onValueChangeAction.execute();
        }

        private class ListParameterValuesCallback
        extends DropDownList.ListItemsCallback {
            protected ListParameterValuesCallback(IViewContext<?> viewContext) {
                super(viewContext);
            }

            @Override
            public void process(List<ParameterValue> result) {
                super.process(result);
                ParameterSelectionField.this.selectInitialValue();
            }
        }
    }
}

