/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ChosenEntitySetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.EntityChooserDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.ScriptGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.button.Button;

public class ScriptChooserField
extends ChosenEntitySetter<TableModelRowWithObject<Script>> {
    public static ScriptChooserField create(String labelField, boolean mandatory, String initialValueOrNull, final IViewContext<ICommonClientServiceAsync> viewContext, final ScriptType scriptTypeOrNull, final EntityKind entityKindOrNull) {
        ScriptChooserField field = new ScriptChooserField(mandatory, initialValueOrNull, viewContext){

            protected void onTriggerClick(ComponentEvent ce) {
                super.onTriggerClick(ce);
                ScriptChooserField.browseScripts(viewContext, this, scriptTypeOrNull, entityKindOrNull);
            }
        };
        field.setFieldLabel(labelField);
        return field;
    }

    public static ScriptChooserField create(String labelField, boolean mandatory, String initialValueOrNull, final IViewContext<ICommonClientServiceAsync> viewContext, final IScriptTypeProvider scriptTypeProvider, final EntityKind entityKindOrNull) {
        ScriptChooserField field = new ScriptChooserField(mandatory, initialValueOrNull, viewContext){

            protected void onTriggerClick(ComponentEvent ce) {
                super.onTriggerClick(ce);
                ScriptChooserField.browseScripts(viewContext, this, scriptTypeProvider.tryGetScriptType(), entityKindOrNull);
            }
        };
        field.setFieldLabel(labelField);
        return field;
    }

    private static void browseScripts(IViewContext<ICommonClientServiceAsync> viewContext, ChosenEntitySetter<TableModelRowWithObject<Script>> chosenScriptField, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        DisposableEntityChooser<TableModelRowWithObject<Script>> scriptBrowser = ScriptGrid.create(viewContext, scriptTypeOrNull, entityKindOrNull);
        String title = viewContext.getMessage("title_choose_script", scriptTypeOrNull == null ? "" : scriptTypeOrNull.getDescription());
        new EntityChooserDialog<TableModelRowWithObject<Script>>(scriptBrowser, chosenScriptField, title, viewContext, new Button[0]).show();
    }

    @Override
    public String renderEntity(TableModelRowWithObject<Script> script) {
        return script.getObjectOrNull().getName();
    }

    private ScriptChooserField(boolean mandatory, String initialValueOrNull, IViewContext<ICommonClientServiceAsync> viewContext) {
        FieldUtil.setMandatoryFlag(this, mandatory);
        this.setValidateOnBlur(true);
        this.setAutoValidate(true);
        if (initialValueOrNull != null) {
            this.setValue(initialValueOrNull);
        }
    }

    public static interface IScriptTypeProvider {
        public ScriptType tryGetScriptType();
    }
}

