/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.VocabularyTermModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class VocabularyTermSelectionWidget
extends DropDownList<VocabularyTermModel, VocabularyTerm> {
    private static final String CHOOSE_MSG = "Choose...";
    private static final String CHOOSE_OR_ADD_MSG = "Choose or add new...";
    private static final String VALUE_NOT_IN_LIST_MSG = "Value not in the list";
    private static final String EMPTY_MSG = "- No terms found -";
    private final IViewContext<?> viewContextOrNull;
    private Vocabulary vocabularyOrNull;
    private String initialTermCodeOrNull;
    private String typedValueOrNull = null;

    public static DatabaseModificationAwareField<VocabularyTermModel> create(String idSuffix, String label, Vocabulary vocabulary, boolean mandatory, IViewContext<?> viewContext, String initialTermCodeOrNull) {
        return new VocabularyTermSelectionWidget(idSuffix, label, mandatory, vocabulary, viewContext, null, initialTermCodeOrNull).asDatabaseModificationAware();
    }

    public static DatabaseModificationAwareField<VocabularyTermModel> create(String idSuffix, String label, Vocabulary vocabulary, boolean mandatory, IViewContext<?> viewContext, String initialTermCodeOrNull, boolean allowAddingUnofiicialTerms) {
        return new VocabularyTermSelectionWidget(idSuffix, label, mandatory, vocabulary, viewContext, null, initialTermCodeOrNull, allowAddingUnofiicialTerms).asDatabaseModificationAware();
    }

    public VocabularyTermSelectionWidget(String idSuffix, String label, boolean mandatory, List<VocabularyTerm> initialTermsOrNull, String initialTermOrNull) {
        this(idSuffix, label, mandatory, null, null, initialTermsOrNull, initialTermOrNull);
    }

    protected VocabularyTermSelectionWidget(String idSuffix, String label, boolean mandatory, Vocabulary vocabularyOrNull, IViewContext<?> viewContextOrNull, List<VocabularyTerm> termsOrNull, String initialTermCodeOrNull) {
        this(idSuffix, label, mandatory, vocabularyOrNull, viewContextOrNull, termsOrNull, initialTermCodeOrNull, VocabularyTermSelectionWidget.allowAddingUnofficialTerms(viewContextOrNull));
    }

    protected VocabularyTermSelectionWidget(String idSuffix, String label, boolean mandatory, Vocabulary vocabularyOrNull, IViewContext<?> viewContextOrNull, List<VocabularyTerm> termsOrNull, String initialTermCodeOrNull, boolean allowAddigUnofficialTerms) {
        super(idSuffix, "code_with_label", label, allowAddigUnofficialTerms ? CHOOSE_OR_ADD_MSG : CHOOSE_MSG, EMPTY_MSG, VALUE_NOT_IN_LIST_MSG, mandatory, viewContextOrNull, termsOrNull == null, allowAddigUnofficialTerms);
        this.viewContextOrNull = viewContextOrNull;
        this.vocabularyOrNull = vocabularyOrNull;
        this.initialTermCodeOrNull = initialTermCodeOrNull;
        FieldUtil.setMandatoryFlag(this, mandatory);
        this.setAllowBlank(!mandatory);
        if (termsOrNull != null) {
            this.setTerms(termsOrNull);
        }
        this.setLazyRender(false);
        this.setTemplate(GWTUtils.getTooltipTemplate("display_field", "tooltip"));
        if (VocabularyTermSelectionWidget.allowAddingUnofficialTerms(viewContextOrNull)) {
            this.addListener(Events.Blur, new AddNewTermListener(){

                @Override
                public boolean condition() {
                    return VocabularyTermSelectionWidget.this.getSelection().size() != 1 && false == StringUtils.isBlank((String)VocabularyTermSelectionWidget.this.getRawValue());
                }
            });
            this.addListener(Events.TwinTriggerClick, new AddNewTermListener(){

                @Override
                public boolean condition() {
                    return true;
                }
            });
        }
    }

    private static boolean allowAddingUnofficialTerms(IViewContext<?> viewContextOrNull) {
        return viewContextOrNull != null && viewContextOrNull.getModel().getApplicationInfo().getWebClientConfiguration().getAllowAddingUnofficialTerms();
    }

    public void setVocabulary(Vocabulary vocabulary) {
        this.vocabularyOrNull = vocabulary;
        this.refreshStore();
    }

    private void setTerms(List<VocabularyTerm> terms) {
        ArrayList<VocabularyTermModel> models = new ArrayList<VocabularyTermModel>();
        models.addAll(this.convertItems(terms));
        this.updateStore(models);
        this.getPropertyEditor().setList(this.store.getModels());
        this.selectInitialValue();
    }

    @Override
    protected List<VocabularyTermModel> convertItems(List<VocabularyTerm> result) {
        return VocabularyTermModel.convert(result);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<VocabularyTerm>> callback) {
        if (this.viewContextOrNull != null && this.vocabularyOrNull != null) {
            this.viewContextOrNull.getCommonService().listVocabularyTerms(this.vocabularyOrNull, new ListTermsCallback(this.viewContextOrNull));
        }
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.VOCABULARY_TERM);
    }

    public void selectInitialValue() {
        if (this.typedValueOrNull != null) {
            try {
                this.trySelectByCode(this.typedValueOrNull);
                this.updateOriginalValue();
            }
            finally {
                this.typedValueOrNull = null;
            }
        } else if (this.initialTermCodeOrNull != null) {
            this.trySelectByCode(this.initialTermCodeOrNull);
            this.updateOriginalValue();
        }
    }

    public void trySelectByCode(String termCode) {
        GWTUtils.setSelectedItem(this, "code", termCode);
    }

    public VocabularyTermModel findModel(String code) {
        VocabularyTermModel val = null;
        for (VocabularyTermModel c : this.store.getModels()) {
            if (!c.getTerm().getCode().equals(code)) continue;
            val = c;
            break;
        }
        if (val == null) {
            this.initialTermCodeOrNull = code;
        }
        return val;
    }

    private class ListTermsCallback
    extends DropDownList.ListItemsCallback {
        protected ListTermsCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        public void process(List<VocabularyTerm> result) {
            super.process(result);
            VocabularyTermSelectionWidget.this.selectInitialValue();
        }
    }

    private abstract class AddNewTermListener
    implements Listener<BaseEvent> {
        private AddNewTermListener() {
        }

        public void handleEvent(BaseEvent be) {
            if (VocabularyTermSelectionWidget.this.vocabularyOrNull != null && this.condition()) {
                AddVocabularyTermDialog d = new AddVocabularyTermDialog(VocabularyTermSelectionWidget.this.viewContextOrNull, new RefreshAction(VocabularyTermSelectionWidget.this.getRawValue()));
                d.show();
            }
        }

        public abstract boolean condition();
    }

    private class RefreshAction
    implements IDelegatedAction {
        private String code;

        private RefreshAction(String code) {
            this.code = code;
        }

        @Override
        public void execute() {
            VocabularyTermSelectionWidget.this.typedValueOrNull = this.code;
            VocabularyTermSelectionWidget.this.refreshStore();
            VocabularyTermSelectionWidget.this.clearInvalid();
            VocabularyTermSelectionWidget.this.focus();
        }
    }

    private class AddVocabularyTermDialog
    extends AbstractRegistrationDialog {
        private static final int LABEL_WIDTH = 100;
        private static final int FIELD_WIDTH = 300;
        private final IViewContext<?> viewContext;
        private final LabelField codeField;
        private final DescriptionField descriptionField;
        private final TextField<String> labelField;
        private final VocabularyTermSelectionWidget termSelectionWidget;
        private RefreshAction refreshAction;

        public AddVocabularyTermDialog(IViewContext<?> viewContext, RefreshAction refreshAction) {
            super(viewContext, viewContext.getMessage("add_unofficial_vocabulary_term_dialog_title", new Object[0]), refreshAction);
            this.viewContext = viewContext;
            this.refreshAction = refreshAction;
            this.form.setLabelWidth(100);
            this.form.setFieldWidth(300);
            this.setWidth(450);
            this.codeField = new LabelField();
            this.codeField.setLabelSeparator(":");
            this.codeField.setFieldLabel(viewContext.getMessage("code", new Object[0]));
            this.codeField.setReadOnly(true);
            this.addField((Widget)this.codeField);
            boolean mandatory = false;
            this.labelField = AddVocabularyTermDialog.createTextField(viewContext.getMessage("label", new Object[0]), mandatory);
            this.labelField.setEmptyText("enter label");
            FieldUtil.setValueWithUnescaping(this.labelField, refreshAction.code);
            FieldUtil.setValueWithUnescaping(this.codeField, this.labelField.getValue() == null ? "" : CodeNormalizer.normalize((String)this.labelField.getValue()));
            this.labelField.setMaxLength(128);
            this.labelField.addKeyListener(new KeyListener(){

                public void handleEvent(ComponentEvent e) {
                    EventType type = e.getType();
                    if (type == Events.KeyPress || type == Events.KeyUp || type == Events.KeyDown) {
                        FieldUtil.setValueWithUnescaping(AddVocabularyTermDialog.this.codeField, AddVocabularyTermDialog.this.labelField.getValue() == null ? "" : CodeNormalizer.normalize((String)AddVocabularyTermDialog.this.labelField.getValue()));
                    }
                }
            });
            this.addField((Widget)this.labelField);
            this.descriptionField = AddVocabularyTermDialog.createDescriptionField(viewContext, mandatory);
            FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, "");
            this.addField((Widget)this.descriptionField);
            this.termSelectionWidget = this.createTermSelectionWidget();
            this.addField((Widget)this.termSelectionWidget);
            this.setFocusWidget((Widget)this.labelField);
        }

        @Override
        protected void register(AsyncCallback<Void> registrationCallback) {
            this.refreshAction.code = (String)this.codeField.getValue();
            this.viewContext.getCommonService().addUnofficialVocabularyTerm(TechId.create((IIdHolder)VocabularyTermSelectionWidget.this.vocabularyOrNull), this.refreshAction.code, ((String)this.labelField.getValue()).trim(), (String)this.descriptionField.getValue(), this.extractPreviousTermOrdinal(), registrationCallback);
        }

        private VocabularyTermSelectionWidget createTermSelectionWidget() {
            boolean mandatory = false;
            VocabularyTermSelectionWidget result = new VocabularyTermSelectionWidget(this.getId() + "_edit_pos", "Position after", mandatory, VocabularyTermSelectionWidget.this.vocabularyOrNull, this.viewContext, null, null, false);
            result.setEmptyText(result.emptyText = (result.chooseMsg = "empty value == beginning"));
            return result;
        }

        private Long extractPreviousTermOrdinal() {
            VocabularyTermModel selectedItem = (VocabularyTermModel)this.termSelectionWidget.getValue();
            return selectedItem != null ? selectedItem.getTerm().getOrdinal() : 0L;
        }
    }
}

