/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.file;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.util.Format;
import com.extjs.gxt.ui.client.widget.form.FileUploadField;
import java.util.ArrayList;
import java.util.List;

public abstract class FileFieldManager<T extends FileUploadField> {
    protected IMessageProvider messageProvider;
    private final String fieldLabel;
    private static final String FIELD_NAME_TEMPLATE = "{0}_{1}";
    private final List<T> fileFields;
    private final String sessionKey;

    protected FileFieldManager(String sessionKey, int initialNumberOfFields, String fieldLabel, IMessageProvider messageProvider) {
        this.messageProvider = messageProvider;
        this.sessionKey = sessionKey;
        this.fieldLabel = fieldLabel;
        this.fileFields = new ArrayList<T>();
        for (int i = 0; i < initialNumberOfFields; ++i) {
            this.fileFields.add(this.createFileUploadField(i));
        }
    }

    protected FileFieldManager(String sessionKey, int initialNumberOfFields, String fieldLabel) {
        this(sessionKey, initialNumberOfFields, fieldLabel, null);
    }

    public void setMandatory() {
        assert (this.fileFields.size() > 0);
        FileUploadField field = (FileUploadField)this.fileFields.get(0);
        field.setAllowBlank(false);
        FieldUtil.markAsMandatory(field);
    }

    public List<T> getFields() {
        return this.fileFields;
    }

    protected T addField() {
        int counter = this.fileFields.size();
        T field = this.createFileUploadField(counter);
        this.fileFields.add(field);
        return field;
    }

    public int filesDefined() {
        int i = 0;
        for (FileUploadField field : this.fileFields) {
            Object value = field.getValue();
            if (value == null || String.valueOf(value).length() <= 0) continue;
            ++i;
        }
        return i;
    }

    protected abstract T createFileUploadField();

    private final T createFileUploadField(int counter) {
        T file = this.createFileUploadField();
        int number = counter + 1;
        file.setFieldLabel(this.fieldLabel);
        file.setName(Format.substitute((String)FIELD_NAME_TEMPLATE, (Object[])new Object[]{this.sessionKey, number}));
        file.setId(Format.substitute((String)FIELD_NAME_TEMPLATE, (Object[])new Object[]{this.sessionKey, number}));
        return file;
    }
}

