/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IOnSuccessAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MetaprojectChooserButton;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IModification;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.EntityPropertyUpdates;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.IUpdateResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithProperties;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIsStub;
import ch.systemsx.cisd.openbis.generic.shared.basic.ITaggable;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractEntityGrid<E extends IEntityInformationHolderWithProperties & ITaggable>
extends TypedTableGrid<E> {
    public static final String TAG_BUTTON_ID_SUFFIX = "_tag";
    public static final String UNTAG_BUTTON_ID_SUFFIX = "_untag";
    public static final EventType ENTITY_TAGGED_EVENT = new EventType();
    public static final EventType ENTITY_UNTAGGED_EVENT = new EventType();

    public AbstractEntityGrid(IViewContext<ICommonClientServiceAsync> viewContext, String browserId, boolean refreshAutomatically, IDisplayTypeIDGenerator displayTypeIDGenerator) {
        super(viewContext, browserId, refreshAutomatically, displayTypeIDGenerator);
    }

    public AbstractEntityGrid(IViewContext<ICommonClientServiceAsync> viewContext, String browserId, IDisplayTypeIDGenerator displayTypeIDGenerator) {
        super(viewContext, browserId, displayTypeIDGenerator);
    }

    @Override
    protected boolean isEditable(BaseEntityModel<TableModelRowWithObject<E>> model, String columnID) {
        String propertyName = columnID.substring("property-".length());
        IEntityInformationHolderWithProperties sample = (IEntityInformationHolderWithProperties)model.getBaseObject().getObjectOrNull();
        BasicEntityType entityType = sample.getEntityType();
        IEntityProperty propertyOrNull = this.tryGetProperty(sample, propertyName);
        if (propertyOrNull != null && propertyOrNull.isScriptable()) {
            return false;
        }
        List columnDefinitions = this.getColumnDefinitions(Arrays.asList(columnID));
        IColumnDefinition columnDefinition = columnDefinitions.get(0);
        return columnDefinition.tryToGetProperty(entityType.getCode()) != null;
    }

    @Override
    protected void applyModifications(List<TypedTableGrid.ModelModificationsCallBack> modificationsListWithCallbacks, String resultSetKey) {
        ArrayList<EntityPropertyUpdates> allUpdates = new ArrayList<EntityPropertyUpdates>();
        final ArrayList<AsyncCallback<IUpdateResult>> callBacks = new ArrayList<AsyncCallback<IUpdateResult>>();
        for (TypedTableGrid.ModelModificationsCallBack item : modificationsListWithCallbacks) {
            EntityKind entityKind = this.getEntityKindOrNull();
            TechId entityId = new TechId(item.getModel().getBaseObject().getId());
            EntityPropertyUpdates updates = new EntityPropertyUpdates(resultSetKey, entityKind, entityId);
            for (IModification modification : item.getModifications()) {
                String propertyCode = modification.getColumnID().substring("property-".length());
                updates.addModifiedProperty(propertyCode, modification.tryGetNewValue());
            }
            allUpdates.add(updates);
            callBacks.add(item.getCallBack());
        }
        AsyncCallback<IUpdateResult> callBack = new AsyncCallback<IUpdateResult>(){

            public void onFailure(Throwable caught) {
                for (AsyncCallback asyncCallback : callBacks) {
                    asyncCallback.onFailure(caught);
                }
            }

            public void onSuccess(IUpdateResult result) {
                for (AsyncCallback asyncCallback : callBacks) {
                    asyncCallback.onSuccess((Object)result);
                }
            }
        };
        ((ICommonClientServiceAsync)this.viewContext.getService()).updateProperties(allUpdates, callBack);
    }

    @Override
    protected void showEntityViewer(TableModelRowWithObject<E> row, boolean editMode, boolean inBackground) {
        this.showEntityInformationHolderViewer((IEntityInformationHolderWithPermId)row.getObjectOrNull(), editMode, inBackground);
    }

    protected final GridCellRenderer<BaseEntityModel<?>> createShowDetailsLinkCellRenderer() {
        return LinkRenderer.createExternalLinkRenderer(this.viewContext.getMessage("show_details_link_text_value", new Object[0]));
    }

    protected String createDisplayIdSuffix(EntityKind entityKindOrNull, EntityType entityTypeOrNull) {
        String suffix = "";
        if (entityKindOrNull != null) {
            suffix = suffix + "-" + entityKindOrNull.toString();
        }
        if (entityTypeOrNull != null) {
            suffix = suffix + "-" + entityTypeOrNull.getCode();
        }
        return suffix;
    }

    private List<String> getMetaProjectsReferencedyByEachOf(List<ITaggable> taggables) {
        int itemCount = taggables.size();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (ITaggable taggable : taggables) {
            Collection<Metaproject> metaProjects = taggable.getMetaprojects();
            if (metaProjects == null) continue;
            for (Metaproject metaProject : metaProjects) {
                Integer count = (Integer)counts.get(metaProject.getName());
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                counts.put(metaProject.getName(), count);
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : counts.keySet()) {
            Integer count = (Integer)counts.get(name);
            if (count == null || count != itemCount) continue;
            result.add(name);
        }
        return result;
    }

    private List<String> getMetaProjectsReferencedByAtLeastOneOf(List<ITaggable> taggables) {
        HashSet<String> result = new HashSet<String>();
        for (ITaggable taggable : taggables) {
            Collection<Metaproject> metaprojects = taggable.getMetaprojects();
            if (metaprojects == null) continue;
            for (Metaproject metaProject : metaprojects) {
                result.add(metaProject.getName());
            }
        }
        return new ArrayList<String>(result);
    }

    protected final void addTaggingButtons() {
        this.addTaggingButtons(true);
    }

    protected final void addTaggingButtons(final boolean refresh) {
        MetaprojectChooserButton tagButton = new MetaprojectChooserButton(this.viewContext, this.getId(), new IChosenEntitiesProvider<String>(){

            @Override
            public List<String> getEntities() {
                List selectedItems = AbstractEntityGrid.this.getSelectedItems();
                ArrayList<ITaggable> taggables = new ArrayList<ITaggable>();
                for (BaseEntityModel model : selectedItems) {
                    taggables.add((ITaggable)model.getBaseObject().getObjectOrNull());
                }
                return AbstractEntityGrid.this.getMetaProjectsReferencedyByEachOf(taggables);
            }

            @Override
            public boolean isBlackList() {
                return true;
            }
        });
        tagButton.addChosenEntityListener(new IChosenEntitiesListener<TableModelRowWithObject<Metaproject>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void entitiesChosen(List<TableModelRowWithObject<Metaproject>> entities) {
                void var6_10;
                List selectedItems = AbstractEntityGrid.this.getSelectedItems();
                EntityKind entityKind = ((IEntityInformationHolderWithProperties)selectedItems.get(0).getBaseObject().getObjectOrNull()).getEntityKind();
                ArrayList<Long> entityIds = new ArrayList<Long>();
                for (BaseEntityModel baseEntityModel : selectedItems) {
                    entityIds.add(((IEntityInformationHolderWithProperties)baseEntityModel.getBaseObject().getObjectOrNull()).getId());
                }
                ArrayList<Long> metaProjectIds = new ArrayList<Long>();
                for (TableModelRowWithObject<Metaproject> tableModelRowWithObject : entities) {
                    metaProjectIds.add(tableModelRowWithObject.getObjectOrNull().getId());
                }
                if (refresh) {
                    AbstractAsyncCallback abstractAsyncCallback = AbstractEntityGrid.this.createRefreshCallback(AbstractEntityGrid.this.asActionInvoker());
                } else {
                    AbstractAsyncCallback abstractAsyncCallback = AbstractEntityGrid.this.createEmptyCallback();
                }
                AbstractEntityGrid.this.viewContext.getCommonService().assignEntitiesToMetaProjects(entityKind, metaProjectIds, entityIds, AbstractEntityGrid.this.fireEventOnSuccess((AbstractAsyncCallback)var6_10, ENTITY_TAGGED_EVENT));
            }
        });
        tagButton.setId(this.gridId + TAG_BUTTON_ID_SUFFIX);
        tagButton.setText(this.viewContext.getMessage("button_tag", new Object[0]));
        tagButton.setToolTip(this.viewContext.getMessage("button_tag_tooltip", new Object[0]));
        this.enableButtonOnSelectedItemsIfNoStubsAreSelected(tagButton);
        this.addButton(tagButton);
        MetaprojectChooserButton untagButton = new MetaprojectChooserButton(this.viewContext, this.getId(), new IChosenEntitiesProvider<String>(){

            @Override
            public List<String> getEntities() {
                List selectedItems = AbstractEntityGrid.this.getSelectedItems();
                ArrayList<ITaggable> taggables = new ArrayList<ITaggable>();
                for (BaseEntityModel model : selectedItems) {
                    taggables.add((ITaggable)model.getBaseObject().getObjectOrNull());
                }
                return AbstractEntityGrid.this.getMetaProjectsReferencedByAtLeastOneOf(taggables);
            }

            @Override
            public boolean isBlackList() {
                return false;
            }
        }, false);
        untagButton.addChosenEntityListener(new IChosenEntitiesListener<TableModelRowWithObject<Metaproject>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void entitiesChosen(List<TableModelRowWithObject<Metaproject>> entities) {
                void var6_10;
                List selectedItems = AbstractEntityGrid.this.getSelectedItems();
                EntityKind entityKind = ((IEntityInformationHolderWithProperties)selectedItems.get(0).getBaseObject().getObjectOrNull()).getEntityKind();
                ArrayList<Long> entityIds = new ArrayList<Long>();
                for (BaseEntityModel baseEntityModel : selectedItems) {
                    entityIds.add(((IEntityInformationHolderWithProperties)baseEntityModel.getBaseObject().getObjectOrNull()).getId());
                }
                ArrayList<Long> metaProjectIds = new ArrayList<Long>();
                for (TableModelRowWithObject<Metaproject> tableModelRowWithObject : entities) {
                    metaProjectIds.add(tableModelRowWithObject.getObjectOrNull().getId());
                }
                if (refresh) {
                    AbstractAsyncCallback abstractAsyncCallback = AbstractEntityGrid.this.createRefreshCallback(AbstractEntityGrid.this.asActionInvoker());
                } else {
                    AbstractAsyncCallback abstractAsyncCallback = AbstractEntityGrid.this.createEmptyCallback();
                }
                AbstractEntityGrid.this.viewContext.getCommonService().removeEntitiesFromMetaProjects(entityKind, metaProjectIds, entityIds, AbstractEntityGrid.this.fireEventOnSuccess((AbstractAsyncCallback)var6_10, ENTITY_UNTAGGED_EVENT));
            }
        });
        untagButton.setId(this.gridId + UNTAG_BUTTON_ID_SUFFIX);
        untagButton.setText(this.viewContext.getMessage("button_untag", new Object[0]));
        untagButton.setToolTip(this.viewContext.getMessage("button_untag_tooltip", new Object[0]));
        this.enableButtonOnSelectedItems(untagButton);
        this.addButton(untagButton);
    }

    private <T> AbstractAsyncCallback<T> fireEventOnSuccess(AbstractAsyncCallback<T> callback, final EventType eventType) {
        callback.addOnSuccessAction(new IOnSuccessAction<T>(){

            @Override
            public void execute(T result) {
                AbstractEntityGrid.this.fireEvent(eventType);
            }
        });
        return callback;
    }

    protected void enableButtonOnSelectedItemsIfNoStubsAreSelected(final Button button) {
        button.setEnabled(false);
        this.addGridSelectionChangeListener(new Listener<SelectionChangedEvent<ModelData>>(){

            public void handleEvent(SelectionChangedEvent<ModelData> se) {
                boolean enabled;
                List selectedItems = AbstractEntityGrid.this.getSelectedItems();
                ArrayList<1> selection = new ArrayList<1>();
                for (final BaseEntityModel model : selectedItems) {
                    selection.add(new IIsStub(){

                        @Override
                        public boolean isStub() {
                            return ((IIsStub)((Object)((IEntityInformationHolderWithProperties)((TableModelRowWithObject)model.getBaseObject()).getObjectOrNull()))).isStub();
                        }
                    });
                }
                if (selection.size() > 0) {
                    enabled = true;
                    for (IIsStub iIsStub : selection) {
                        if (!iIsStub.isStub()) continue;
                        enabled = false;
                    }
                } else {
                    enabled = false;
                }
                button.setEnabled(enabled);
            }
        });
    }
}

