/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.CommonViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.IColumnDefinitionUI;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.grid.CellEditor;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ColumnDefsAndConfigs<T> {
    private final List<ColumnConfig> columnConfigs = new ArrayList<ColumnConfig>();
    private final Set<IColumnDefinition<T>> columnDefs = new HashSet<IColumnDefinition<T>>();

    public static <T> ColumnDefsAndConfigs<T> create(List<? extends IColumnDefinitionUI<T>> columnsSchema, IViewContext<?> viewContext) {
        ColumnDefsAndConfigs<T> result = new ColumnDefsAndConfigs<T>();
        result.addColumns(columnsSchema, viewContext);
        return result;
    }

    private ColumnDefsAndConfigs() {
    }

    public void addColumns(List<? extends IColumnDefinitionUI<T>> columnsSchema, IViewContext<?> viewContext) {
        for (IColumnDefinitionUI<T> column : columnsSchema) {
            this.addColumn(column, viewContext);
        }
    }

    public void addColumn(IColumnDefinitionUI<T> column, GridCellRenderer<BaseEntityModel<?>> rendererOrNull, IViewContext<?> viewContext) {
        ColumnConfig columnConfig = ColumnDefsAndConfigs.createColumn(column, viewContext);
        if (rendererOrNull != null) {
            columnConfig.setRenderer(rendererOrNull);
        }
        this.addColumn(column, columnConfig);
    }

    private void addColumn(IColumnDefinitionUI<T> column, IViewContext<?> viewContext) {
        this.addColumn(column, ColumnDefsAndConfigs.createColumn(column, viewContext));
    }

    private void addColumn(IColumnDefinitionUI<T> column, ColumnConfig columnConfig) {
        this.columnConfigs.add(columnConfig);
        this.columnDefs.add(column);
    }

    public void setGridCellRendererFor(String columnID, GridCellRenderer<BaseEntityModel<?>> render) {
        for (ColumnConfig columnConfig : this.columnConfigs) {
            if (!columnConfig.getDataIndex().equals(columnID)) continue;
            columnConfig.setRenderer(render);
        }
    }

    private static <T> ColumnConfig createColumn(IColumnDefinitionUI<T> column, IViewContext<?> viewContext) {
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setSortable(true);
        columnConfig.setId(column.getIdentifier());
        String headerTitle = column.getHeader();
        columnConfig.setHeader(headerTitle);
        if (column.isNumeric()) {
            columnConfig.setAlignment(Style.HorizontalAlignment.RIGHT);
        }
        columnConfig.setWidth(column.getWidth());
        columnConfig.setHidden(column.isHidden());
        String toolTip = "[Click] to sort, [SHIFT+Click] to adjust the width, [Drag & Drop] to change order.";
        if (column.isEditable() && !CommonViewContext.ClientStaticState.isSimpleMode()) {
            toolTip = toolTip + " This is an editibale column. Just double-click on a cell.";
            CellEditor editor = ColumnUtils.createCellEditor(column, viewContext);
            columnConfig.setEditor(editor);
        }
        columnConfig.setToolTip(toolTip);
        return columnConfig;
    }

    public Set<IColumnDefinition<T>> getColumnDefs() {
        return this.columnDefs;
    }

    public List<ColumnConfig> getColumnConfigs() {
        return this.columnConfigs;
    }
}

