/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.core.XDOM;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.store.Record;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.grid.CheckBoxSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnHeader;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.RowExpander;
import com.extjs.gxt.ui.client.widget.grid.RowNumberer;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.google.gwt.dom.client.Style;
import java.util.ArrayList;
import java.util.List;

public class ExtendedGridView
extends GridView {
    protected ColumnHeader newColumnHeader() {
        this.header = new ColumnHeader((BoxComponent)this.grid, this.cm){

            protected ComponentEvent createColumnEvent(ColumnHeader pHeader, int column, Menu componentMenu) {
                GridEvent event = new GridEvent(ExtendedGridView.this.grid);
                event.setColIndex(column);
                event.setMenu(componentMenu);
                return event;
            }

            protected Menu getContextMenu(int column) {
                return ExtendedGridView.this.createContextMenu(column);
            }

            protected void onColumnSplitterMoved(int colIndex, int pWidth) {
                super.onColumnSplitterMoved(colIndex, pWidth);
                ExtendedGridView.this.onColumnSplitterMoved(colIndex, pWidth);
            }

            protected void onHeaderClick(ComponentEvent ce, int column) {
                super.onHeaderClick(ce, column);
                if (ce.isShiftKey()) {
                    ExtendedGridView.this.onHeaderClickWithShift((Grid<ModelData>)ExtendedGridView.this.grid, column);
                } else {
                    ExtendedGridView.this.onHeaderClick(ExtendedGridView.this.grid, column);
                }
            }
        };
        this.header.setSplitterWidth(this.splitterWidth);
        this.header.setMinColumnWidth(this.grid.getMinColumnWidth());
        return this.header;
    }

    protected void onHeaderClickWithShift(Grid<ModelData> pGrid, int column) {
        int margin = 10;
        int newWidth = this.calculateWidthWithScroll(pGrid, column) + margin;
        this.cm.setColumnWidth(column, newWidth);
    }

    private int calculateWidthWithScroll(Grid<ModelData> pGrid, int column) {
        GridView view = pGrid.getView();
        com.google.gwt.user.client.Element headerCell = (com.google.gwt.user.client.Element)view.getHeaderCell(this.calculateHeaderCellIndex(pGrid, column));
        headerCell = (com.google.gwt.user.client.Element)headerCell.getFirstChildElement();
        headerCell.getStyle().setWidth(0.0, Style.Unit.PX);
        int max = headerCell.getScrollWidth();
        headerCell.getStyle().setProperty("width", "auto");
        for (int i = 0; i < pGrid.getStore().getCount(); ++i) {
            com.google.gwt.user.client.Element td = (com.google.gwt.user.client.Element)view.getCell(i, column);
            List<Node> nodes = this.extractNodes(td);
            for (Node n : nodes) {
                Element e;
                if (!Element.is((Node)n) || (e = Element.as((Node)n)).getTagName().equalsIgnoreCase("img")) continue;
                e.getStyle().setWidth(0.0, Style.Unit.PX);
            }
            com.google.gwt.user.client.Element element = (com.google.gwt.user.client.Element)td.getFirstChildElement();
            element.getStyle().setWidth(0.0, Style.Unit.PX);
            int width = element.getScrollWidth();
            element.getStyle().setProperty("width", "auto");
            if (width <= max) continue;
            max = width;
        }
        return max;
    }

    private List<Node> extractNodes(com.google.gwt.user.client.Element element) {
        ArrayList<Node> visited = new ArrayList<Node>();
        ArrayList<Object> toVisit = new ArrayList<Object>();
        toVisit.add(element);
        while (!toVisit.isEmpty()) {
            Node n = (Node)toVisit.get(0);
            toVisit.remove(n);
            if (visited.contains(n)) continue;
            visited.add(n);
            NodeList childNodes = n.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node c = childNodes.getItem(j);
                if (toVisit.contains(c)) continue;
                toVisit.add(c);
            }
        }
        return visited;
    }

    private int calculateHeaderCellIndex(Grid<ModelData> pGrid, int column) {
        int headerCellIndex = column;
        for (int i = 0; i < column; ++i) {
            if (!pGrid.getColumnModel().getColumn(i).isHidden()) continue;
            --headerCellIndex;
        }
        return headerCellIndex;
    }

    protected String doRender(List<ColumnData> cs, List<ModelData> rows, int startRow, int colCount, boolean stripe) {
        int last = colCount - 1;
        String tstyle = "width:" + this.getTotalWidth() + "px;";
        StringBuilder buf = new StringBuilder();
        for (int j = 0; j < rows.size(); ++j) {
            ModelData model = rows.get(j);
            Record r = this.ds.hasRecord(model = this.prepareData(model)) ? this.ds.getRecord(model) : null;
            int rowBodyColSpanCount = colCount;
            if (this.enableRowBody) {
                Object sm;
                if (this.grid.getSelectionModel() instanceof CheckBoxSelectionModel && this.cm.getColumnById((sm = (CheckBoxSelectionModel)this.grid.getSelectionModel()).getColumn().getId()) != null) {
                    --rowBodyColSpanCount;
                }
                sm = this.cm.getColumns().iterator();
                while (sm.hasNext()) {
                    ColumnConfig c = (ColumnConfig)sm.next();
                    if (!(c instanceof RowExpander) && !(c instanceof RowNumberer)) continue;
                    --rowBodyColSpanCount;
                }
            }
            int rowIndex = j + startRow;
            if (GXT.isAriaEnabled()) {
                buf.append("<div role=\"row\" aria-level=\"2\" class=\"x-grid3-row ");
            } else {
                buf.append("<div class=\"x-grid3-row ");
            }
            if (stripe && (rowIndex + 1) % 2 == 0) {
                buf.append(" x-grid3-row-alt");
            }
            if (!this.selectable) {
                buf.append(" x-unselectable-single");
            }
            if (super.isShowDirtyCells() && r != null && r.isDirty()) {
                buf.append(" x-grid3-dirty-row");
            }
            if (this.viewConfig != null) {
                buf.append(" ");
                buf.append(this.viewConfig.getRowStyle(model, rowIndex, this.ds));
            }
            buf.append("\" style=\"");
            buf.append(tstyle);
            buf.append("\" id=\"");
            buf.append(this.grid.getId());
            buf.append("_");
            buf.append(this.ds.getKeyProvider() != null ? this.ds.getKeyProvider().getKey(model) : XDOM.getUniqueId());
            buf.append("\" unselectable=\"");
            buf.append(this.selectable ? "off" : "on");
            buf.append("\"><table class=x-grid3-row-table role=presentation border=0 cellspacing=0 cellpadding=0 style=\"");
            buf.append(tstyle);
            buf.append("\"><tbody role=presentation><tr role=presentation>");
            this.widgetList.add(rowIndex, new ArrayList());
            for (int i = 0; i < colCount; ++i) {
                BaseEntityModel baseEntityModel;
                ColumnConfig cc;
                ColumnData c = cs.get(i);
                c.css = c.css == null ? "" : c.css;
                String rv = this.getRenderedValue(c, rowIndex, i, model, c.name);
                String role = "gridcell";
                if (GXT.isAriaEnabled() && (cc = this.cm.getColumn(i)).isRowHeader()) {
                    role = "rowheader";
                }
                String attr = c.cellAttr != null ? c.cellAttr : "";
                String cellAttr = c.cellAttr != null ? c.cellAttr : "";
                buf.append("<td id=\"" + XDOM.getUniqueId() + "\" role=\"" + role + "\" class=\"x-grid3-col x-grid3-cell x-grid3-td-");
                buf.append(c.id);
                buf.append(" ");
                buf.append(i == 0 ? "x-grid-cell-first " : (i == last ? "x-grid3-cell-last " : ""));
                if (c.css != null) {
                    buf.append(c.css);
                }
                if (super.isShowInvalidCells() && r != null && !r.isValid(c.name)) {
                    buf.append(" x-grid3-invalid-cell");
                }
                if (super.isShowDirtyCells() && r != null && r.getChanges().containsKey(c.name)) {
                    buf.append(" x-grid3-dirty-cell");
                } else if (model instanceof BaseEntityModel && (baseEntityModel = (BaseEntityModel)model).isOutdated() && baseEntityModel.isOutdatable(c.name)) {
                    buf.append(" cisd-grid-outdated-cell");
                }
                buf.append("\" style=\"");
                buf.append(c.style);
                buf.append("\" ");
                buf.append(cellAttr);
                buf.append("><div unselectable=\"");
                buf.append(this.selectable ? "off" : "on");
                buf.append("\" class=\"x-grid3-cell-inner x-grid3-col-");
                buf.append(c.id);
                buf.append("\" ");
                buf.append(attr);
                buf.append(">");
                buf.append(rv);
                buf.append("</div></td>");
            }
            buf.append("</tr>");
            if (this.enableRowBody) {
                buf.append("<tr class=x-grid3-row-body-tr style=\"\"><td colspan=");
                buf.append(rowBodyColSpanCount);
                buf.append(" class=x-grid3-body-cell><div class=x-grid3-row-body>${body}</div></td></tr>");
            }
            buf.append("</tbody></table></div>");
        }
        return buf.toString();
    }
}

