/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.TextColumnFilterWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.IColumnFilterWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridColumnFilterInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.util.DelayedTask;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class ListColumnFilterWidget<T>
extends ComboBox<ModelData>
implements IColumnFilterWidget<T> {
    static final int FILTER_APPLICATION_TIMEOUT_MS = 500;
    private static final String MODEL_DISPLAY_KEY = "unescaped_value";
    private static final String MODEL_ESCAPED_DISPLAY_KEY = "escaped_value";
    private static final String MODEL_VALUE_KEY = "value";
    private static final String EMPTY_VALUE = "(empty)";
    private IColumnDefinition<T> filteredField;
    private final IDelegatedAction onFilterAction;
    private final DelayedTask delayedFilterApplierTask;
    private boolean disableApply = false;
    private boolean comboBoxValueSelected = false;
    private String gridId;

    public ListColumnFilterWidget(IColumnDefinition<T> filteredField, final IDelegatedAction onFilterAction, List<String> distinctValues, String gridId) {
        this.filteredField = filteredField;
        this.onFilterAction = onFilterAction;
        this.delayedFilterApplierTask = ListColumnFilterWidget.createFilterApplierTask(onFilterAction);
        this.setDisplayField(MODEL_DISPLAY_KEY);
        this.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<ModelData>(){

            public void selectionChanged(SelectionChangedEvent<ModelData> event) {
                if (!ListColumnFilterWidget.this.disableApply) {
                    ListColumnFilterWidget.this.comboBoxValueSelected = true;
                    onFilterAction.execute();
                }
            }
        });
        this.setStore(distinctValues);
        this.setWidth(100);
        this.setValidateOnBlur(false);
        String label = filteredField.getHeader();
        this.setEmptyText(label);
        this.setToolTip(label);
        this.setTemplate(GWTUtils.getTooltipTemplate(MODEL_ESCAPED_DISPLAY_KEY, "tooltip"));
        GWTUtils.setupAutoWidth(this);
        this.setId(gridId + "-" + label);
        this.gridId = gridId;
    }

    private static DelayedTask createFilterApplierTask(final IDelegatedAction onFilterAction) {
        return new DelayedTask((Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                onFilterAction.execute();
            }
        });
    }

    protected void onKeyUp(FieldEvent fe) {
        this.comboBoxValueSelected = false;
        if (!fe.isSpecialKey() || fe.getKeyCode() == 8) {
            this.delayedFilterApplierTask.delay(500);
        }
    }

    private void setStore(List<String> distinctValues) {
        ListStore<ModelData> myStore = this.getStore();
        if (myStore == null) {
            myStore = DropDownList.createEmptyStoreWithContainsFilter(this);
            this.setStore(myStore);
        }
        myStore.removeAll();
        myStore.add(ListColumnFilterWidget.createModels(distinctValues));
    }

    private static List<ModelData> createModels(List<String> distinctValues) {
        ArrayList<ModelData> models = new ArrayList<ModelData>();
        for (String value : distinctValues) {
            BaseModelData model = new BaseModelData();
            String displayValue = value;
            if (displayValue == null || displayValue.length() == 0) {
                displayValue = EMPTY_VALUE;
            }
            model.set(MODEL_DISPLAY_KEY, (Object)displayValue);
            displayValue = StringEscapeUtils.escapeHtml(displayValue);
            model.set(MODEL_ESCAPED_DISPLAY_KEY, (Object)displayValue);
            model.set("tooltip", (Object)StringEscapeUtils.escapeHtml(displayValue));
            model.set(MODEL_VALUE_KEY, (Object)value);
            models.add((ModelData)model);
        }
        return models;
    }

    @Override
    public IColumnFilterWidget<T> createOrRefresh(List<String> distinctValuesOrNull) {
        if (distinctValuesOrNull == null) {
            return new TextColumnFilterWidget<T>(this.filteredField, this.onFilterAction, this.gridId);
        }
        if (!distinctValuesOrNull.equals(this.getCurrentStoreValues())) {
            this.setStore(distinctValuesOrNull);
        }
        return this;
    }

    private List<String> getCurrentStoreValues() {
        ArrayList<String> storeValues = new ArrayList<String>();
        for (ModelData model : this.getStore().getModels()) {
            storeValues.add(ListColumnFilterWidget.getValue(model));
        }
        return storeValues;
    }

    private static String getValue(ModelData model) {
        return (String)model.get(MODEL_VALUE_KEY);
    }

    @Override
    public GridColumnFilterInfo<T> getFilter() {
        return new GridColumnFilterInfo<T>(this.filteredField, this.tryGetFilterPattern());
    }

    private String tryGetFilterPattern() {
        String pattern = this.getRawValue();
        if (pattern == null || pattern.length() == 0) {
            pattern = null;
        } else if (pattern.equals(EMPTY_VALUE)) {
            pattern = "^$";
        } else if (this.comboBoxValueSelected) {
            pattern = "'^" + pattern + "$'";
        }
        return pattern;
    }

    @Override
    public String getFilteredColumnId() {
        return this.filteredField.getIdentifier();
    }

    @Override
    public void setFilteredField(IColumnDefinition<T> filteredField) {
        this.filteredField = filteredField;
    }

    @Override
    public Widget getWidget() {
        return this;
    }

    public void reset() {
        this.disableApply = true;
        this.comboBoxValueSelected = false;
        super.reset();
        this.disableApply = false;
    }
}

