/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IModification;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.Modification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ModificationsData<T extends Serializable> {
    private final Map<BaseEntityModel<TableModelRowWithObject<T>>, List<IModification>> modificationsByModel = new LinkedHashMap<BaseEntityModel<TableModelRowWithObject<T>>, List<IModification>>();
    private final Map<BaseEntityModel<TableModelRowWithObject<T>>, String> failedModifications = new HashMap<BaseEntityModel<TableModelRowWithObject<T>>, String>();
    private int finishedModifications;
    private boolean saving;

    public void clearData() {
        this.saving = false;
        this.finishedModifications = 0;
        this.failedModifications.clear();
        this.modificationsByModel.clear();
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void handleModifications(IModificationsHandler<T> handler) {
        this.saving = true;
        this.finishedModifications = 0;
        handler.applyModifications(this.modificationsByModel);
    }

    public void addModification(BaseEntityModel<TableModelRowWithObject<T>> model, String columnID, String newValueOrNull) {
        List<IModification> modificationsForModel = this.modificationsByModel.get(model);
        if (modificationsForModel == null) {
            modificationsForModel = new ArrayList<IModification>();
            this.modificationsByModel.put(model, modificationsForModel);
        }
        modificationsForModel.add(new Modification(columnID, newValueOrNull));
    }

    public void handleResponseAfterModificationHasBeenApplied(BaseEntityModel<TableModelRowWithObject<T>> model, String errorMessageOrNull) {
        ++this.finishedModifications;
        if (errorMessageOrNull != null) {
            this.failedModifications.put(model, errorMessageOrNull);
        }
    }

    public boolean isApplyModificationsComplete() {
        return this.finishedModifications == this.modificationsByModel.size();
    }

    public boolean hasFailedModifications() {
        return !this.failedModifications.isEmpty();
    }

    public String createFailureTitle() {
        return this.failedModifications.size() == this.modificationsByModel.size() ? "Operation failed" : "Operation partly failed";
    }

    public String createFailedModificationsReport() {
        assert (this.failedModifications.size() > 0);
        StringBuilder result = new StringBuilder();
        result.append("Modifications of " + this.failedModifications.size() + " entities failed:");
        for (String error : this.failedModifications.values()) {
            result.append("<br/>- " + error);
        }
        return result.toString();
    }

    public static interface IModificationsHandler<T extends Serializable> {
        public void applyModifications(Map<BaseEntityModel<TableModelRowWithObject<T>>, List<IModification>> var1);
    }
}

