/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ListColumnFilterWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.IColumnFilterWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridColumnFilterInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.widget.form.StoreFilterField;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class TextColumnFilterWidget<T>
extends StoreFilterField<ModelData>
implements IColumnFilterWidget<T> {
    private IColumnDefinition<T> filteredField;
    private final IDelegatedAction onFilterAction;
    private boolean disableApply = false;
    private String gridId;

    public TextColumnFilterWidget(IColumnDefinition<T> filteredField, IDelegatedAction onFilterAction, String gridId) {
        this.filteredField = filteredField;
        this.onFilterAction = onFilterAction;
        this.setWidth(100);
        String label = filteredField.getHeader();
        this.setEmptyText(label);
        this.setToolTip(label);
        this.setValidationDelay(500);
        this.setId(gridId + "-" + label);
        this.gridId = gridId;
    }

    @Override
    public String getFilteredColumnId() {
        return this.filteredField.getIdentifier();
    }

    @Override
    public GridColumnFilterInfo<T> getFilter() {
        String pattern = this.getRawValue();
        if (pattern.length() == 0) {
            pattern = null;
        }
        return new GridColumnFilterInfo<T>(this.filteredField, pattern);
    }

    protected void onFilter() {
        if (!this.disableApply) {
            super.onFilter();
            this.onFilterAction.execute();
        }
    }

    protected boolean doSelect(Store<ModelData> store, ModelData parent, ModelData record, String property, String filterText) {
        return true;
    }

    @Override
    public Widget getWidget() {
        return this;
    }

    @Override
    public void setFilteredField(IColumnDefinition<T> filteredField) {
        this.filteredField = filteredField;
    }

    @Override
    public IColumnFilterWidget<T> createOrRefresh(List<String> distinctValuesOrNull) {
        if (distinctValuesOrNull == null) {
            return this;
        }
        return new ListColumnFilterWidget<T>(this.filteredField, this.onFilterAction, distinctValuesOrNull, this.gridId);
    }

    public void reset() {
        this.disableApply = true;
        super.reset();
        this.disableApply = false;
    }
}

