/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IParameterField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ParameterField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisplayTypeIDProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.TextColumnFilterWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.FilterModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.FilterSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.IColumnFilterWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ColumnDistinctValues;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.CustomFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridColumnFilterInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridFilters;
import ch.systemsx.cisd.openbis.generic.shared.basic.IColumnDefinition;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ParameterWithValue;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableGridColumnDefinition;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.button.ButtonGroup;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FilterToolbar<T>
extends ToolBar
implements IDatabaseModificationObserver {
    static final String APPLY_ID = "apply_button";
    static final String RESET_ID = "reset_button";
    private final IMessageProvider messageProvider;
    private final List<IColumnFilterWidget<T>> columnFilters;
    private final ContentPanel filterContainer;
    private final Collection<IParameterField> parameterFields;
    private final FilterSelectionWidget filterSelectionWidget;
    private final IDelegatedAction applyFiltersAction;
    private final TextToolItem applyTool;
    private final TextToolItem resetTool;
    private boolean disableApply = false;
    private static final int MAX_FILTER_FIELDS_COLUMNS = 6;
    private static final int MAX_FILTER_FIELDS_ROWS = 4;
    public static final int MAX_FILTER_FIELDS = 24;
    private String gridId;

    public FilterToolbar(IViewContext<ICommonClientServiceAsync> viewContext, String gridId, IDisplayTypeIDProvider displayTypeIDProvider, IDelegatedAction applyFiltersAction) {
        int logID = viewContext.log("create filter toolbar for " + gridId);
        this.messageProvider = viewContext;
        this.columnFilters = new ArrayList<IColumnFilterWidget<T>>();
        this.applyFiltersAction = applyFiltersAction;
        this.add((Component)new LabelToolItem(this.messageProvider.getMessage("filter", new Object[0]) + ": "));
        this.filterSelectionWidget = new FilterSelectionWidget(viewContext, gridId, displayTypeIDProvider);
        this.filterContainer = new ButtonGroup(6);
        this.parameterFields = new HashSet<IParameterField>();
        this.add((Component)this.filterSelectionWidget);
        this.add((Component)this.filterContainer);
        this.applyTool = new TextToolItem(this.messageProvider.getMessage("apply_filter", new Object[0]));
        this.applyTool.setId(FilterToolbar.createId(APPLY_ID, gridId));
        this.applyTool.setEnabled(false);
        this.applyTool.hide();
        this.add((Component)this.applyTool);
        this.resetTool = new TextToolItem(this.messageProvider.getMessage("reset_filter", new Object[0]));
        this.resetTool.setId(FilterToolbar.createId(RESET_ID, gridId));
        this.add((Component)this.resetTool);
        this.filterSelectionWidget.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<FilterModel>(){

            public void selectionChanged(SelectionChangedEvent<FilterModel> se) {
                FilterToolbar.this.updateFilterFields();
                FilterToolbar.this.apply();
            }
        });
        this.filterSelectionWidget.addPostRefreshCallback(new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
                FilterToolbar.this.updateFilterFields();
                FilterToolbar.this.apply();
            }
        });
        this.applyTool.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                FilterToolbar.this.apply();
            }
        });
        this.resetTool.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                FilterToolbar.this.resetFilterFields();
                FilterToolbar.this.apply();
            }
        });
        viewContext.logStop(logID);
        this.gridId = gridId;
        this.setId(gridId + "-filter-toolbar");
    }

    public static String createId(String prefix, String gridId) {
        return "openbis_" + prefix + gridId;
    }

    private boolean isColumnFilterSelected() {
        return !this.isCustomFilterSelected();
    }

    private boolean isCustomFilterSelected() {
        return this.getCustomFilterSelectedState(false);
    }

    private boolean getCustomFilterSelectedState(boolean requiredState) {
        GridCustomFilter selected = (GridCustomFilter)this.filterSelectionWidget.tryGetSelected();
        return selected != null && selected.getName().equals("Column Filter") == requiredState;
    }

    private CustomFilterInfo<T> tryGetCustomFilter() {
        if (this.isCustomFilterSelected() && this.isValid()) {
            GridCustomFilter selected = (GridCustomFilter)this.filterSelectionWidget.tryGetSelected();
            CustomFilterInfo info = new CustomFilterInfo();
            info.setExpression(selected.getExpression());
            HashSet<ParameterWithValue> parameters = new HashSet<ParameterWithValue>();
            for (IParameterField parameterField : this.parameterFields) {
                parameters.add(parameterField.getParameterWithValue());
            }
            info.setParameters(parameters);
            return info;
        }
        return null;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.filterSelectionWidget.getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.filterSelectionWidget.update(observedModifications);
    }

    private void updateFilterFields() {
        boolean isFilterSelectionWidgetVisible = this.filterSelectionWidget.getStore().getCount() > 1;
        this.filterSelectionWidget.setVisible(isFilterSelectionWidgetVisible);
        this.filterContainer.removeAll();
        if (this.isColumnFilterSelected()) {
            this.updateFilterContainer(FilterToolbar.getColumnFilterWidgets(this.columnFilters));
            this.applyTool.hide();
        } else {
            GridCustomFilter filter = (GridCustomFilter)this.filterSelectionWidget.tryGetSelected();
            if (filter != null) {
                this.updateFilterContainer(this.createCustomFilterWidgets(filter));
                this.applyTool.show();
                this.updateApplyToolEnabledState();
            }
        }
        this.resetTool.setVisible(this.filterContainer.getItemCount() > 0);
    }

    private static <T> List<Widget> getColumnFilterWidgets(List<IColumnFilterWidget<T>> columnFilters) {
        ArrayList<Widget> filterWidgets = new ArrayList<Widget>();
        for (IColumnFilterWidget<T> filterWidget : columnFilters) {
            filterWidgets.add(filterWidget.getWidget());
        }
        return filterWidgets;
    }

    private List<Widget> createCustomFilterWidgets(GridCustomFilter filter) {
        ArrayList<Widget> filterWidgets = new ArrayList<Widget>();
        IDelegatedAction updateApplyButtonAction = new IDelegatedAction(){

            @Override
            public void execute() {
                FilterToolbar.this.updateApplyToolEnabledState();
            }
        };
        this.parameterFields.clear();
        for (String parameter : filter.getParameters()) {
            IParameterField parameterField = ParameterField.create(null, parameter, null, updateApplyButtonAction, null);
            this.parameterFields.add(parameterField);
            filterWidgets.add((Widget)parameterField.asWidget());
        }
        return filterWidgets;
    }

    private void updateFilterContainer(List<Widget> filterWidgets) {
        int i;
        this.filterContainer.hide();
        boolean changed = false;
        this.filterContainer.disableEvents(true);
        for (i = 0; i < filterWidgets.size(); ++i) {
            Widget filterWidget = filterWidgets.get(i);
            if (i < this.filterContainer.getItemCount()) {
                Component previousItem = this.filterContainer.getItem(i);
                if (previousItem.equals(filterWidget)) continue;
                this.filterContainer.remove((Widget)previousItem);
                this.filterContainer.insert(filterWidget, i);
                changed = true;
                continue;
            }
            this.filterContainer.add(filterWidget);
            changed = true;
        }
        for (i = filterWidgets.size(); i < this.filterContainer.getItemCount(); ++i) {
            this.filterContainer.remove((Widget)this.filterContainer.getItem(i));
            changed = true;
        }
        this.filterContainer.enableEvents(true);
        if (this.filterContainer.getItemCount() > 0) {
            this.filterContainer.show();
        }
        if (changed) {
            this.layout();
        }
    }

    public void resetFilterFields() {
        for (Component field : this.filterContainer.getItems()) {
            if (!(field instanceof Field)) continue;
            ((Field)field).reset();
        }
        this.updateApplyToolEnabledState();
    }

    public void resetFilterSelectionWithoutApply() {
        this.disableApply = true;
        this.filterSelectionWidget.reset();
        this.disableApply = false;
    }

    private void apply() {
        if (!this.disableApply) {
            this.applyFiltersAction.execute();
        }
    }

    private void updateApplyToolEnabledState() {
        this.applyTool.setEnabled(this.isValid());
    }

    private boolean isValid() {
        if (this.isCustomFilterSelected()) {
            boolean valid = true;
            for (IParameterField parameterField : this.parameterFields) {
                valid = parameterField.asWidget().isValid() && valid;
            }
            return valid;
        }
        return true;
    }

    public void refreshAndReset() {
        this.refresh();
        this.resetFilterFields();
    }

    public void refresh() {
        this.filterSelectionWidget.refreshStore();
    }

    public GridFilters<T> getFilters() {
        if (this.isColumnFilterSelected()) {
            return GridFilters.createColumnFilter(this.getColumnFiltersInfo());
        }
        CustomFilterInfo<T> customFilter = this.tryGetCustomFilter();
        if (customFilter != null) {
            return GridFilters.createCustomFilter(customFilter);
        }
        return GridFilters.createEmptyFilter();
    }

    private List<GridColumnFilterInfo<T>> getColumnFiltersInfo() {
        ArrayList<GridColumnFilterInfo<T>> filters = new ArrayList<GridColumnFilterInfo<T>>();
        for (IColumnFilterWidget<T> filterWidget : this.columnFilters) {
            filters.add(filterWidget.getFilter());
        }
        return filters;
    }

    public void refreshColumnFiltersDistinctValues(List<ColumnDistinctValues> columnDistinctValues) {
        ArrayList<IColumnFilterWidget<T>> newColumnFilters = new ArrayList<IColumnFilterWidget<T>>();
        boolean refreshNeeded = false;
        for (IColumnFilterWidget<T> columnFilter : this.columnFilters) {
            ColumnDistinctValues distinctValues = FilterToolbar.tryFindForColumn(columnFilter.getFilteredColumnId(), columnDistinctValues);
            List<String> valuesOrNull = distinctValues == null ? null : distinctValues.getDistinctValues();
            IColumnFilterWidget<T> newFilter = columnFilter.createOrRefresh(valuesOrNull);
            refreshNeeded = refreshNeeded || newFilter != columnFilter;
            newColumnFilters.add(newFilter);
        }
        if (refreshNeeded) {
            this.updateColumnFilters(newColumnFilters);
        }
    }

    private static ColumnDistinctValues tryFindForColumn(String columnId, List<ColumnDistinctValues> columnDistinctValues) {
        for (ColumnDistinctValues columnValues : columnDistinctValues) {
            if (!columnValues.getColumnIdentifier().equals(columnId)) continue;
            return columnValues;
        }
        return null;
    }

    public boolean rebuildColumnFilters(List<IColumnDefinition<T>> filteredColumns) {
        if (this.hasFilteredColumnsChanged(filteredColumns, this.columnFilters)) {
            List<IColumnFilterWidget<T>> newColumnFilters = FilterToolbar.createColumnFilterWidgets(this.pruneIfNecessary(filteredColumns), this.columnFilters, this.applyFiltersAction, this.gridId);
            this.updateColumnFilters(newColumnFilters);
            return true;
        }
        return false;
    }

    private List<IColumnDefinition<T>> pruneIfNecessary(List<IColumnDefinition<T>> filteredColumns) {
        if (filteredColumns.size() > 24) {
            GWTUtils.alert("Warning", "Only up to 24 column filters can be used at the same time for one table.");
            return filteredColumns.subList(0, 24);
        }
        return filteredColumns;
    }

    private void updateColumnFilters(List<IColumnFilterWidget<T>> newColumnFilters) {
        this.columnFilters.clear();
        this.columnFilters.addAll(newColumnFilters);
        this.updateFilterFields();
    }

    private boolean hasFilteredColumnsChanged(List<IColumnDefinition<T>> filters1, List<IColumnFilterWidget<T>> filters2) {
        if (filters1.size() != filters2.size()) {
            return true;
        }
        for (int i = 0; i < filters1.size(); ++i) {
            IColumnDefinition<T> filter1 = filters1.get(i);
            IColumnDefinition<T> filter2 = filters2.get(i).getFilter().getFilteredField();
            if (!filter1.getIdentifier().equals(filter2.getIdentifier())) {
                return true;
            }
            if (!(filter1 instanceof TypedTableGridColumnDefinition) || !(filter2 instanceof TypedTableGridColumnDefinition)) continue;
            TypedTableGridColumnDefinition coldef1 = (TypedTableGridColumnDefinition)filter1;
            TypedTableGridColumnDefinition coldef2 = (TypedTableGridColumnDefinition)filter2;
            if (coldef1.getIndex() == coldef2.getIndex()) continue;
            return true;
        }
        return false;
    }

    private static <T> List<IColumnFilterWidget<T>> createColumnFilterWidgets(List<IColumnDefinition<T>> availableFilters, List<IColumnFilterWidget<T>> previousColumnFilters, IDelegatedAction onFilterAction, String gridId) {
        ArrayList<IColumnFilterWidget<T>> filterWidgets = new ArrayList<IColumnFilterWidget<T>>();
        for (IColumnDefinition<T> columnDefinition : availableFilters) {
            IColumnFilterWidget<T> filterWidget = FilterToolbar.tryFindColumnFilter(columnDefinition.getIdentifier(), previousColumnFilters);
            if (filterWidget == null) {
                filterWidget = new TextColumnFilterWidget<T>(columnDefinition, onFilterAction, gridId);
            } else {
                filterWidget.setFilteredField(columnDefinition);
            }
            filterWidgets.add(filterWidget);
        }
        return filterWidgets;
    }

    private static <T> IColumnFilterWidget<T> tryFindColumnFilter(String columnId, List<IColumnFilterWidget<T>> columnFilters) {
        for (IColumnFilterWidget<T> columnFilter : columnFilters) {
            if (!columnFilter.getFilteredColumnId().equals(columnId)) continue;
            return columnFilter;
        }
        return null;
    }

    public List<String> extractFilteredColumnIds() {
        return FilterToolbar.extractColumnIds(this.columnFilters);
    }

    private static <T> List<String> extractColumnIds(List<IColumnFilterWidget<T>> columns) {
        ArrayList<String> filteredColumnsIds = new ArrayList<String>();
        for (IColumnFilterWidget<T> column : columns) {
            filteredColumnsIds.add(column.getFilteredColumnId());
        }
        return filteredColumnsIds;
    }
}

