/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common.AbstractGridCustomExpressionEditOrRegisterDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExpression;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GridCustomFilterGrid
extends TypedTableGrid<GridCustomFilter> {
    private static final String BROWSER_ID = "openbis_filter-browser";
    protected final String gridDisplayId;
    private final AbstractColumnSettingsDataModelProvider columnDataModelProvider;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, String gridDisplayId, AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
        return new GridCustomFilterGrid(viewContext, gridDisplayId, columnDataModelProvider).asDisposableWithoutToolbar();
    }

    static final String createAddButtonId(String gridDisplayId) {
        return GridCustomFilterGrid.createGridId(gridDisplayId) + "_ADD_BUTTON";
    }

    static final String createGridId(String gridDisplayId) {
        return GridCustomFilterGrid.createBrowserId(gridDisplayId) + "_grid";
    }

    private static final String createBrowserId(String gridDisplayId) {
        return BROWSER_ID + (gridDisplayId != null ? "_" + gridDisplayId : "");
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add", this.viewContext.getMessage("filter", new Object[0])), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                GridCustomFilterGrid.this.createAddDialog().show();
            }
        });
        addButton.setId(GridCustomFilterGrid.createAddButtonId(this.gridDisplayId));
        this.addButton(addButton);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<GridCustomFilter>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<GridCustomFilter>> selectedItem, boolean keyPressed) {
                GridCustomFilter selected = selectedItem.getBaseObject().getObjectOrNull();
                GridCustomFilterGrid.this.createEditDialog(selected).show();
            }
        });
        this.addButton(editButton);
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(){

            protected Dialog createDialog(List<TableModelRowWithObject<GridCustomFilter>> selected, IBrowserGridActionInvoker invoker) {
                return new DeletionConfirmationDialog(GridCustomFilterGrid.this.viewContext, selected, GridCustomFilterGrid.this.createRefreshCallback(invoker));
            }
        });
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    private Window createAddDialog() {
        return new AddDialog(this.viewContext, this.createRefreshGridAction(), this.gridDisplayId, this.columnDataModelProvider);
    }

    private Window createEditDialog(AbstractExpression updatedItem) {
        return new EditDialog((IViewContext<ICommonClientServiceAsync>)this.viewContext, this.createRefreshGridAction(), this.gridDisplayId, this.columnDataModelProvider, updatedItem);
    }

    private GridCustomFilterGrid(IViewContext<ICommonClientServiceAsync> viewContext, String gridDisplayId, AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
        super(viewContext, GridCustomFilterGrid.createBrowserId(gridDisplayId), true, DisplayTypeIDGenerator.FILTER_BROWSER_GRID);
        this.gridDisplayId = gridDisplayId;
        this.columnDataModelProvider = columnDataModelProvider;
        this.extendBottomToolbar();
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<GridCustomFilter>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<GridCustomFilter>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listFilters(this.gridDisplayId, resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<GridCustomFilter>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportFilters(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("NAME", "IS_PUBLIC");
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<GridCustomFilter>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<GridCustomFilter>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("EXPRESSION", this.createMultilineStringCellRenderer());
        return schema;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.GRID_CUSTOM_FILTER), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.GRID_CUSTOM_FILTER)};
    }

    private static class DeletionConfirmationDialog
    extends AbstractDataConfirmationDialog<List<TableModelRowWithObject<GridCustomFilter>>> {
        private static final int LABEL_WIDTH = 60;
        private static final int FIELD_WIDTH = 180;
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final AbstractAsyncCallback<Void> callback;

        public DeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<TableModelRowWithObject<GridCustomFilter>> data, AbstractAsyncCallback<Void> callback) {
            super(viewContext, data, viewContext.getMessage("delete_confirmation_title", new Object[0]));
            this.callback = callback;
            this.viewContext = viewContext;
        }

        @Override
        protected void extendForm() {
            this.formPanel.setLabelWidth(60);
            this.formPanel.setFieldWidth(180);
        }

        @Override
        protected String createMessage() {
            return "Do you really want to delete selected (" + ((List)this.data).size() + ") filter(s)?";
        }

        @Override
        protected void executeConfirmedAction() {
            this.viewContext.getCommonService().deleteFilters(TechId.createList((Collection)((Collection)this.data)), this.callback);
        }
    }

    private static class EditDialog
    extends AbstractGridCustomExpressionEditOrRegisterDialog {
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final AbstractExpression itemToUpdate;

        public EditDialog(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedAction postRegistrationCallback, String gridId, AbstractColumnSettingsDataModelProvider columnDataModelProvider, AbstractExpression itemToUpdate) {
            super(viewContext, viewContext.getMessage("edit_title", viewContext.getMessage("filter", new Object[0]), itemToUpdate.getName()), postRegistrationCallback, gridId, columnDataModelProvider);
            this.viewContext = viewContext;
            this.itemToUpdate = itemToUpdate;
            this.initializeValues(itemToUpdate);
        }

        @Override
        protected void register(AsyncCallback<Void> registrationCallback) {
            this.update(this.itemToUpdate);
            this.viewContext.getService().updateFilter(this.itemToUpdate, registrationCallback);
        }

        @Override
        protected HelpPageIdentifier createHelpPageIdentifier() {
            return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.CUSTOM_FILTER, HelpPageIdentifier.HelpPageAction.EDIT);
        }
    }

    private static class AddDialog
    extends AbstractGridCustomExpressionEditOrRegisterDialog {
        private final IViewContext<ICommonClientServiceAsync> viewContext;

        public AddDialog(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedAction postRegistrationCallback, String gridId, AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
            super(viewContext, viewContext.getMessage("add_new_filter", new Object[0]), postRegistrationCallback, gridId, columnDataModelProvider);
            this.viewContext = viewContext;
        }

        @Override
        protected void register(AsyncCallback<Void> registrationCallback) {
            NewColumnOrFilter newItem = this.getNewItemInfo();
            this.viewContext.getService().registerFilter(newItem, registrationCallback);
        }

        @Override
        protected HelpPageIdentifier createHelpPageIdentifier() {
            return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.CUSTOM_FILTER, HelpPageIdentifier.HelpPageAction.REGISTER);
        }
    }
}

