/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.managed_property;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.managed_property.ManagedPropertyFormHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedTableWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedUiTableActionDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiTableAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.ManagedTableActionRowSelectionType;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ManagedPropertyGridActionDialog
extends AbstractDataConfirmationDialog<List<TableModelRowWithObject<ReportRowModel>>> {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final AsyncCallback<Void> callback;
    private final IEntityInformationHolder entity;
    private final IManagedProperty managedProperty;
    private final IManagedUiTableAction managedAction;
    private final Map<String, TextField<?>> inputFieldsByCode = new LinkedHashMap();
    private final ManagedPropertyFormHelper formHelper;

    public ManagedPropertyGridActionDialog(IViewContext<ICommonClientServiceAsync> viewContext, String editTitle, List<TableModelRowWithObject<ReportRowModel>> data, AsyncCallback<Void> callback, IEntityInformationHolder entity, IManagedProperty managedProperty, IManagedUiTableAction managedAction) {
        super(viewContext, data, editTitle);
        this.viewContext = viewContext;
        this.entity = entity;
        this.managedProperty = managedProperty;
        this.callback = callback;
        this.managedAction = managedAction;
        this.setWidth(400);
        this.formHelper = new ManagedPropertyFormHelper(viewContext, this.formPanel, this.inputFieldsByCode){

            @Override
            protected void trySetBoundedValue(IManagedInputWidgetDescription inputDescription) {
                ManagedPropertyGridActionDialog.this.trySetBoundedValue(inputDescription);
            }
        };
    }

    @Override
    protected String createMessage() {
        return this.managedAction.getDescription() == null ? "Provide data" : this.managedAction.getDescription();
    }

    @Override
    protected void executeConfirmedAction() {
        if (this.managedAction instanceof ManagedUiTableActionDescription) {
            ManagedUiTableActionDescription ma = (ManagedUiTableActionDescription)this.managedAction;
            ArrayList<Integer> selectedRows = new ArrayList<Integer>();
            for (TableModelRowWithObject rowModel : (List)this.data) {
                selectedRows.add(((ReportRowModel)rowModel.getObjectOrNull()).getRowNumber());
            }
            Collections.sort(selectedRows);
            ma.setSelectedRows(selectedRows);
        }
        for (IManagedInputWidgetDescription inputDescription : this.managedAction.getInputWidgetDescriptions()) {
            String value;
            TextField<?> field = this.inputFieldsByCode.get(inputDescription.getCode());
            Object fieldValue = field.getValue();
            String string = value = fieldValue == null ? null : field.getValue().toString().trim();
            if (fieldValue instanceof SimpleComboValue) {
                value = ((SimpleComboValue)fieldValue).getValue().toString();
            }
            inputDescription.setValue(value);
        }
        this.managedProperty.setValue(StringEscapeUtils.unescapeHtml(this.managedProperty.getValue()));
        this.viewContext.getService().updateManagedProperty(TechId.create((IIdHolder)this.entity), this.entity.getEntityKind(), this.managedProperty, this.managedAction, this.callback);
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(100);
        this.formPanel.setFieldWidth(200);
        this.formHelper.fillForm(this.managedAction.getInputWidgetDescriptions());
    }

    private void trySetBoundedValue(IManagedInputWidgetDescription inputDescription) {
        String boundedColumnTitleOrNull;
        if (this.managedAction.getSelectionType() == ManagedTableActionRowSelectionType.REQUIRED_SINGLE && ((List)this.data).size() == 1 && (boundedColumnTitleOrNull = this.managedAction.getBindings().get(inputDescription.getCode())) != null) {
            if (this.viewContext.isLoggingEnabled()) {
                GWTUtils.displayInfo("found binding", inputDescription.getCode() + "->" + boundedColumnTitleOrNull);
            }
            TableModelRowWithObject selectedRow = (TableModelRowWithObject)((List)this.data).get(0);
            TableModel tableModel = ((ManagedTableWidgetDescription)this.managedProperty.getUiDescription().getOutputWidgetDescription()).getTableModel();
            for (TableModelColumnHeader header : tableModel.getHeader()) {
                if (!header.getTitle().equals(boundedColumnTitleOrNull)) continue;
                ISerializableComparable value = selectedRow.getValues().get(header.getIndex());
                inputDescription.setValue(value.toString());
                if (!this.viewContext.isLoggingEnabled()) break;
                Info.display((String)"bounded value", (String)(inputDescription.getCode() + "=" + value));
                break;
            }
        }
    }
}

