/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.MaterialTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.Widget;

public final class MaterialBatchRegistrationUpdatePanel
extends LayoutContainer {
    private static final String ID_SUFFIX = "material-batch-registration";
    public static final String ID = "openbis_material-batch-registration";
    private final MaterialTypeSelectionWidget materialTypeSelection;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public static String getId(boolean update) {
        return "openbis_material-batch-registration_" + (update ? "update" : "registration");
    }

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext, boolean update) {
        MaterialBatchRegistrationUpdatePanel panel = new MaterialBatchRegistrationUpdatePanel(viewContext, update);
        return new DatabaseModificationAwareComponent((Component)panel, (IDatabaseModificationObserver)panel.materialTypeSelection);
    }

    private MaterialBatchRegistrationUpdatePanel(final IViewContext<ICommonClientServiceAsync> viewContext, final boolean update) {
        this.viewContext = viewContext;
        this.setId(MaterialBatchRegistrationUpdatePanel.getId(update));
        this.setScrollMode(Style.Scroll.AUTO);
        this.materialTypeSelection = new MaterialTypeSelectionWidget(viewContext, null, ID_SUFFIX, true);
        final ToolBar toolBar = this.createToolBar();
        this.add((Component)toolBar);
        this.materialTypeSelection.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<MaterialTypeModel>(){

            public final void selectionChanged(SelectionChangedEvent<MaterialTypeModel> se) {
                MaterialType materialType = MaterialBatchRegistrationUpdatePanel.this.materialTypeSelection.tryGetSelectedMaterialType();
                if (materialType != null) {
                    MaterialBatchRegistrationUpdatePanel.this.removeAll();
                    EntityKind entityKind = EntityKind.MATERIAL;
                    MaterialBatchRegistrationUpdatePanel.this.add((Component)toolBar);
                    IClientPluginFactory clientPluginFactory = viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, materialType);
                    IClientPlugin createClientPlugin = clientPluginFactory.createClientPlugin(entityKind);
                    Widget batchOperationWidget = update ? createClientPlugin.createBatchUpdateForEntityType(materialType) : createClientPlugin.createBatchRegistrationForEntityType(materialType);
                    MaterialBatchRegistrationUpdatePanel.this.add(batchOperationWidget);
                    MaterialBatchRegistrationUpdatePanel.this.layout();
                }
            }
        });
    }

    private final ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)new LabelToolItem(this.viewContext.getMessage("material_type", new Object[0]) + ":"));
        toolBar.add((Component)this.materialTypeSelection);
        return toolBar;
    }
}

