/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.DisplayedAndSelectedEntities;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractEntityGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.GridUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialBrowserToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ColumnDistinctValues;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListMaterialDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class MaterialBrowserGrid
extends AbstractEntityGrid<Material> {
    private static final String PREFIX = "material-browser";
    public static final String BROWSER_ID = "openbis_material-browser";
    public static final String GRID_ID = "openbis_material-browser_grid";
    protected final ICriteriaProvider<ListMaterialDisplayCriteria> criteriaProvider;

    public static DisposableEntityChooser<TableModelRowWithObject<Material>> createWithTypeChooser(IViewContext<ICommonClientServiceAsync> viewContext, String initialMaterialTypeOrNull) {
        return MaterialBrowserGrid.createWithTypeChooser(viewContext, true, initialMaterialTypeOrNull);
    }

    private static DisposableEntityChooser<TableModelRowWithObject<Material>> createWithTypeChooser(IViewContext<ICommonClientServiceAsync> viewContext, boolean detailsAvailable, String initialMaterialTypeOrNull) {
        MaterialBrowserToolbar toolbar;
        MaterialBrowserToolbar criteriaProvider = toolbar = new MaterialBrowserToolbar(viewContext, initialMaterialTypeOrNull, null);
        MaterialBrowserGrid browserGrid = MaterialBrowserGrid.createBrowserGrid(viewContext, criteriaProvider, detailsAvailable);
        browserGrid.addGridRefreshListener(toolbar);
        browserGrid.extendBottomToolbar(detailsAvailable);
        return browserGrid.asDisposableWithToolbar(toolbar);
    }

    public static MaterialBrowserGrid createForMetaproject(IViewContext<?> viewContext, TechId metaprojectId) {
        final ListMaterialDisplayCriteria criteria = ListMaterialDisplayCriteria.createForMetaproject(new MetaprojectCriteria(metaprojectId.getId()));
        ICriteriaProvider<ListMaterialDisplayCriteria> criteriaProvider = new ICriteriaProvider<ListMaterialDisplayCriteria>(){

            @Override
            public ListMaterialDisplayCriteria tryGetCriteria() {
                return criteria;
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return new DatabaseModificationKind[0];
            }

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback postRefreshCallback) {
                postRefreshCallback.postRefresh(true);
            }
        };
        MaterialBrowserGrid browserGrid = MaterialBrowserGrid.createBrowserGrid(viewContext.getCommonViewContext(), criteriaProvider, true);
        browserGrid.addEntityOperationsLabel();
        browserGrid.addTaggingButtons(false);
        browserGrid.addEntityOperationsSeparator();
        browserGrid.allowMultipleSelection();
        return browserGrid;
    }

    public static DisposableEntityChooser<TableModelRowWithObject<Material>> create(IViewContext<ICommonClientServiceAsync> viewContext, MaterialType initValueOrNull) {
        if (initValueOrNull == null) {
            return MaterialBrowserGrid.createWithTypeChooser(viewContext, false, null);
        }
        return MaterialBrowserGrid.createWithoutTypeChooser(viewContext, initValueOrNull);
    }

    private static DisposableEntityChooser<TableModelRowWithObject<Material>> createWithoutTypeChooser(IViewContext<ICommonClientServiceAsync> viewContext, MaterialType initValue) {
        final ListMaterialDisplayCriteria criteria = ListMaterialDisplayCriteria.createForMaterialType(initValue);
        ICriteriaProvider<ListMaterialDisplayCriteria> criteriaProvider = new ICriteriaProvider<ListMaterialDisplayCriteria>(){

            @Override
            public ListMaterialDisplayCriteria tryGetCriteria() {
                return criteria;
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return new DatabaseModificationKind[0];
            }

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback postRefreshCallback) {
                postRefreshCallback.postRefresh(true);
            }
        };
        boolean detailsAvailable = false;
        MaterialBrowserGrid browserGrid = MaterialBrowserGrid.createBrowserGrid(viewContext, criteriaProvider, detailsAvailable);
        return browserGrid.asDisposableWithoutToolbar();
    }

    private static MaterialBrowserGrid createBrowserGrid(IViewContext<ICommonClientServiceAsync> viewContext, ICriteriaProvider<ListMaterialDisplayCriteria> criteriaProvider, boolean detailsAvailable) {
        if (detailsAvailable) {
            return new MaterialBrowserGrid(viewContext, true, criteriaProvider);
        }
        return new MaterialBrowserGrid((IViewContext)viewContext, true, (ICriteriaProvider)criteriaProvider){

            @Override
            protected void showEntityViewer(Material material, boolean editMode, boolean active) {
            }
        };
    }

    protected MaterialBrowserGrid(IViewContext<ICommonClientServiceAsync> viewContext, boolean refreshAutomatically, ICriteriaProvider<ListMaterialDisplayCriteria> criteriaProvider) {
        super(viewContext, GRID_ID, refreshAutomatically, DisplayTypeIDGenerator.ENTITY_BROWSER_GRID);
        this.criteriaProvider = criteriaProvider;
        this.registerLinkClickListenerFor("CODE", this.showEntityViewerLinkClickListener);
        this.setId(BROWSER_ID);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    protected void extendBottomToolbar(boolean detailsAvailable) {
        if (detailsAvailable && !this.viewContext.isSimpleOrEmbeddedMode()) {
            this.addEntityOperationsLabel();
            this.addEntityOperationButtons();
            this.addEntityOperationsSeparator();
        }
    }

    private void addEntityOperationButtons() {
        String showDetailsTitle = this.viewContext.getMessage("button_show_details", new Object[0]);
        Button showDetailsButton = this.createSelectedItemButton(showDetailsTitle, this.asShowEntityInvoker(false));
        this.addButton(showDetailsButton);
        String editTitle = this.viewContext.getMessage("edit", new Object[0]);
        Button editButton = this.createSelectedItemButton(editTitle, this.asShowEntityInvoker(true));
        this.addButton(editButton);
        this.addTaggingButtons();
        String deleteTitle = this.viewContext.getMessage("button_delete", new Object[0]);
        String deleteAllTitle = deleteTitle + " All";
        Button deleteButton = new Button(deleteAllTitle, (SelectionListener)new TypedTableGrid.AbstractCreateDialogListener(){

            protected Dialog createDialog(List<TableModelRowWithObject<Material>> materials, IBrowserGridActionInvoker invoker) {
                return new MaterialListDeletionConfirmationDialog(MaterialBrowserGrid.this.viewContext, MaterialBrowserGrid.this.createRefreshCallback(invoker), MaterialBrowserGrid.this.getDisplayedAndSelectedItemsAction().execute());
            }
        });
        this.changeButtonTitleOnSelectedItems(deleteButton, deleteAllTitle, deleteTitle);
        this.addButton(deleteButton);
        this.allowMultipleSelection();
    }

    protected void addGridRefreshListener(MaterialBrowserToolbar toolbar) {
        toolbar.setCriteriaChangedListeners(this.createGridRefreshDelegatedAction());
    }

    protected final IDelegatedAction createGridRefreshDelegatedAction() {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                if (MaterialBrowserGrid.this.criteriaProvider.tryGetCriteria() != null) {
                    MaterialBrowserGrid.this.refreshGridWithFilters();
                }
            }
        };
    }

    @Override
    public String getGridDisplayTypeID() {
        ListMaterialDisplayCriteria criteria = this.criteriaProvider.tryGetCriteria();
        if (criteria == null || criteria.getListCriteria() != null) {
            String suffix = this.createDisplayIdSuffix(EntityKind.MATERIAL, criteria == null ? null : criteria.getListCriteria().tryGetMaterialType());
            return this.createGridDisplayTypeID(suffix);
        }
        return this.createGridDisplayTypeID(null);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Material>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Material>> callback) {
        ListMaterialDisplayCriteria criteria = this.criteriaProvider.tryGetCriteria();
        if (criteria == null) {
            this.satisfyCallbackWithEmptyResultSet(callback);
        } else {
            criteria.copyPagingConfig(resultSetConfig);
            ((ICommonClientServiceAsync)this.viewContext.getService()).listMaterials(criteria, callback);
        }
    }

    protected void satisfyCallbackWithEmptyResultSet(AbstractAsyncCallback<TypedTableResultSet<Material>> callback) {
        ResultSet resultSet = new ResultSet();
        resultSet.setList(new GridRowModels(Arrays.asList(new GridRowModel[0]), Arrays.asList(new TableModelColumnHeader[0]), Arrays.asList(new GridCustomColumnInfo[0]), Arrays.asList(new ColumnDistinctValues[0])));
        resultSet.setTotalLength(0);
        callback.onSuccess(new TypedTableResultSet(resultSet));
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Material>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Material>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        return schema;
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Material>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportMaterials(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return GridUtils.getRelevantModifications(DatabaseModificationKind.ObjectKind.MATERIAL, this.criteriaProvider);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE");
    }

    protected void showEntityViewer(Material material, boolean editMode, boolean inBackground) {
        this.showEntityInformationHolderViewer(material, editMode, inBackground);
    }

    @Override
    protected EntityKind getEntityKindOrNull() {
        return EntityKind.MATERIAL;
    }

    protected final IDelegatedActionWithResult<DisplayedAndSelectedMaterials> getDisplayedAndSelectedItemsAction() {
        return new IDelegatedActionWithResult<DisplayedAndSelectedMaterials>(){

            @Override
            public DisplayedAndSelectedMaterials execute() {
                return new DisplayedAndSelectedMaterials(MaterialBrowserGrid.this.getSelectedBaseObjects(), MaterialBrowserGrid.this.createTableExportCriteria(), MaterialBrowserGrid.this.getTotalCount());
            }
        };
    }

    public final class DisplayedAndSelectedMaterials
    extends DisplayedAndSelectedEntities<TableModelRowWithObject<Material>> {
        public DisplayedAndSelectedMaterials(List<TableModelRowWithObject<Material>> selectedItems, TableExportCriteria<TableModelRowWithObject<Material>> displayedItemsConfig, int displayedItemsCount) {
            super(selectedItems, displayedItemsConfig, displayedItemsCount);
        }
    }
}

