/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.form;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.form.AbstractMetaprojectEditRegisterForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IMetaprojectUpdates;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.List;

public class MetaprojectEditForm
extends AbstractMetaprojectEditRegisterForm {
    private Metaproject originalMetaproject;
    private final Long metaprojectId;

    public static DatabaseModificationAwareComponent create(IViewContext<?> viewContext, Long metaprojectId) {
        MetaprojectEditForm form = new MetaprojectEditForm(viewContext, metaprojectId);
        return DatabaseModificationAwareComponent.wrapUnaware((Component)form);
    }

    protected MetaprojectEditForm(IViewContext<?> viewContext, Long metaprojectId) {
        super(viewContext, metaprojectId);
        this.setRevertButtonVisible(true);
        this.metaprojectId = metaprojectId;
    }

    @Override
    protected void saveMetaproject() {
        Metaproject updates = new Metaproject();
        updates.setName((String)this.metaprojectNameField.getValue());
        updates.setDescription((String)this.metaprojectDescriptionField.getValue());
        this.viewContext.getCommonService().updateMetaproject(this.metaprojectId, (IMetaprojectUpdates)updates, new MetaprojectEditCallback(this.viewContext));
    }

    @Override
    protected void setValues() {
        FieldUtil.setValueWithUnescaping((Field<String>)this.metaprojectNameField, this.originalMetaproject.getName());
        FieldUtil.setValueWithUnescaping((Field<String>)this.metaprojectDescriptionField, this.originalMetaproject.getDescription());
    }

    public void updateOriginalValues() {
        this.metaprojectNameField.setOriginalValue((String)this.metaprojectNameField.getValue());
        this.metaprojectDescriptionField.setOriginalValue((String)this.metaprojectDescriptionField.getValue());
    }

    void setOriginalMetaproject(Metaproject metaproject) {
        this.originalMetaproject = metaproject;
    }

    @Override
    protected void loadForm() {
        this.viewContext.getCommonService().getMetaproject(this.metaprojectId, (AsyncCallback<Metaproject>)new MetaprojectLoadCallback(this.viewContext));
    }

    private final class MetaprojectLoadCallback
    extends AbstractAsyncCallback<Metaproject> {
        private MetaprojectLoadCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Metaproject result) {
            MetaprojectEditForm.this.setOriginalMetaproject(result);
            MetaprojectEditForm.this.initGUI();
        }
    }

    private final class MetaprojectEditCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Metaproject> {
        MetaprojectEditCallback(IViewContext<?> viewContext) {
            super(MetaprojectEditForm.this, viewContext);
        }

        @Override
        protected void process(Metaproject result) {
            MetaprojectEditForm.this.setOriginalMetaproject(result);
            MetaprojectEditForm.this.updateOriginalValues();
            super.process(result);
        }

        @Override
        protected List<HtmlMessageElement> createSuccessfullRegistrationInfo(Metaproject result) {
            return Arrays.asList(new HtmlMessageElement("Metaproject <b>" + MetaprojectEditForm.this.originalMetaproject.getName() + "</b> successfully updated."));
        }
    }
}

