/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeEntityItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeEntityKindItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeMetaprojectItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.widget.MetaprojectTreeEntityItemWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.widget.MetaprojectTreeEntityKindItemWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.widget.MetaprojectTreeItemWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.widget.MetaprojectTreeMetaprojectItemWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsCount;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseTreeLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.Loader;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.data.TreeLoadEvent;
import com.extjs.gxt.ui.client.data.TreeLoader;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.TreeStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGrid;
import com.extjs.gxt.ui.client.widget.treegrid.WidgetTreeGridCellRenderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetaprojectTree
extends TreeGrid<MetaprojectTreeItemData>
implements IDisposableComponent {
    public static final String ID_SUFFIX = "_metaproject-tree";
    public static final String COLUMN_ID = "metaproject-tree-column";
    private MetaprojectTreeItemData selectedItem;

    public MetaprojectTree(IViewContext<?> viewContext, String idPrefix) {
        this(viewContext, idPrefix, new MetaprojectTreeLoader(viewContext), new MetaprojectTreeColumns(viewContext));
    }

    private MetaprojectTree(IViewContext<?> viewContext, String idPrefix, MetaprojectTreeLoader loader, final MetaprojectTreeColumns columns) {
        super(new TreeStore((TreeLoader)loader), columns.getModel());
        this.setId(idPrefix + ID_SUFFIX);
        this.setLazyRowRender(0);
        this.setBorders(true);
        this.setAutoExpandColumn(COLUMN_ID);
        this.getTreeView().setForceFit(true);
        this.getTreeView().setSortingEnabled(false);
        this.getTreeView().setBufferEnabled(false);
        this.getStyle().setNodeCloseIcon(null);
        this.getStyle().setNodeOpenIcon(null);
        this.getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
        this.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<MetaprojectTreeItemData>(){

            public void selectionChanged(SelectionChangedEvent<MetaprojectTreeItemData> se) {
                MetaprojectTreeItemWidget selectedWidget;
                if (MetaprojectTree.this.selectedItem != null) {
                    selectedWidget = columns.getWidget(MetaprojectTree.this.selectedItem);
                    selectedWidget.setSelected(false);
                }
                MetaprojectTree.this.selectedItem = (MetaprojectTreeItemData)se.getSelectedItem();
                if (MetaprojectTree.this.selectedItem != null) {
                    selectedWidget = columns.getWidget(MetaprojectTree.this.selectedItem);
                    selectedWidget.setSelected(true);
                }
            }
        });
        loader.addListener(Loader.Load, (Listener)new Listener<TreeLoadEvent>(){

            public void handleEvent(TreeLoadEvent event) {
                List items = (List)event.getData();
                if (items != null && items.size() > 0 && items.get(0) instanceof MetaprojectTreeMetaprojectItemData) {
                    for (MetaprojectTreeItemData item : items) {
                        MetaprojectTree.this.setExpanded((ModelData)item, true);
                    }
                }
            }
        });
        loader.load();
    }

    private MetaprojectTreeState recordState() {
        MetaprojectTreeState state = new MetaprojectTreeState();
        state.setExpandedState(this.recordExpandedState());
        state.setSelectedState(this.recordSelectedState());
        return state;
    }

    private void restoreState(MetaprojectTreeState state) {
        this.restoreExpandedState(state.getExpandedState());
        this.restoreSelectedState(state.getSelectedState());
    }

    private Map<MetaprojectTreeItemData, Boolean> recordExpandedState() {
        HashMap<MetaprojectTreeItemData, Boolean> expandedState = new HashMap<MetaprojectTreeItemData, Boolean>();
        for (MetaprojectTreeItemData item : this.getTreeStore().getAllItems()) {
            expandedState.put(item, this.isExpanded((ModelData)item));
        }
        return expandedState;
    }

    private List<MetaprojectTreeItemData> recordSelectedState() {
        ArrayList<MetaprojectTreeItemData> selectedPath = new ArrayList<MetaprojectTreeItemData>();
        if (this.selectedItem != null) {
            MetaprojectTreeItemData currentItem = this.selectedItem;
            while (currentItem != null) {
                selectedPath.add(currentItem);
                currentItem = (MetaprojectTreeItemData)this.getTreeStore().getParent((ModelData)currentItem);
            }
        }
        return selectedPath;
    }

    private void restoreExpandedState(Map<MetaprojectTreeItemData, Boolean> expandedState) {
        for (Map.Entry<MetaprojectTreeItemData, Boolean> entry : expandedState.entrySet()) {
            this.setExpanded((ModelData)entry.getKey(), entry.getValue());
        }
    }

    private void restoreSelectedState(List<MetaprojectTreeItemData> selectedPath) {
        for (MetaprojectTreeItemData selectedPathItem : selectedPath) {
            if (!this.getTreeStore().contains((ModelData)selectedPathItem)) continue;
            this.getSelectionModel().select(false, (ModelData[])new MetaprojectTreeItemData[]{selectedPathItem});
            break;
        }
    }

    private MetaprojectTreeLoader getLoader() {
        return (MetaprojectTreeLoader)this.getTreeStore().getLoader();
    }

    public void refresh(final IDelegatedAction callback) {
        final MetaprojectTreeState state = this.recordState();
        LoadListener afterLoadListener = new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                MetaprojectTree.this.restoreState(state);
                MetaprojectTree.this.getLoader().removeLoadListener(this);
                if (callback != null) {
                    callback.execute();
                }
            }
        };
        this.getLoader().clearCache();
        this.getLoader().addLoadListener(afterLoadListener);
        this.getLoader().load();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.refresh(IDelegatedAction.DO_NOTHING);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        HashSet<DatabaseModificationKind> result = new HashSet<DatabaseModificationKind>();
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.METAPROJECT);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.EXPERIMENT);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.SAMPLE);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.DATA_SET);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.MATERIAL);
        return result.toArray(DatabaseModificationKind.EMPTY_ARRAY);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
    }

    private class MetaprojectTreeState {
        Map<MetaprojectTreeItemData, Boolean> expandedState;
        List<MetaprojectTreeItemData> selectedState;

        private MetaprojectTreeState() {
        }

        public Map<MetaprojectTreeItemData, Boolean> getExpandedState() {
            return this.expandedState;
        }

        public void setExpandedState(Map<MetaprojectTreeItemData, Boolean> expandedState) {
            this.expandedState = expandedState;
        }

        public List<MetaprojectTreeItemData> getSelectedState() {
            return this.selectedState;
        }

        public void setSelectedState(List<MetaprojectTreeItemData> selectedState) {
            this.selectedState = selectedState;
        }
    }

    private static class MetaprojectTreeColumns {
        private ColumnModel columnModel;
        private Map<MetaprojectTreeItemData, MetaprojectTreeItemWidget> widgetMap = new HashMap<MetaprojectTreeItemData, MetaprojectTreeItemWidget>();

        public MetaprojectTreeColumns(final IViewContext<?> viewContext) {
            ColumnConfig column = new ColumnConfig(MetaprojectTree.COLUMN_ID, viewContext.getMessage("metaproject_tree_column_header", new Object[0]), 1);
            column.setMenuDisabled(true);
            column.setSortable(false);
            column.setRenderer((GridCellRenderer)new WidgetTreeGridCellRenderer<MetaprojectTreeItemData>(){

                public Widget getWidget(MetaprojectTreeItemData data, String property, ColumnData config, int rowIndex, int colIndex, ListStore<MetaprojectTreeItemData> store, Grid<MetaprojectTreeItemData> grid) {
                    MetaprojectTreeItemWidget widget;
                    if (data instanceof MetaprojectTreeMetaprojectItemData) {
                        widget = new MetaprojectTreeMetaprojectItemWidget(viewContext, (MetaprojectTreeMetaprojectItemData)data);
                    } else if (data instanceof MetaprojectTreeEntityKindItemData) {
                        widget = new MetaprojectTreeEntityKindItemWidget(viewContext, (MetaprojectTreeEntityKindItemData)data);
                    } else if (data instanceof MetaprojectTreeEntityItemData) {
                        widget = new MetaprojectTreeEntityItemWidget(viewContext, (MetaprojectTreeEntityItemData)data);
                    } else {
                        throw new UnsupportedOperationException("Unsupported metaproject tree item");
                    }
                    widgetMap.put(data, widget);
                    return widget;
                }
            });
            this.columnModel = new ColumnModel(Arrays.asList(column));
        }

        public ColumnModel getModel() {
            return this.columnModel;
        }

        public MetaprojectTreeItemWidget getWidget(MetaprojectTreeItemData data) {
            return this.widgetMap.get((Object)data);
        }
    }

    private static class MetaprojectTreeLoader
    extends BaseTreeLoader<MetaprojectTreeItemData> {
        public MetaprojectTreeLoader(IViewContext<?> viewContext) {
            super((DataProxy)new MetaprojectTreeProxy(viewContext));
        }

        public boolean hasChildren(MetaprojectTreeItemData parent) {
            return parent == null || parent instanceof MetaprojectTreeMetaprojectItemData || parent instanceof MetaprojectTreeEntityKindItemData;
        }

        public void clearCache() {
            ((MetaprojectTreeProxy)this.getProxy()).clearCache();
        }
    }

    private static class MetaprojectLoadEntitiesCallback<T extends IEntityInformationHolderWithIdentifier>
    extends AbstractAsyncCallback<List<T>> {
        private MetaprojectTreeEntityKindItemData parent;
        private AsyncCallback<List<MetaprojectTreeItemData>> callback;

        public MetaprojectLoadEntitiesCallback(IViewContext<?> viewContext, MetaprojectTreeEntityKindItemData parent, AsyncCallback<List<MetaprojectTreeItemData>> callback) {
            super(viewContext);
            this.parent = parent;
            this.callback = callback;
        }

        @Override
        protected void process(List<T> entities) {
            ArrayList<MetaprojectTreeEntityItemData> items = new ArrayList<MetaprojectTreeEntityItemData>();
            for (IEntityInformationHolderWithIdentifier entity : entities) {
                items.add(new MetaprojectTreeEntityItemData(this.parent.getMetaprojectId(), entity));
            }
            Collections.sort(items, new Comparator<MetaprojectTreeItemData>(){

                @Override
                public int compare(MetaprojectTreeItemData o1, MetaprojectTreeItemData o2) {
                    MetaprojectTreeEntityItemData e1 = (MetaprojectTreeEntityItemData)o1;
                    MetaprojectTreeEntityItemData e2 = (MetaprojectTreeEntityItemData)o2;
                    if (e1.isEntityStub() ^ e2.isEntityStub()) {
                        return e1.isEntityStub() ? -1 : 1;
                    }
                    return e1.getEntityLabel().compareTo(e2.getEntityLabel());
                }
            });
            this.callback.onSuccess(items);
        }
    }

    private static class MetaprojectTreeProxy
    extends RpcProxy<List<MetaprojectTreeItemData>> {
        private IViewContext<?> viewContext;
        private Map<Long, MetaprojectAssignmentsCount> countMap;

        public MetaprojectTreeProxy(IViewContext<?> viewContext) {
            this.viewContext = viewContext;
        }

        protected void load(Object parentObject, AsyncCallback<List<MetaprojectTreeItemData>> callback) {
            if (parentObject == null) {
                this.loadMetaprojects(callback);
            } else if (parentObject instanceof MetaprojectTreeMetaprojectItemData) {
                this.loadEntityKinds((MetaprojectTreeMetaprojectItemData)((Object)parentObject), callback);
            } else if (parentObject instanceof MetaprojectTreeEntityKindItemData) {
                this.loadEntities((MetaprojectTreeEntityKindItemData)((Object)parentObject), callback);
            } else {
                throw new IllegalArgumentException("Unsupported parent node: " + parentObject);
            }
        }

        private void initCountMap(final IDelegatedAction callback) {
            this.viewContext.getCommonService().listMetaprojectAssignmentsCounts((AsyncCallback<List<MetaprojectAssignmentsCount>>)new AbstractAsyncCallback<List<MetaprojectAssignmentsCount>>(this.viewContext){

                @Override
                protected void process(List<MetaprojectAssignmentsCount> result) {
                    HashMap<Long, MetaprojectAssignmentsCount> map = new HashMap<Long, MetaprojectAssignmentsCount>();
                    for (MetaprojectAssignmentsCount resultItem : result) {
                        map.put(resultItem.getMetaproject().getId(), resultItem);
                    }
                    countMap = map;
                    callback.execute();
                }
            });
        }

        private void loadMetaprojects(final AsyncCallback<List<MetaprojectTreeItemData>> callback) {
            if (this.countMap == null) {
                this.initCountMap(new IDelegatedAction(){

                    @Override
                    public void execute() {
                        this.loadMetaprojects((AsyncCallback<List<MetaprojectTreeItemData>>)callback);
                    }
                });
            } else {
                ArrayList<MetaprojectTreeMetaprojectItemData> items = new ArrayList<MetaprojectTreeMetaprojectItemData>();
                for (MetaprojectAssignmentsCount count : this.countMap.values()) {
                    items.add(new MetaprojectTreeMetaprojectItemData(count.getMetaproject()));
                }
                Collections.sort(items, new Comparator<MetaprojectTreeItemData>(){

                    @Override
                    public int compare(MetaprojectTreeItemData o1, MetaprojectTreeItemData o2) {
                        MetaprojectTreeMetaprojectItemData m1 = (MetaprojectTreeMetaprojectItemData)o1;
                        MetaprojectTreeMetaprojectItemData m2 = (MetaprojectTreeMetaprojectItemData)o2;
                        return m1.getMetaproject().getName().compareTo(m2.getMetaproject().getName());
                    }
                });
                callback.onSuccess(items);
            }
        }

        private void loadEntityKinds(final MetaprojectTreeMetaprojectItemData parent, final AsyncCallback<List<MetaprojectTreeItemData>> callback) {
            if (this.countMap == null) {
                this.initCountMap(new IDelegatedAction(){

                    @Override
                    public void execute() {
                        this.loadEntityKinds(parent, (AsyncCallback<List<MetaprojectTreeItemData>>)callback);
                    }
                });
            } else {
                Long metaprojectId = parent.getMetaproject().getId();
                MetaprojectAssignmentsCount count = this.countMap.get(metaprojectId);
                ArrayList<MetaprojectTreeEntityKindItemData> items = new ArrayList<MetaprojectTreeEntityKindItemData>();
                if (count.getExperimentCount() > 0) {
                    items.add(new MetaprojectTreeEntityKindItemData(metaprojectId, EntityKind.EXPERIMENT, count.getExperimentCount()));
                }
                if (count.getSampleCount() > 0) {
                    items.add(new MetaprojectTreeEntityKindItemData(metaprojectId, EntityKind.SAMPLE, count.getSampleCount()));
                }
                if (count.getDataSetCount() > 0) {
                    items.add(new MetaprojectTreeEntityKindItemData(metaprojectId, EntityKind.DATA_SET, count.getDataSetCount()));
                }
                if (count.getMaterialCount() > 0) {
                    items.add(new MetaprojectTreeEntityKindItemData(metaprojectId, EntityKind.MATERIAL, count.getMaterialCount()));
                }
                callback.onSuccess(items);
            }
        }

        private void loadEntities(MetaprojectTreeEntityKindItemData parent, AsyncCallback<List<MetaprojectTreeItemData>> callback) {
            if (EntityKind.EXPERIMENT.equals((Object)parent.getEntityKind())) {
                this.viewContext.getCommonService().listMetaprojectExperiments(parent.getMetaprojectId(), new MetaprojectLoadEntitiesCallback<Experiment>(this.viewContext, parent, callback));
            } else if (EntityKind.SAMPLE.equals((Object)parent.getEntityKind())) {
                this.viewContext.getCommonService().listMetaprojectSamples(parent.getMetaprojectId(), new MetaprojectLoadEntitiesCallback<Sample>(this.viewContext, parent, callback));
            } else if (EntityKind.DATA_SET.equals((Object)parent.getEntityKind())) {
                this.viewContext.getCommonService().listMetaprojectDataSets(parent.getMetaprojectId(), new MetaprojectLoadEntitiesCallback<AbstractExternalData>(this.viewContext, parent, callback));
            } else if (EntityKind.MATERIAL.equals((Object)parent.getEntityKind())) {
                this.viewContext.getCommonService().listMetaprojectMaterials(parent.getMetaprojectId(), new MetaprojectLoadEntitiesCallback<Material>(this.viewContext, parent, callback));
            } else {
                throw new IllegalArgumentException("Unsupported entity kind: " + parent.getEntityKind());
            }
        }

        public void clearCache() {
            this.countMap = null;
        }
    }
}

