/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.AbstractProjectEditRegisterForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import com.extjs.gxt.ui.client.widget.Component;
import java.util.Arrays;
import java.util.List;

public class ProjectRegistrationForm
extends AbstractProjectEditRegisterForm {
    protected ProjectRegistrationForm(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext);
        this.setResetButtonVisible(true);
        this.projectDescriptionField.setMaxLength(500000);
    }

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        ProjectRegistrationForm form = new ProjectRegistrationForm(viewContext);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)form.getGroupField());
    }

    public static String createId() {
        return AbstractProjectEditRegisterForm.createId(null);
    }

    private final Project createProject() {
        Project project = new Project();
        project.setDescription((String)this.projectDescriptionField.getValue());
        project.setIdentifier(this.spaceField.tryGetSelectedSpace().getIdentifier() + "/" + (String)this.projectCodeField.getValue());
        project.setNewAttachments(this.extractAttachments());
        return project;
    }

    @Override
    protected void saveProject() {
        Project project = this.createProject();
        ((ICommonClientServiceAsync)this.viewContext.getService()).registerProject(this.sessionKey, project, new ProjectRegistrationCallback(this.viewContext, project));
    }

    @Override
    protected void setValues() {
    }

    @Override
    protected void loadForm() {
        this.initGUI();
    }

    private final class ProjectRegistrationCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Void> {
        private final Project project;

        ProjectRegistrationCallback(IViewContext<?> viewContext, Project project) {
            super(ProjectRegistrationForm.this, viewContext);
            this.project = project;
        }

        @Override
        protected List<HtmlMessageElement> createSuccessfullRegistrationInfo(Void result) {
            return Arrays.asList(new HtmlMessageElement("Project <b>" + this.project.getIdentifier().toUpperCase() + "</b> successfully registered."));
        }
    }
}

