/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.XmlField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SemanticAnnotationGridColumns;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;

public class PropertyTypeGrid
extends TypedTableGrid<PropertyType> {
    public static final String BROWSER_ID = "openbis_property-type-browser";
    public static final String GRID_ID = "openbis_property-type-browser-grid";
    private final IDelegatedAction postRegistrationCallback;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        return new PropertyTypeGrid(viewContext).asDisposableWithoutToolbar();
    }

    private PropertyTypeGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.PROPERTY_TYPE_BROWSER_GRID);
        this.extendBottomToolbar();
        this.postRegistrationCallback = this.createRefreshGridAction();
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add", "Property Type"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DispatcherHelper.dispatchNaviEvent(new ComponentProvider(PropertyTypeGrid.this.viewContext).getPropertyTypeRegistration());
            }
        });
        addButton.setId("openbis_property-type-browser-grid-add-button");
        this.addButton(addButton);
        this.addButton(this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<PropertyType>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<PropertyType>> selectedItem, boolean keyPressed) {
                PropertyType propertyType = selectedItem.getBaseObject().getObjectOrNull();
                if (propertyType.isManagedInternally()) {
                    String errorMsg = "Internally managed property types cannot be edited.";
                    GWTUtils.alert("Error", "Internally managed property types cannot be edited.");
                } else {
                    PropertyTypeGrid.this.createEditDialog(propertyType).show();
                }
            }
        }));
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(){

            protected Dialog createDialog(List<TableModelRowWithObject<PropertyType>> propertyTypes, IBrowserGridActionInvoker invoker) {
                return new PropertyTypeListDeletionConfirmationDialog(PropertyTypeGrid.this.viewContext, propertyTypes, PropertyTypeGrid.this.createRefreshCallback(invoker));
            }

            protected boolean validateSelectedData(List<TableModelRowWithObject<PropertyType>> data) {
                String errorMsg = "Internally managed property types cannot be deleted.";
                for (TableModelRowWithObject<PropertyType> propertyType : data) {
                    if (!propertyType.getObjectOrNull().isManagedInternally()) continue;
                    GWTUtils.alert("Error", errorMsg);
                    return false;
                }
                return true;
            }
        });
        deleteButton.setId("openbis_property-type-browser-grid-delete-button");
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    private Window createEditDialog(final PropertyType propertyType) {
        String code = propertyType.getCode();
        final String description = propertyType.getDescription();
        final String label = propertyType.getLabel();
        String title = this.viewContext.getMessage("edit_title", "Property Type", code);
        final DataTypeCode dataTypeCode = propertyType.getDataType().getCode();
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            private final DescriptionField descriptionField;
            private final TextField<String> labelField;
            private XmlField xmlSchemaField;
            private XmlField xslTransformationsField;
            {
                super(viewContext, title, postRegistrationCallback);
                boolean mandatory = true;
                this.labelField = 4.createTextField(PropertyTypeGrid.this.viewContext.getMessage("label", new Object[0]), mandatory);
                this.labelField.setMaxLength(128);
                FieldUtil.setValueWithUnescaping(this.labelField, label);
                this.addField((Widget)this.labelField);
                this.descriptionField = 4.createDescriptionField(PropertyTypeGrid.this.viewContext, mandatory);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, description);
                this.addField((Widget)this.descriptionField);
                if (dataTypeCode == DataTypeCode.XML) {
                    this.xmlSchemaField = this.createXmlSchemaField();
                    FieldUtil.setValueWithUnescaping((Field<String>)this.xmlSchemaField, propertyType.getSchema());
                    this.addField((Widget)this.xmlSchemaField);
                    this.xslTransformationsField = this.createXslTransformationsField();
                    FieldUtil.setValueWithUnescaping((Field<String>)this.xslTransformationsField, propertyType.getTransformation());
                    this.addField((Widget)this.xslTransformationsField);
                }
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                propertyType.setDescription((String)this.descriptionField.getValue());
                propertyType.setLabel((String)this.labelField.getValue());
                if (dataTypeCode == DataTypeCode.XML) {
                    propertyType.setSchema((String)this.xmlSchemaField.getValue());
                    propertyType.setTransformation((String)this.xslTransformationsField.getValue());
                }
                ((ICommonClientServiceAsync)PropertyTypeGrid.this.viewContext.getService()).updatePropertyType(propertyType, registrationCallback);
            }

            private final XmlField createXmlSchemaField() {
                return new XmlField(PropertyTypeGrid.this.viewContext.getMessage("xml_schema", new Object[0]), false);
            }

            private final XmlField createXslTransformationsField() {
                return new XmlField(PropertyTypeGrid.this.viewContext.getMessage("xslt", new Object[0]), false);
            }
        };
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("LABEL", "CODE", "DATA_TYPE");
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<PropertyType>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<PropertyType>> schema = super.createColumnsDefinition();
        GridCellRenderer<BaseEntityModel<?>> multilineCellRenderer = this.createMultilineStringCellRenderer();
        schema.setGridCellRendererFor("DESCRIPTION", multilineCellRenderer);
        schema.setGridCellRendererFor("XML_SCHEMA", multilineCellRenderer);
        schema.setGridCellRendererFor("XSLT", multilineCellRenderer);
        new SemanticAnnotationGridColumns().setRenderers(schema);
        return schema;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<PropertyType>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<PropertyType>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listPropertyTypes(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<PropertyType>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportPropertyTypes(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }
}

