/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.shared.basic.IReportInformationProvider;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class ReportGeneratedCallback
extends AbstractAsyncCallback<TableModelReference> {
    private final IViewContext<ICommonClientServiceAsync> localViewContext;
    private final IOnReportComponentGeneratedAction action;
    private final IReportInformationProvider reportInformationProvider;
    private final String displaySettingsId;

    public static AsyncCallback<TableModelReference> create(IViewContext<ICommonClientServiceAsync> viewContext, IReportInformationProvider reportInformationProvider, String displaySettingsId, IOnReportComponentGeneratedAction action) {
        return AsyncCallbackWithProgressBar.decorate(new ReportGeneratedCallback(viewContext, reportInformationProvider, displaySettingsId, action), "Generating the report...");
    }

    private ReportGeneratedCallback(IViewContext<ICommonClientServiceAsync> viewContext, IReportInformationProvider reportInformationProvider, String displaySettingsId, IOnReportComponentGeneratedAction action) {
        super(viewContext);
        this.localViewContext = viewContext;
        this.reportInformationProvider = reportInformationProvider;
        this.displaySettingsId = displaySettingsId;
        this.action = action;
    }

    @Override
    protected void process(TableModelReference tableModelReference) {
        IDisposableComponent reportComponent = ReportGrid.create(this.localViewContext, tableModelReference, this.reportInformationProvider, this.displaySettingsId);
        this.action.execute(reportComponent);
        if (!StringUtils.isBlank((String)tableModelReference.tryGetMessage())) {
            MessageBox.info(null, (String)tableModelReference.tryGetMessage(), null);
        }
    }

    public static interface IOnReportComponentGeneratedAction {
        public void execute(IDisposableComponent var1);
    }
}

