/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SampleTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SpaceModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.ISampleCriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;
import java.util.Set;

final class SampleBrowserToolbar
extends ToolBar
implements ISampleCriteriaProvider,
IDisposableComponent {
    public static final String ID = "sample-browser-toolbar";
    private static final String PREFIX = "sample-browser-toolbar_";
    public static final String INCLUDE_GROUP_CHECKBOX_ID = "openbis_sample-browser-toolbar_include-group-checkbox";
    private final SampleTypeSelectionWidget selectSampleTypeCombo;
    private final SpaceSelectionWidget selectSpaceCombo;
    private final IViewContext<?> viewContext;
    private final boolean excludeWithoutExperiment;

    public SampleBrowserToolbar(IViewContext<?> viewContext, boolean addShared, boolean addAll, boolean excludeWithoutExperiment, String initialSpaceOrNull, String initialSampleTypeOrNull, SampleTypeDisplayID sampleTypeDisplayID) {
        this.viewContext = viewContext;
        this.excludeWithoutExperiment = excludeWithoutExperiment;
        this.selectSampleTypeCombo = new SampleTypeSelectionWidget(viewContext, ID, true, true, false, initialSampleTypeOrNull, sampleTypeDisplayID);
        this.selectSpaceCombo = new SpaceSelectionWidget(viewContext, ID, addShared, addAll, initialSpaceOrNull);
        this.display();
    }

    public SampleBrowserToolbar(IViewContext<?> viewContext, boolean addShared, boolean addAll, boolean excludeWithoutExperiment, SampleTypeDisplayID sampleTypeDisplayID) {
        this(viewContext, addShared, addAll, excludeWithoutExperiment, null, null, sampleTypeDisplayID);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        if (this.selectSpaceCombo != null) {
            this.selectSpaceCombo.dispose();
        }
    }

    @Override
    public ListSampleDisplayCriteria tryGetCriteria() {
        SampleType selectedType = this.tryGetSelectedSampleType();
        if (selectedType == null) {
            return null;
        }
        Space selectedSpace = this.selectSpaceCombo.tryGetSelectedSpace();
        if (selectedSpace == null) {
            return null;
        }
        boolean sharedSpace = SpaceSelectionWidget.isSharedSpace(selectedSpace);
        boolean allSpaces = SpaceSelectionWidget.isAllSpaces(selectedSpace);
        boolean includeInstance = sharedSpace || allSpaces;
        boolean includeSpace = !sharedSpace;
        ListSampleCriteria criteria = new ListSampleCriteria();
        criteria.setSampleType(selectedType);
        criteria.setSpaceCode(SpaceSelectionWidget.tryToGetSpaceCode(selectedSpace));
        criteria.setIncludeSpace(includeSpace);
        criteria.setIncludeInstance(includeInstance);
        criteria.setExcludeWithoutExperiment(this.excludeWithoutExperiment);
        return new ListSampleDisplayCriteria(criteria);
    }

    private SampleType tryGetSelectedSampleType() {
        return this.selectSampleTypeCombo.tryGetSelectedSampleType();
    }

    public void setCriteriaChangedListeners(final IDelegatedAction action) {
        this.selectSpaceCombo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SpaceModel>(){

            public void selectionChanged(SelectionChangedEvent<SpaceModel> se) {
                action.execute();
            }
        });
        this.selectSampleTypeCombo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SampleTypeModel>(){

            public void selectionChanged(SelectionChangedEvent<SampleTypeModel> se) {
                action.execute();
            }
        });
    }

    private void display() {
        this.setBorders(true);
        this.add((Component)new LabelToolItem(this.viewContext.getMessage("sample_type", new Object[0]) + ":"));
        this.add((Component)this.selectSampleTypeCombo);
        this.add((Component)new SeparatorToolItem());
        this.add((Component)new LabelToolItem(this.viewContext.getMessage("group", new Object[0]) + ":"));
        this.add((Component)this.selectSpaceCombo);
    }

    protected final void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SPACE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback entityTypeRefreshCallback) {
        if (this.containsAnyModificationsOf(observedModifications, DatabaseModificationKind.ObjectKind.SAMPLE_TYPE) || this.containsAnyModificationsOf(observedModifications, DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)) {
            this.selectSampleTypeCombo.refreshStore(entityTypeRefreshCallback);
        } else {
            entityTypeRefreshCallback.postRefresh(true);
        }
        if (observedModifications.contains(DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SPACE))) {
            this.selectSpaceCombo.refreshStore();
        }
    }

    private boolean containsAnyModificationsOf(Set<DatabaseModificationKind> observedModifications, DatabaseModificationKind.ObjectKind objectKind) {
        return observedModifications.contains(DatabaseModificationKind.createOrDelete(objectKind)) || observedModifications.contains(DatabaseModificationKind.edit(objectKind));
    }
}

