/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AbstractEditEntityTypeDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AbstractEntityTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AddEntityTypeDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SemanticAnnotationGridColumns;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractSaveDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityTypeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;

public class SampleTypeGrid
extends AbstractEntityTypeGrid<SampleType> {
    public static final String BROWSER_ID = "openbis_sample-type-browser";
    public static final String GRID_ID = "openbis_sample-type-browser-grid";
    private static final Boolean DEFAULT_LISTABLE_VALUE = true;
    private static final Boolean DEFAULT_AUTO_GENERATE_CODES_VALUE = false;
    private static final Boolean DEFAULT_SHOW_PARENT_METADATA_VALUE = false;
    private static final Boolean DEFAULT_UNIQUE_SUBCODES_VALUE = false;
    private static final String DEFAULT_GENERATED_CODE_PREFIX_VALUE = "S";
    private static final Boolean DEFAULT_SHOW_CONTAINER_VALUE = false;
    private static final Boolean DEFAULT_SHOW_PARENTS_VALUE = true;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        SampleTypeGrid grid = new SampleTypeGrid(viewContext, componentProvider);
        return grid.asDisposableWithoutToolbar();
    }

    private SampleTypeGrid(IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        super(viewContext, componentProvider, BROWSER_ID, GRID_ID);
    }

    @Override
    public AddEntityTypeDialog<SampleType> getNewDialog(SampleType newType) {
        return (AddEntityTypeDialog)this.createRegisterEntityTypeDialog("New " + this.viewContext.getMessage("sample", new Object[0]), newType, newType.getEntityKind());
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<SampleType>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<SampleType>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listSampleTypes(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<SampleType>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportSampleTypes(exportCriteria, callback);
    }

    @Override
    protected EntityKind getEntityKindOrNull() {
        return EntityKind.SAMPLE;
    }

    @Override
    protected void register(SampleType sampleType, AsyncCallback<Void> registrationCallback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).registerSampleType(sampleType, registrationCallback);
    }

    @Override
    protected SampleType createNewEntityType() {
        return new SampleType();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<SampleType>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<SampleType>> schema = super.createColumnsDefinition();
        new SemanticAnnotationGridColumns().setRenderers(schema);
        return schema;
    }

    @Override
    protected Window createEditEntityTypeDialog(EntityKind entityKind, final SampleType sampleType) {
        String code = sampleType.getCode();
        String title = this.viewContext.getMessage("edit_type_title_template", EntityTypeUtils.translatedEntityKindForUI(this.viewContext, entityKind), code);
        return new AbstractEditEntityTypeDialog<SampleType>(this.viewContext, title, this.postRegistrationCallback, EntityKind.SAMPLE, sampleType){
            private final SampleTypeDialogFieldHelper helper;
            {
                super(viewContext, title, postRegistrationCallback, entityKind, entityType);
                this.helper = new SampleTypeDialogFieldHelper(SampleTypeGrid.this.viewContext, this, sampleType, this.createHelpPageIdentifier());
            }

            @Override
            protected void setSpecificAttributes(SampleType entityType) {
                this.helper.setAttributes(entityType);
            }

            private HelpPageIdentifier createHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE_TYPE, HelpPageIdentifier.HelpPageAction.EDIT);
            }
        };
    }

    @Override
    protected Window createRegisterEntityTypeDialog(String title, SampleType newEntityType, EntityKind entityKind) {
        return new AddEntityTypeDialog<SampleType>(this.viewContext, title, this.postRegistrationCallback, newEntityType, entityKind){
            private final SampleTypeDialogFieldHelper helper;
            {
                SampleType sampleType = new SampleType();
                sampleType.setListable(DEFAULT_LISTABLE_VALUE);
                sampleType.setShowContainer(DEFAULT_SHOW_CONTAINER_VALUE);
                sampleType.setShowParents(DEFAULT_SHOW_PARENTS_VALUE);
                sampleType.setSubcodeUnique(DEFAULT_UNIQUE_SUBCODES_VALUE);
                sampleType.setAutoGeneratedCode(DEFAULT_AUTO_GENERATE_CODES_VALUE);
                sampleType.setShowParentMetadata(DEFAULT_SHOW_PARENT_METADATA_VALUE);
                sampleType.setGeneratedCodePrefix(SampleTypeGrid.DEFAULT_GENERATED_CODE_PREFIX_VALUE);
                this.helper = new SampleTypeDialogFieldHelper(SampleTypeGrid.this.viewContext, this, sampleType, this.createHelpPageIdentifier());
            }

            @Override
            protected void register(SampleType sampleType, AsyncCallback<Void> registrationCallback) {
                this.helper.setAttributes(sampleType);
                SampleTypeGrid.this.register(sampleType, registrationCallback);
            }

            private HelpPageIdentifier createHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SAMPLE_TYPE, HelpPageIdentifier.HelpPageAction.REGISTER);
            }
        };
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    private static final class SampleTypeDialogFieldHelper {
        private final CheckBoxField showContainerField;
        private final CheckBoxField showParentsField;
        private final CheckBoxField listableField;
        private final CheckBoxField subcodeUniqueField;
        private final CheckBoxField autoGeneratedCodeField;
        private final CheckBoxField showParentMetadataField;
        private final TextField<String> generatedCodePrefixField;

        private static CheckBoxField createCheckBoxField(String title, Boolean value) {
            CheckBoxField field = new CheckBoxField(title, false);
            field.setValue(value);
            return field;
        }

        public SampleTypeDialogFieldHelper(IViewContext<ICommonClientServiceAsync> viewContext, AbstractSaveDialog dialog, SampleType sampleType, HelpPageIdentifier helpPageIdentifier) {
            this.listableField = SampleTypeDialogFieldHelper.createCheckBoxField(viewContext.getMessage("listable", new Object[0]), sampleType.isListable());
            this.listableField.setId("openbis_add-type-dialog-listable");
            dialog.addField((Widget)this.listableField);
            this.showContainerField = SampleTypeDialogFieldHelper.createCheckBoxField(viewContext.getMessage("show_container", new Object[0]), sampleType.isShowContainer());
            this.showContainerField.setId("openbis_add-type-dialog-show-container");
            dialog.addField((Widget)this.showContainerField);
            this.showParentsField = SampleTypeDialogFieldHelper.createCheckBoxField(viewContext.getMessage("show_parents", new Object[0]), sampleType.isShowParents());
            this.showParentsField.setId("openbis_add-type-dialog-show-parents");
            dialog.addField((Widget)this.showParentsField);
            this.subcodeUniqueField = SampleTypeDialogFieldHelper.createCheckBoxField(viewContext.getMessage("subcode_unique_label", new Object[0]), sampleType.isSubcodeUnique());
            this.subcodeUniqueField.setId("openbis_add-type-dialog-subcode-unique");
            dialog.addField((Widget)this.subcodeUniqueField);
            this.autoGeneratedCodeField = SampleTypeDialogFieldHelper.createCheckBoxField(viewContext.getMessage("auto_generate_codes_label", new Object[0]), sampleType.isAutoGeneratedCode());
            this.autoGeneratedCodeField.setId("openbis_add-type-dialog-autogenerated-code");
            dialog.addField((Widget)this.autoGeneratedCodeField);
            this.showParentMetadataField = SampleTypeDialogFieldHelper.createCheckBoxField(viewContext.getMessage("show_parent_metadata_label", new Object[0]), sampleType.isShowParentMetadata());
            this.showParentMetadataField.setId("openbis_add-type-dialog-show-parent-metadata");
            dialog.addField((Widget)this.showParentMetadataField);
            this.generatedCodePrefixField = new CodeField(viewContext, viewContext.getMessage("generated_code_prefix", new Object[0]));
            this.generatedCodePrefixField.setValue((Object)sampleType.getGeneratedCodePrefix());
            this.generatedCodePrefixField.setId("openbis_add-type-dialog-generated-code-prefix");
            dialog.addField((Widget)this.generatedCodePrefixField);
            DialogWithOnlineHelpUtils.addHelpButton(viewContext, dialog, helpPageIdentifier);
        }

        public void setAttributes(SampleType sampleType) {
            sampleType.setShowParents(this.showParentsField.getValue());
            sampleType.setShowContainer(this.showContainerField.getValue());
            sampleType.setListable(this.listableField.getValue());
            sampleType.setAutoGeneratedCode(this.autoGeneratedCodeField.getValue());
            sampleType.setShowParentMetadata(this.showParentMetadataField.getValue());
            sampleType.setSubcodeUnique(this.subcodeUniqueField.getValue());
            sampleType.setGeneratedCodePrefix((String)this.generatedCodePrefixField.getValue());
        }
    }
}

