/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.AbstractScriptEditRegisterForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.EntityKindSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptUpdateResult;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import java.util.Arrays;
import java.util.List;

public class ScriptEditForm
extends AbstractScriptEditRegisterForm {
    private Script originalScript;
    private TechId scriptId;

    protected ScriptEditForm(IViewContext<ICommonClientServiceAsync> viewContext, TechId scriptId) {
        super(viewContext, scriptId, null, null);
        this.setRevertButtonVisible(true);
        this.scriptId = scriptId;
    }

    @Override
    protected void saveScript() {
        Script script = this.getScript();
        ((ICommonClientServiceAsync)this.viewContext.getService()).updateScript(script, new ScriptEditCallback(this.viewContext));
    }

    @Override
    public Script getScript() {
        Script script = new Script();
        script.setId(this.scriptId.getId());
        script.setDescription((String)this.descriptionField.getValue());
        script.setModificationDate(this.originalScript.getModificationDate());
        if (this.originalScript.getPluginType() == PluginType.JYTHON) {
            script.setScript((String)this.scriptField.getValue());
            script.setName((String)this.nameField.getValue());
        } else {
            script.setName(this.originalScript.getName());
        }
        return script;
    }

    @Override
    protected void setValues() {
        boolean pluginTypeIsPython;
        FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, this.originalScript.getDescription());
        FieldUtil.setValueWithUnescaping((Field<String>)this.scriptField, this.originalScript.getScript());
        FieldUtil.setValueWithUnescaping((Field<String>)this.nameField, this.originalScript.getName());
        boolean bl = pluginTypeIsPython = this.originalScript.getPluginType() == PluginType.JYTHON;
        if (pluginTypeIsPython) {
            LabeledItem<EntityKind> item = this.originalScript.getEntityKind() == null || this.originalScript.getEntityKind().length != 1 ? EntityKindSelectionWidget.createLabeledItemForAll() : EntityKindSelectionWidget.createLabeledItem(this.originalScript.getEntityKind()[0], this.viewContext);
            this.entityKindField.setSimpleValue(item);
        } else {
            StringBuilder builder = new StringBuilder();
            if (this.originalScript.getEntityKind() == null) {
                builder.append("(All)");
            } else {
                for (EntityKind entityKind : this.originalScript.getEntityKind()) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(entityKind);
                }
            }
            this.entityKindListField.setValue(builder.toString());
            this.entityKindListField.setEnabled(false);
        }
        this.entityKindField.setVisible(pluginTypeIsPython);
        this.entityKindListField.setVisible(!pluginTypeIsPython);
        this.descriptionField.setEnabled(pluginTypeIsPython);
    }

    public void updateOriginalValues() {
        this.descriptionField.setOriginalValue((String)this.descriptionField.getValue());
        this.scriptField.setOriginalValue((String)this.scriptField.getValue());
        this.nameField.setOriginalValue((Object)((String)this.nameField.getValue()));
        this.entityKindListField.setOriginalValue((String)this.entityKindListField.getValue());
        this.entityKindField.setOriginalValue((SimpleComboValue)this.entityKindField.getValue());
    }

    @Override
    protected void loadForm() {
        ((ICommonClientServiceAsync)this.viewContext.getService()).getScriptInfo(this.scriptId, new ScriptInfoCallback(this.viewContext));
    }

    void setOriginalScript(Script script) {
        this.originalScript = script;
        this.onPluginOrScriptTypeChanged(script.getPluginType(), script.getScriptType());
        this.scriptExecution.update(script.getName(), script.getScript(), script.getPluginType());
    }

    public static Component create(IViewContext<ICommonClientServiceAsync> viewContext, TechId scriptId) {
        return new ScriptEditForm(viewContext, scriptId);
    }

    private final class ScriptInfoCallback
    extends AbstractAsyncCallback<Script> {
        private ScriptInfoCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected final void process(Script result) {
            ScriptEditForm.this.setOriginalScript(result);
            ScriptEditForm.this.initGUI();
        }
    }

    private final class ScriptEditCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<ScriptUpdateResult> {
        ScriptEditCallback(IViewContext<?> viewContext) {
            super(ScriptEditForm.this, viewContext);
        }

        @Override
        protected void process(ScriptUpdateResult result) {
            ScriptEditForm.this.originalScript.setModificationDate(result.getModificationDate());
            ScriptEditForm.this.updateOriginalValues();
            super.process(result);
        }

        @Override
        protected List<HtmlMessageElement> createSuccessfullRegistrationInfo(ScriptUpdateResult result) {
            return Arrays.asList(new HtmlMessageElement("Script <b>" + ScriptEditForm.this.originalScript.getName() + "</b> successfully updated."));
        }
    }
}

