/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DataSetChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ExperimentChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MaterialChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.SampleChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.EntityKindSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.IValidable;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.MultilineHTML;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DynamicPropertyEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityValidationEvaluationInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;

public class ScriptExecutionFramework {
    FormPanel panel;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final SampleChooserField.SampleChooserFieldAdaptor sampleChooser;
    private final ExperimentChooserField.ExperimentChooserFieldAdaptor experimentChooser;
    private final MaterialChooserField materialChooser;
    private final DataSetChooserField datasetChooser;
    private final FieldSet evaluationResultPanel;
    private final EntityKindSelectionWidget entityKindChooser;
    private final State state = new State();
    private final AdapterField entityLink;
    private final CheckBox isNewEntity;
    private final MultilineHTML html;
    private final IValidable validable;
    private ScriptType scriptType;

    public ScriptExecutionFramework(IViewContext<ICommonClientServiceAsync> viewContext, IValidable validable, EntityKind entityKindOrNull) {
        this.viewContext = viewContext;
        this.validable = validable;
        this.entityKindChooser = new EntityKindSelectionWidget(viewContext, entityKindOrNull, true, false);
        this.sampleChooser = SampleChooserField.create(viewContext.getMessage("sample", new Object[0]), true, null, true, true, false, viewContext.getCommonViewContext(), SampleTypeDisplayID.SCRIPT_EDITOR_SAMPLE_CHOOSER, false);
        this.experimentChooser = ExperimentChooserField.create(viewContext.getMessage("experiment", new Object[0]), true, null, viewContext);
        this.materialChooser = MaterialChooserField.create(viewContext.getMessage("material", new Object[0]), true, null, null, viewContext);
        this.datasetChooser = DataSetChooserField.create(viewContext.getMessage("data_set", new Object[0]), true, viewContext);
        final Map<EntityKind, Field<?>> map = ScriptExecutionFramework.createEntitySelectionMap(this.sampleChooser, this.experimentChooser, this.materialChooser, this.datasetChooser);
        this.entityLink = this.createEntityLink();
        this.isNewEntity = this.createCheckBox();
        this.html = new MultilineHTML("");
        this.evaluationResultPanel = this.createResultField(this.html);
        ScriptExecutionFramework.updateVisibleEntityChooser(map, this.entityKindChooser, this.entityLink);
        this.entityKindChooser.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SimpleComboValue<LabeledItem<EntityKind>>>(){

            public void selectionChanged(SelectionChangedEvent<SimpleComboValue<LabeledItem<EntityKind>>> se) {
                ScriptExecutionFramework.updateVisibleEntityChooser(map, ScriptExecutionFramework.this.entityKindChooser, (Field)ScriptExecutionFramework.this.entityLink);
                ScriptExecutionFramework.this.evaluationResultPanel.setVisible(false);
            }
        });
        this.panel = ScriptExecutionFramework.createPanel();
        this.panel.add((Widget)this.entityKindChooser);
        this.panel.add((Widget)this.sampleChooser.getChooserField());
        this.panel.add((Widget)this.experimentChooser.getChooserField());
        this.panel.add((Widget)this.materialChooser);
        this.panel.add((Widget)this.datasetChooser);
        this.panel.add((Widget)this.isNewEntity);
        this.panel.add((Widget)this.entityLink);
        this.panel.add((Widget)this.createButtonsField());
        this.panel.add((Widget)this.evaluationResultPanel);
        this.scriptType = ScriptType.DYNAMIC_PROPERTY;
    }

    private AdapterField createButtonsField() {
        AdapterField field = new AdapterField((Widget)WidgetUtils.inRow(new Widget[]{this.createCalculateButton(), this.createSeparator(), this.createResetButton()}));
        field.setLabelSeparator("");
        return field;
    }

    private Html createSeparator() {
        return new Html("&nbsp;");
    }

    private void reset() {
        this.panel.reset();
        this.html.setMultilineHTML("");
        this.evaluationResultPanel.setVisible(false);
    }

    private Button createResetButton() {
        Button button = new Button(this.viewContext.getMessage("button_reset", new Object[0]));
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                ScriptExecutionFramework.this.reset();
            }
        });
        return button;
    }

    private Button createCalculateButton() {
        Button refresh = new Button(this.viewContext.getMessage("button_evaluate", new Object[0]));
        refresh.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                boolean thisValid = ScriptExecutionFramework.this.panel.isValid();
                boolean dependantValid = ScriptExecutionFramework.this.validable.isValid();
                if (thisValid && dependantValid) {
                    ScriptExecutionFramework.this.evaluationResultPanel.setVisible(true);
                    ScriptExecutionFramework.this.evaluate();
                }
            }
        });
        return refresh;
    }

    public FieldSet createResultField(MultilineHTML widget) {
        FieldSet fieldSet = new FieldSet();
        fieldSet.setHeading(this.viewContext.getMessage("evaluation_result", new Object[0]));
        fieldSet.add((Widget)widget);
        fieldSet.setVisible(false);
        return fieldSet;
    }

    private BasicEntityDescription tryGetSelectedEntity() {
        if (!StringUtils.isBlank((String)this.sampleChooser.getValue())) {
            return new BasicEntityDescription(EntityKind.SAMPLE, this.sampleChooser.getValue());
        }
        if (this.experimentChooser.tryToGetValue() != null && !StringUtils.isBlank((String)this.experimentChooser.tryToGetValue().getIdentifier())) {
            return new BasicEntityDescription(EntityKind.EXPERIMENT, this.experimentChooser.tryToGetValue().getIdentifier());
        }
        if (!StringUtils.isBlank((String)((String)this.materialChooser.getValue()))) {
            return new BasicEntityDescription(EntityKind.MATERIAL, (String)this.materialChooser.getValue());
        }
        if (!StringUtils.isBlank((String)((String)this.datasetChooser.getValue()))) {
            return new BasicEntityDescription(EntityKind.DATA_SET, (String)this.datasetChooser.getValue());
        }
        return null;
    }

    private AdapterField createEntityLink() {
        ClickHandler listener = new ClickHandler(){

            public void onClick(ClickEvent event) {
                final boolean ifSpecialKeyPressed = WidgetUtils.ifSpecialKeyPressed(event.getNativeEvent());
                BasicEntityDescription entity = ScriptExecutionFramework.this.tryGetSelectedEntity();
                if (entity != null) {
                    AbstractAsyncCallback<IEntityInformationHolderWithPermId> callback = new AbstractAsyncCallback<IEntityInformationHolderWithPermId>(ScriptExecutionFramework.this.viewContext){

                        @Override
                        protected void process(IEntityInformationHolderWithPermId result) {
                            new OpenEntityDetailsTabAction(result, this.viewContext, ifSpecialKeyPressed).execute();
                        }
                    };
                    ScriptExecutionFramework.this.viewContext.getCommonService().getEntityInformationHolder(ScriptExecutionFramework.this.tryGetSelectedEntity(), (AsyncCallback<IEntityInformationHolderWithPermId>)callback);
                } else {
                    MessageBox.info((String)"Entity not selected", (String)"Please choose the entity", null);
                }
            }
        };
        Widget linkWidget = LinkRenderer.getLinkWidget(this.viewContext.getMessage("show_details", new Object[0]), listener);
        AdapterField field = new AdapterField(linkWidget);
        field.setFieldLabel(this.viewContext.getMessage("entity_details", new Object[0]));
        return field;
    }

    private CheckBox createCheckBox() {
        CheckBox checkBox = new CheckBox();
        checkBox.setFieldLabel("Is New Entity?");
        checkBox.setBoxLabel("");
        checkBox.setValue(Boolean.valueOf(false));
        checkBox.setVisible(false);
        return checkBox;
    }

    public Widget getWidget() {
        FieldSet set = new FieldSet();
        set.setHeading(this.viewContext.getMessage("script_tester", new Object[0]));
        set.add((Widget)this.panel);
        return set;
    }

    public void update(String scriptName, String script, PluginType pluginTypeOrNull) {
        this.state.setScriptName(scriptName);
        this.state.setScript(script);
        if (pluginTypeOrNull != null) {
            this.state.setPluginType(pluginTypeOrNull);
        }
    }

    public void updateEntityKind(EntityKind kind) {
        if (kind != null) {
            this.entityKindChooser.setSimpleValue(EntityKindSelectionWidget.createLabeledItem(kind, this.viewContext));
            this.entityKindChooser.disable();
        } else {
            this.entityKindChooser.enable();
        }
    }

    private void evaluate() {
        BasicEntityDescription selectedEntityOrNull = this.tryGetSelectedEntity();
        if (selectedEntityOrNull != null) {
            this.evaluate(selectedEntityOrNull.getEntityKind(), selectedEntityOrNull.getEntityIdentifier(), this.state.getPluginType(), this.state.getScriptName(), this.state.getScript());
        }
    }

    private void evaluate(EntityKind kind, String entity, PluginType pluginType, String scriptName, String script) {
        if (entity == null) {
            return;
        }
        if (this.scriptType == ScriptType.DYNAMIC_PROPERTY) {
            this.updateEvaluationResultField(this.viewContext.getMessage("evaluation_in_progress", new Object[0]));
            this.viewContext.getCommonService().evaluate(new DynamicPropertyEvaluationInfo(kind, entity, pluginType, scriptName, script), (AsyncCallback<String>)new AbstractAsyncCallback<String>(this.viewContext){

                @Override
                protected void process(String result) {
                    ScriptExecutionFramework.this.updateEvaluationResultField(result);
                }

                @Override
                public void finishOnFailure(Throwable caught) {
                    ScriptExecutionFramework.this.updateEvaluationResultField("");
                    ScriptExecutionFramework.this.evaluationResultPanel.setVisible(false);
                }
            });
        } else if (this.scriptType == ScriptType.ENTITY_VALIDATION) {
            this.updateEvaluationResultField(this.viewContext.getMessage("evaluation_in_progress", new Object[0]));
            this.viewContext.getCommonService().evaluate(new EntityValidationEvaluationInfo(kind, entity, this.isNewEntity.getValue(), pluginType, scriptName, script), (AsyncCallback<String>)new AbstractAsyncCallback<String>(this.viewContext){

                @Override
                protected void process(String result) {
                    ScriptExecutionFramework.this.updateEvaluationResultField(result);
                }

                @Override
                public void finishOnFailure(Throwable caught) {
                    ScriptExecutionFramework.this.updateEvaluationResultField("");
                    ScriptExecutionFramework.this.evaluationResultPanel.setVisible(false);
                }
            });
        }
    }

    private void updateEvaluationResultField(String result) {
        this.html.setMultilineHTML(result == null ? "(null)" : result);
    }

    private static void updateVisibleEntityLink(boolean visible, Field<?> entityLink) {
        FieldUtil.setVisibility(visible, entityLink);
    }

    private static void updateVisibleEntityChooser(Map<EntityKind, Field<?>> map, EntityKindSelectionWidget entityKindChooser, Field<?> entityLink) {
        boolean atLeastOneEntityChooserVisible = false;
        for (Field<?> w : map.values()) {
            w.reset();
            EntityKind kind = entityKindChooser.tryGetEntityKind();
            boolean visible = kind != null && w == map.get(kind);
            atLeastOneEntityChooserVisible = atLeastOneEntityChooserVisible || visible;
            FieldUtil.setVisibility(visible, w);
        }
        ScriptExecutionFramework.updateVisibleEntityLink(atLeastOneEntityChooserVisible, entityLink);
    }

    private static FormPanel createPanel() {
        FormPanel p = new FormPanel();
        p.setHeaderVisible(false);
        p.setBodyBorder(false);
        p.setBorders(false);
        p.setScrollMode(Style.Scroll.AUTO);
        p.setWidth(450);
        p.setLabelWidth(100);
        p.setFieldWidth(250);
        return p;
    }

    private static Map<EntityKind, Field<?>> createEntitySelectionMap(SampleChooserField.SampleChooserFieldAdaptor sampleChooser, ExperimentChooserField.ExperimentChooserFieldAdaptor experimentChooser, MaterialChooserField materialChooser, DataSetChooserField datasetChooser) {
        HashMap m = new HashMap();
        m.put(EntityKind.SAMPLE, (Field<?>)sampleChooser.getChooserField());
        m.put(EntityKind.EXPERIMENT, (Field<?>)experimentChooser.getChooserField());
        m.put(EntityKind.MATERIAL, (Field<?>)materialChooser);
        m.put(EntityKind.DATA_SET, (Field<?>)datasetChooser);
        return m;
    }

    public ScriptType getScriptType() {
        return this.scriptType;
    }

    public void setScriptType(ScriptType scriptType) {
        this.scriptType = scriptType;
        this.isNewEntity.setVisible(scriptType == ScriptType.ENTITY_VALIDATION);
    }

    private static class State {
        private String scriptName;
        private String script;
        private PluginType pluginType;

        private State() {
        }

        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        public PluginType getPluginType() {
            return this.pluginType;
        }

        public void setPluginType(PluginType pluginType) {
            this.pluginType = pluginType;
        }

        public String getScriptName() {
            return this.scriptName;
        }

        public void setScriptName(String scriptName) {
            this.scriptName = scriptName;
        }
    }
}

