/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.ScriptTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.AbstractScriptEditRegisterForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import java.util.Arrays;
import java.util.List;

public class ScriptRegistrationForm
extends AbstractScriptEditRegisterForm {
    public static ScriptRegistrationForm create(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKindOrNull) {
        ScriptTypeSelectionWidget scriptTypeChooser = ScriptTypeSelectionWidget.createAllScriptTypes(viewContext);
        return new ScriptRegistrationForm(viewContext, scriptTypeChooser, entityKindOrNull);
    }

    protected ScriptRegistrationForm(IViewContext<ICommonClientServiceAsync> viewContext, ScriptTypeSelectionWidget scriptTypeChooser, EntityKind entityKindOrNull) {
        super(viewContext, scriptTypeChooser, entityKindOrNull);
        this.setResetButtonVisible(true);
        this.onPluginOrScriptTypeChanged(PluginType.JYTHON, (ScriptType)scriptTypeChooser.getSimpleValue());
    }

    @Override
    protected void saveScript() {
        Script newScript = this.getScript();
        ((ICommonClientServiceAsync)this.viewContext.getService()).registerScript(newScript, new ScriptRegistrationCallback(this.viewContext, newScript));
    }

    @Override
    public Script getScript() {
        EntityKind[] entityKindArray;
        PluginType pluginType = PluginType.JYTHON;
        Script newScript = new Script();
        newScript.setDescription((String)this.descriptionField.getValue());
        newScript.setScript((String)this.scriptField.getValue());
        newScript.setName((String)this.nameField.getValue());
        newScript.setScriptType((ScriptType)this.scriptTypeChooserOrNull.getSimpleValue());
        newScript.setPluginType(pluginType);
        if (this.entityKindField.tryGetEntityKind() == null) {
            entityKindArray = null;
        } else {
            EntityKind[] entityKindArray2 = new EntityKind[1];
            entityKindArray = entityKindArray2;
            entityKindArray2[0] = this.entityKindField.tryGetEntityKind();
        }
        newScript.setEntityKind(entityKindArray);
        newScript.setAvailable(true);
        return newScript;
    }

    public static String createId() {
        return AbstractScriptEditRegisterForm.createId(null);
    }

    @Override
    protected void setValues() {
    }

    @Override
    protected void loadForm() {
        this.initGUI();
    }

    private final class ScriptRegistrationCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Void> {
        private final Script script;

        ScriptRegistrationCallback(IViewContext<?> viewContext, Script script) {
            super(ScriptRegistrationForm.this, viewContext);
            this.script = script;
        }

        @Override
        protected List<HtmlMessageElement> createSuccessfullRegistrationInfo(Void result) {
            return Arrays.asList(new HtmlMessageElement("Script <b>" + this.script.getName().toUpperCase() + "</b> successfully registered."));
        }
    }
}

