/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchCriterionWidget;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import com.extjs.gxt.ui.client.event.KeyboardEvents;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.List;

public abstract class DetailedSearchCriteriaWidget
extends VerticalPanel {
    public static final String FIRST_ID_SUFFIX = "_first";
    private final List<DetailedSearchCriterionWidget> criteriaWidgets;
    protected final IViewContext<ICommonClientServiceAsync> viewContext;
    private final EntityKind entityKind;

    public DetailedSearchCriteriaWidget(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKind) {
        this.viewContext = viewContext;
        this.entityKind = entityKind;
        this.setLayoutOnChange(true);
        this.criteriaWidgets = new ArrayList<DetailedSearchCriterionWidget>();
    }

    protected abstract String getCriteriaLabel();

    protected abstract SearchCriteriaConnection getConnection();

    protected abstract void setConnection(SearchCriteriaConnection var1);

    protected void addInitialWidgets() {
        this.addCriterion(new DetailedSearchCriterionWidget(this.viewContext, this, FIRST_ID_SUFFIX, this.entityKind));
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        this.addInitialWidgets();
    }

    private void enableRemovalIfOneExists(boolean enable) {
        if (this.criteriaWidgets.size() == 1) {
            this.criteriaWidgets.get(0).enableRemoveButton(enable);
        }
    }

    void addCriterion(DetailedSearchCriterionWidget criterion) {
        this.enableRemovalIfOneExists(true);
        this.criteriaWidgets.add(criterion);
        this.add((Component)criterion);
        this.enableRemovalIfOneExists(false);
        this.layout();
        criterion.focus();
    }

    void removeCriterion(DetailedSearchCriterionWidget w) {
        if (this.criteriaWidgets.size() > 1) {
            this.criteriaWidgets.remove((Object)w);
            this.remove((Component)w);
            this.enableRemovalIfOneExists(false);
            this.focusLastWidget();
        } else {
            w.reset();
        }
    }

    private void focusLastWidget() {
        DetailedSearchCriterionWidget lastWidget = this.criteriaWidgets.get(this.criteriaWidgets.size() - 1);
        lastWidget.focus();
    }

    public void focus() {
        super.focus();
        this.focusLastWidget();
    }

    public List<PropertyType> getAvailablePropertyTypes() {
        return this.criteriaWidgets.get(0).getAvailablePropertyTypes();
    }

    public DetailedSearchCriteria extractCriteria(boolean useWildcardSearchMode) {
        ArrayList<DetailedSearchCriterion> criteria = new ArrayList<DetailedSearchCriterion>();
        for (DetailedSearchCriterionWidget cw : this.criteriaWidgets) {
            DetailedSearchCriterion value = cw.tryGetValue();
            if (value == null) continue;
            criteria.add(value);
        }
        DetailedSearchCriteria result = new DetailedSearchCriteria();
        result.setUseWildcardSearchMode(useWildcardSearchMode);
        result.setConnection(this.getConnection());
        result.setCriteria(criteria);
        return result;
    }

    public String getCriteriaDescription() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (DetailedSearchCriterionWidget cw : this.criteriaWidgets) {
            String desc = cw.tryGetDescription();
            if (desc == null) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    public boolean isCriteriaFilled() {
        for (DetailedSearchCriterionWidget cw : this.criteriaWidgets) {
            DetailedSearchCriterion value = cw.tryGetValue();
            if (value == null) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        ArrayList<DetailedSearchCriterionWidget> list = new ArrayList<DetailedSearchCriterionWidget>(this.criteriaWidgets);
        for (DetailedSearchCriterionWidget cw : list) {
            this.removeCriterion(cw);
        }
        this.layout();
    }

    public void setInitialSearchCritera(DetailedSearchCriteria searchCriteria) {
        List<DetailedSearchCriterion> criterionList = searchCriteria.getCriteria();
        int index = 0;
        int size = criterionList.size();
        for (DetailedSearchCriterionWidget widget : this.criteriaWidgets) {
            DetailedSearchCriterion criterion = criterionList.get(index++);
            widget.setSearchCriterion(criterion);
        }
        while (index < size) {
            DetailedSearchCriterionWidget widget;
            DetailedSearchCriterion criterion = criterionList.get(index);
            widget = new DetailedSearchCriterionWidget(this.viewContext, this, FIRST_ID_SUFFIX, this.entityKind);
            widget.setSearchCriterion(criterion);
            this.addCriterion(widget);
            ++index;
        }
        this.setConnection(searchCriteria.getConnection());
    }

    void onEnterKey() {
        this.fireEvent(KeyboardEvents.Enter);
    }
}

