/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DetailedSearchFieldComboModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchCriteriaWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchFieldsSelectionWidget;
import ch.systemsx.cisd.openbis.generic.shared.basic.AttributeSearchFieldKindProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class DetailedSearchCriterionWidget
extends HorizontalPanel {
    private static final String PREFIX = "data_set_search_criterion";
    public static final String ID = "openbis_data_set_search_criterion";
    public static final String VALUE_FIELD_ID_PREFIX = "openbis_data_set_search_criterion_value";
    public static final String REMOVE_BUTTON_ID_PREFIX = "openbis_data_set_search_criterion_remove";
    public static final String ADD_BUTTON_ID_PREFIX = "openbis_data_set_search_criterion_add";
    private final DetailedSearchCriteriaWidget parent;
    private final DetailedSearchFieldsSelectionWidget nameField;
    private final String idSuffix;
    private final TextField<String> valueField;
    private final Button removeButton;
    private int generatedChildren = 0;
    private IViewContext<ICommonClientServiceAsync> viewContext;

    public DetailedSearchCriterionWidget(IViewContext<ICommonClientServiceAsync> viewContext, DetailedSearchCriteriaWidget parent, String idSuffix, EntityKind entityKind) {
        this(parent, idSuffix, new DetailedSearchFieldsSelectionWidget(viewContext, idSuffix, entityKind));
        this.viewContext = viewContext;
    }

    private DetailedSearchCriterionWidget(DetailedSearchCriteriaWidget parent, String idSuffix, DetailedSearchFieldsSelectionWidget nameField) {
        this.parent = parent;
        this.idSuffix = idSuffix;
        this.nameField = nameField;
        this.valueField = new TextField();
        this.valueField.setId(VALUE_FIELD_ID_PREFIX + idSuffix);
        this.addEnterListener();
        TableData tableData = new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.BOTTOM);
        tableData.setPadding(1);
        this.add((Widget)this.nameField, (LayoutData)tableData);
        this.nameField.setWidth(300);
        this.add((Widget)this.valueField, (LayoutData)tableData);
        this.valueField.setWidth(150);
        this.add((Widget)this.createAddButton(idSuffix), (LayoutData)tableData);
        this.removeButton = this.createRemoveButton(idSuffix);
        this.add((Widget)this.removeButton, (LayoutData)tableData);
    }

    private void addEnterListener() {
        this.valueField.addKeyListener(new KeyListener(){

            public final void componentKeyUp(ComponentEvent event) {
                if (event.getKeyCode() == 13) {
                    DetailedSearchCriterionWidget.this.parent.onEnterKey();
                }
            }
        });
    }

    public void enableRemoveButton(boolean enable) {
        this.removeButton.setEnabled(enable);
    }

    private Button createRemoveButton(String id) {
        Button button = new Button("-", (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DetailedSearchCriterionWidget.this.remove();
            }
        });
        button.setId(REMOVE_BUTTON_ID_PREFIX + id);
        return button;
    }

    private Button createAddButton(String id) {
        Button button = new Button("+", (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DetailedSearchCriterionWidget.this.createNew();
            }
        });
        button.setId(ADD_BUTTON_ID_PREFIX + id);
        return button;
    }

    private String getChildId() {
        return this.idSuffix + "_" + this.generatedChildren;
    }

    private void createNew() {
        DetailedSearchCriterionWidget newCriterion = new DetailedSearchCriterionWidget(this.parent, this.getChildId(), new DetailedSearchFieldsSelectionWidget(this.nameField, this.getChildId(), this.nameField.getEntityKind()));
        this.parent.addCriterion(newCriterion);
        ++this.generatedChildren;
    }

    private void remove() {
        this.parent.removeCriterion(this);
    }

    public void reset() {
        this.valueField.reset();
        this.nameField.reset();
    }

    public void focus() {
        super.focus();
        this.valueField.focus();
    }

    public DetailedSearchCriterion tryGetValue() {
        String selectedValue = (String)this.valueField.getValue();
        DetailedSearchField selectedField = this.nameField.tryGetSelectedField();
        ISearchFieldKind selectedKind = this.nameField.tryGetSelectedKind();
        if (selectedField != null && !StringUtils.isBlank((String)selectedValue)) {
            if (selectedKind != null && selectedKind.getCriterionFactory() != null) {
                return selectedKind.getCriterionFactory().createCriterion(selectedField, selectedValue);
            }
            return new DetailedSearchCriterion(selectedField, selectedValue);
        }
        return null;
    }

    public String tryGetDescription() {
        DetailedSearchCriterion criterion = this.tryGetValue();
        String name = this.nameField.tryGetSelectedCode();
        if (criterion == null || name == null) {
            return null;
        }
        return name + " = " + criterion.getValue();
    }

    public List<PropertyType> getAvailablePropertyTypes() {
        return this.nameField.getAvailablePropertyTypes();
    }

    public void setSearchCriterion(DetailedSearchCriterion criterion) {
        DetailedSearchField field = criterion.getField();
        String searchString = criterion.getValue();
        String description = "";
        IAttributeSearchFieldKind kind = null;
        switch (field.getKind()) {
            case ATTRIBUTE: {
                kind = AttributeSearchFieldKindProvider.getAttributeFieldKind(this.nameField.getEntityKind(), field.getAttributeCode());
                description = DetailedSearchFieldsSelectionWidget.getDisplayName(this.viewContext, kind);
                break;
            }
            case PROPERTY: {
                description = field.getPropertyCode();
                break;
            }
            case ANY_FIELD: {
                description = "Any Field";
                break;
            }
            case ANY_PROPERTY: {
                description = "Any Property";
                break;
            }
            case REGISTRATOR: {
                description = "";
            }
        }
        DetailedSearchFieldComboModel model = new DetailedSearchFieldComboModel(description, field, kind);
        this.nameField.setValue((ModelData)model);
        this.valueField.setValue((Object)searchString);
    }
}

