/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchCriteriaWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchMainCriteriaWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchSubCriteriaWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.EntityTypeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AssociatedEntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.KeyboardEvents;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.layout.FitData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class DetailedSearchWindow
extends Dialog {
    public static final String SEARCH_BUTTON_ID = "openbis_data-set-search-hit-browsersearch_button";
    private static final Margins MARGINS = new Margins(5, 10, 5, 10);
    private static final int HEIGHT = 420;
    private static final int WIDTH = 550;
    private static final int PANEL_HEIGHT = 166;
    private final DetailedSearchCriteriaWidget criteriaWidget;
    private final List<DetailedSearchSubCriteriaWidget> subCriteriaWidgets = new ArrayList<DetailedSearchSubCriteriaWidget>();
    private DetailedSearchToolbar updateListener;
    private final TabPanel tabPanel;
    private final CheckBox useWildcardSearchModeCheckBox;

    public DetailedSearchWindow(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKind) {
        this.setPosition(300, 100);
        this.setSize(550, 420);
        this.setModal(true);
        this.setHeading(viewContext.getMessage("search_criteria_dialog_title", EntityTypeUtils.translatedEntityKindForUI(viewContext, entityKind)));
        this.setLayout((Layout)new RowLayout());
        this.setResizable(false);
        this.criteriaWidget = new DetailedSearchMainCriteriaWidget(viewContext, entityKind);
        this.useWildcardSearchModeCheckBox = this.createWildcardSearchModeCheckBoxCheckBox(viewContext);
        this.useWildcardSearchModeCheckBox.setValue(Boolean.valueOf(true));
        this.add((Component)this.useWildcardSearchModeCheckBox);
        this.add((Component)this.createMainCriteriaPanel());
        this.tabPanel = new TabPanel();
        this.tabPanel.setHeight("166px");
        for (AssociatedEntityKind association : DetailedSearchWindow.getAssociatedEntityKinds(entityKind)) {
            DetailedSearchSubCriteriaWidget subCriteriaWidget = new DetailedSearchSubCriteriaWidget(viewContext, association);
            this.subCriteriaWidgets.add(subCriteriaWidget);
            this.addSearchWidgetTab(subCriteriaWidget);
        }
        if (!this.subCriteriaWidgets.isEmpty()) {
            this.add((Component)this.tabPanel);
        }
        this.addEnterListener();
        ButtonBar bar = this.getButtonBar();
        bar.removeAll();
        bar.add((Component)new Button(viewContext.getMessage("button_cancel", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DetailedSearchWindow.this.hide();
            }
        }));
        bar.add((Component)new Button(viewContext.getMessage("button_reset", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                for (DetailedSearchCriteriaWidget widget : DetailedSearchWindow.this.getAllWidgets()) {
                    widget.reset();
                }
            }
        }));
        Button searchButton = new Button(viewContext.getMessage("search_button", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DetailedSearchWindow.this.onSearch();
            }
        });
        searchButton.setId(SEARCH_BUTTON_ID);
        bar.add((Component)searchButton);
        DialogWithOnlineHelpUtils.addHelpButton(viewContext, (Window)this, this.createHelpPageIdentifier(entityKind));
    }

    private ContentPanel createMainCriteriaPanel() {
        ContentPanel mainPanel = new ContentPanel();
        mainPanel.setHeaderVisible(false);
        mainPanel.setLayout((Layout)new FitLayout());
        mainPanel.setScrollMode(Style.Scroll.AUTOY);
        mainPanel.add((Widget)this.criteriaWidget, (LayoutData)new FitData(MARGINS));
        mainPanel.setHeight("166px");
        return mainPanel;
    }

    private final CheckBox createWildcardSearchModeCheckBoxCheckBox(IViewContext<ICommonClientServiceAsync> viewContext) {
        CheckBox field = new CheckBox();
        field.setId("openbis_detailed_search-checkbox");
        field.setBoxLabel(viewContext.getMessage("use_wildcard_checkbox_text_long", new Object[0]));
        field.setTitle(viewContext.getMessage("use_wildcard_checkbox_tooltip", new Object[0]));
        field.setStyleAttribute("marginRight", "3px");
        field.setStyleAttribute("marginLeft", "3px");
        field.setHeight("20px");
        return field;
    }

    private void addSearchWidgetTab(DetailedSearchSubCriteriaWidget searchWidget) {
        TabItem tab = new TabItem();
        tab.setClosable(false);
        tab.setLayout((Layout)new FitLayout());
        tab.setScrollMode(Style.Scroll.AUTOY);
        tab.setText(searchWidget.getCriteriaLabel());
        tab.add((Widget)searchWidget, (LayoutData)new FitData(MARGINS));
        tab.setHideMode(Style.HideMode.OFFSETS);
        this.tabPanel.add(tab);
    }

    private List<DetailedSearchCriteriaWidget> getAllWidgets() {
        ArrayList<DetailedSearchCriteriaWidget> result = new ArrayList<DetailedSearchCriteriaWidget>(this.subCriteriaWidgets);
        result.add((DetailedSearchSubCriteriaWidget)this.criteriaWidget);
        return result;
    }

    private void addEnterListener() {
        for (DetailedSearchCriteriaWidget widget : this.getAllWidgets()) {
            widget.addListener(KeyboardEvents.Enter, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent ce) {
                    EventType type = ce.getType();
                    switch (type.getEventCode()) {
                        case 13: {
                            DetailedSearchWindow.this.onSearch();
                            break;
                        }
                    }
                }
            });
        }
    }

    protected void afterShow() {
        super.afterShow();
        this.criteriaWidget.focus();
    }

    public DetailedSearchCriteria tryGetCriteria() {
        boolean useWildcardSearchMode = this.useWildcardSearchModeCheckBox.getValue();
        DetailedSearchCriteria mainCriteria = this.criteriaWidget.extractCriteria(useWildcardSearchMode);
        for (DetailedSearchSubCriteriaWidget subCriteriaWidget : this.subCriteriaWidgets) {
            if (!subCriteriaWidget.isCriteriaFilled()) continue;
            DetailedSearchSubCriteria subCriteria = subCriteriaWidget.extractSubCriteria(useWildcardSearchMode);
            mainCriteria.addSubCriteria(subCriteria);
        }
        if (mainCriteria.isEmpty()) {
            return null;
        }
        return mainCriteria;
    }

    public String getCriteriaDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.criteriaWidget.isCriteriaFilled()) {
            sb.append(this.criteriaWidget.getCriteriaDescription());
        }
        for (DetailedSearchCriteriaWidget detailedSearchCriteriaWidget : this.subCriteriaWidgets) {
            if (!detailedSearchCriteriaWidget.isCriteriaFilled()) continue;
            sb.append(", ");
            sb.append(detailedSearchCriteriaWidget.getCriteriaDescription());
        }
        if (!this.criteriaWidget.isCriteriaFilled()) {
            sb.delete(0, 2);
        }
        return sb.toString();
    }

    public void setUpdateListener(DetailedSearchToolbar toolbar) {
        this.updateListener = toolbar;
    }

    protected HelpPageIdentifier createHelpPageIdentifier(EntityKind entityKind) {
        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SEARCH, HelpPageIdentifier.HelpPageAction.ACTION);
    }

    public void setInitialSearchCriteria(DetailedSearchCriteria searchCriteria) {
        this.criteriaWidget.setInitialSearchCritera(searchCriteria);
    }

    private void onSearch() {
        final List<PropertyType> availablePropertyTypes = this.criteriaWidget.getAvailablePropertyTypes();
        final DetailedSearchCriteria criteria = this.tryGetCriteria();
        boolean tooGeneric = this.isSearchTooGeneric(criteria);
        if (tooGeneric) {
            MessageBox.confirm((String)"Warning", (String)"This search query is too broad. This might take a long time and might lead to a very large number of search results.<br><br>Do you want to submit the query anyway?", (Listener)new Listener<MessageBoxEvent>(){

                public void handleEvent(MessageBoxEvent messageEvent) {
                    if (messageEvent.getButtonClicked().getItemId().equals("yes")) {
                        DetailedSearchWindow.this.updateSearch(criteria, availablePropertyTypes);
                    }
                }
            }).getDialog().setResizable(true);
        } else {
            this.updateSearch(criteria, availablePropertyTypes);
        }
    }

    private boolean isSearchTooGeneric(DetailedSearchCriteria criteria) {
        for (DetailedSearchCriterion criterion : criteria.getCriteria()) {
            String value = criterion.getValue();
            if (!"*".equals(value)) continue;
            return true;
        }
        List<DetailedSearchSubCriteria> subCriterias = criteria.getSubCriterias();
        for (DetailedSearchSubCriteria subCriteria : subCriterias) {
            if (!this.isSearchTooGeneric(subCriteria.getCriteria())) continue;
            return true;
        }
        return false;
    }

    private void updateSearch(DetailedSearchCriteria criteria, List<PropertyType> availablePropertyTypes) {
        this.hide();
        String criteriaDescription = this.getCriteriaDescription();
        this.updateListener.updateSearchResults(criteria, criteriaDescription, availablePropertyTypes);
    }

    private static List<AssociatedEntityKind> getAssociatedEntityKinds(EntityKind sourceEntity) {
        return AssociatedEntityKind.getAssociatedEntityKinds(sourceEntity);
    }
}

