/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.user;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SpaceModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ProjectSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IntegerField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractSaveDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SessionContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PortletConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RealNumberFormatingParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;

public class ChangeUserSettingsDialog
extends AbstractSaveDialog {
    public static final String DIALOG_ID = "openbis_change-user-settings-dialog";
    public static final String GROUP_FIELD_ID = "openbis_change-user-settings-dialog-group-field";
    public static final String LEGACYUI_FIELD_ID = "openbis_change-user-settings-dialog-group-field-legacyUI-field";
    private final IViewContext<?> viewContext;
    private final SpaceSelectionWidget homeSpaceField;
    private ProjectSelectionWidget defaultProject;
    private final CheckBoxField reopenLastTabField;
    private final CheckBoxField enableLegacyMetadataUI;
    private final CheckBoxField showLastVisitsField;
    private final FieldSet formatingFields;
    private final CheckBoxField scientificFormatingField;
    private final CheckBoxField debuggingModeField;
    private final IntegerField precisionField;
    private final IDelegatedAction resetCallback;

    public ChangeUserSettingsDialog(IViewContext<?> viewContext, IDelegatedAction saveCallback, IDelegatedAction resetCallback) {
        super(viewContext, viewContext.getMessage("change_user_settings_dialog_title", new Object[0]), saveCallback);
        this.viewContext = viewContext;
        this.resetCallback = resetCallback;
        this.form.setLabelWidth(150);
        this.form.setFieldWidth(400);
        this.setWidth(640);
        this.homeSpaceField = this.createHomeGroupField();
        this.addField((Widget)this.homeSpaceField);
        SessionContext sessionContext = viewContext.getModel().getSessionContext();
        this.initDefaultProjectUIField(sessionContext.getUser().getHomeGroupCode());
        this.reopenLastTabField = this.createReopenLastTabOnLoginField();
        this.addField((Widget)this.reopenLastTabField);
        this.enableLegacyMetadataUI = this.createEnableLegacyMetadataUIField();
        this.addField((Widget)this.enableLegacyMetadataUI);
        this.showLastVisitsField = this.createShowLastVisitsField();
        this.addField((Widget)this.showLastVisitsField);
        this.formatingFields = this.createRealFormatingFieldSet();
        this.precisionField = this.createPrecisionField();
        this.formatingFields.add((Widget)this.precisionField);
        this.scientificFormatingField = this.createScientificCheckBox();
        this.formatingFields.add((Widget)this.scientificFormatingField);
        this.addField((Widget)this.formatingFields);
        this.debuggingModeField = this.createDebuggingModeCheckBox();
        this.addField((Widget)this.debuggingModeField);
        this.fbar.insert((Component)this.createResetButton(), 1);
        this.homeSpaceField.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SpaceModel>(){

            public void selectionChanged(SelectionChangedEvent<SpaceModel> se) {
                Space space = (Space)ChangeUserSettingsDialog.this.homeSpaceField.tryGetSelected();
                ChangeUserSettingsDialog.this.initDefaultProjectUIField(space != null ? space.getCode() : null);
            }
        });
        this.homeSpaceField.addListener(Events.Blur, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                String spaceCode = ChangeUserSettingsDialog.this.homeSpaceField.getRawValue();
                ChangeUserSettingsDialog.this.initDefaultProjectUIField(spaceCode != null && !spaceCode.isEmpty() ? spaceCode : null);
            }
        });
        DialogWithOnlineHelpUtils.addHelpButton(viewContext.getCommonViewContext(), this, this.createHelpPageIdentifier());
    }

    private final SpaceSelectionWidget createHomeGroupField() {
        SpaceSelectionWidget field = new SpaceSelectionWidget(this.viewContext, GROUP_FIELD_ID, false, false);
        FieldUtil.setMandatoryFlag(field, false);
        field.setFieldLabel(this.viewContext.getMessage("home_group_label", new Object[0]));
        return field;
    }

    private CheckBoxField createEnableLegacyMetadataUIField() {
        CheckBoxField field = new CheckBoxField("Enable Legacy Metadata UI (Needs Re-login)", false);
        GWTUtils.setToolTip((Component)field, "When selected the legacy  UI to manage metadata is available and the new one is hidden. A change on this field needs to Re-Login the application.");
        field.setValue(this.viewContext.getDisplaySettingsManager().isLegacyMedadataUIEnabled());
        field.setId(LEGACYUI_FIELD_ID);
        return field;
    }

    private void initDefaultProjectUIField(String spaceCodeOrNull) {
        if (spaceCodeOrNull == null) {
            if (this.defaultProject != null) {
                this.removeField((Widget)this.defaultProject);
                this.defaultProject = null;
            }
        } else {
            String oldSpaceCodeOrNull;
            String string = oldSpaceCodeOrNull = this.defaultProject != null ? this.defaultProject.getSpaceCodeOrNull() : null;
            if (!spaceCodeOrNull.equals(oldSpaceCodeOrNull)) {
                if (this.defaultProject != null) {
                    this.removeField((Widget)this.defaultProject);
                }
                int homeSpaceIndex = this.indexOfField((Component)this.homeSpaceField);
                this.defaultProject = this.createDefaultProjectUIField(spaceCodeOrNull);
                this.insertField((Widget)this.defaultProject, homeSpaceIndex + 1);
            }
        }
        this.form.layout(true);
        this.layout(true);
    }

    private ProjectSelectionWidget createDefaultProjectUIField(String spaceCode) {
        String idSuffix = "openbis_select_projectopenbis_change-user-settings-dialog";
        ProjectSelectionWidget field = new ProjectSelectionWidget(this.viewContext, idSuffix, spaceCode, null);
        field.setFieldLabel("Default Project");
        GWTUtils.setToolTip((Component)field, "Default Project Code");
        field.setAllowBlank(true);
        return field;
    }

    private CheckBoxField createReopenLastTabOnLoginField() {
        CheckBoxField field = new CheckBoxField(this.viewContext.getMessage("reopen_last_tab_on_login_label", new Object[0]), false);
        GWTUtils.setToolTip((Component)field, this.viewContext.getMessage("reopen_last_tab_on_login_info", new Object[0]));
        AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
        FieldUtil.addInfoIcon(field, this.viewContext.getMessage("reopen_last_tab_on_login_info", new Object[0]), infoIcon.createImage());
        field.setValue(this.viewContext.getDisplaySettingsManager().isReopenLastTabOnLogin());
        return field;
    }

    private CheckBoxField createShowLastVisitsField() {
        CheckBoxField field = new CheckBoxField(this.viewContext.getMessage("show_last_visits_label", new Object[0]), false);
        GWTUtils.setToolTip((Component)field, this.viewContext.getMessage("show_last_visits_info", new Object[0]));
        field.setValue(this.viewContext.getDisplaySettingsManager().getPortletConfigurations().containsKey("History"));
        return field;
    }

    @Override
    protected void save(AsyncCallback<Void> saveCallback) {
        String groupCodeOrNull = null;
        TechId groupIdOrNull = null;
        String spaceRaw = this.homeSpaceField.getRawValue();
        if (spaceRaw != null && !spaceRaw.isEmpty()) {
            Space space = (Space)this.homeSpaceField.tryGetSelected();
            groupCodeOrNull = space == null ? null : space.getCode();
            groupIdOrNull = TechId.create((IIdHolder)space);
        }
        this.viewContext.getModel().getSessionContext().getUser().setHomeGroupCode(groupCodeOrNull);
        this.viewContext.getService().changeUserHomeSpace(groupIdOrNull, saveCallback);
        RealNumberFormatingParameters formatingParameters = this.getRealNumberFormatingParameters();
        formatingParameters.setFormatingEnabled(this.formatingFields.isExpanded());
        formatingParameters.setPrecision(((Number)this.precisionField.getValue()).intValue());
        formatingParameters.setScientific(this.scientificFormatingField.getValue());
        DisplaySettingsManager displaySettingsManager = this.viewContext.getDisplaySettingsManager();
        boolean debuggingModeEnabled = this.debuggingModeField.getValue();
        displaySettingsManager.setDebuggingModeEnabled(debuggingModeEnabled);
        boolean restoreLastTab = this.reopenLastTabField.getValue();
        displaySettingsManager.setReopenLastTabOnLogin(restoreLastTab);
        boolean isLegacyMetadataEnabled = this.enableLegacyMetadataUI.getValue();
        this.viewContext.getDisplaySettingsManager().setLegacyMedadataUIEnabled(isLegacyMetadataEnabled);
        if (groupCodeOrNull != null && this.defaultProject != null) {
            Project defaultProjectObject;
            String defaultProjectIdentifierOrNull = null;
            String projectRaw = this.defaultProject.getRawValue();
            if (projectRaw != null && !projectRaw.isEmpty() && (defaultProjectObject = this.defaultProject.tryGetSelectedProject()) != null) {
                defaultProjectIdentifierOrNull = defaultProjectObject.getIdentifier();
            }
            this.viewContext.getDisplaySettingsManager().setDefaultProject(defaultProjectIdentifierOrNull);
        } else {
            this.viewContext.getDisplaySettingsManager().setDefaultProject(null);
        }
        if (this.showLastVisitsField.getValue().booleanValue()) {
            displaySettingsManager.addPortlet(new PortletConfiguration("History"));
        } else {
            displaySettingsManager.getPortletConfigurations().remove("History");
        }
        displaySettingsManager.storeSettings();
    }

    private FieldSet createRealFormatingFieldSet() {
        FieldSet fields = new FieldSet();
        fields.setHeading(this.viewContext.getMessage("real_number_formating_fields", new Object[0]));
        fields.setCheckboxToggle(true);
        fields.setExpanded(this.getRealNumberFormatingParameters().isFormatingEnabled());
        FormLayout layout = new FormLayout();
        layout.setLabelWidth(139);
        fields.setLayout((Layout)layout);
        Listener<BaseEvent> listener = new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                ChangeUserSettingsDialog.this.layout(true);
            }
        };
        fields.addListener(Events.Expand, (Listener)listener);
        fields.addListener(Events.Collapse, (Listener)listener);
        return fields;
    }

    private IntegerField createPrecisionField() {
        IntegerField field = new IntegerField(this.viewContext.getMessage("real_number_formating_precision", new Object[0]), false);
        field.setValue(this.getRealNumberFormatingParameters().getPrecision());
        field.setMaxValue(RealNumberFormatingParameters.MAX_PRECISION);
        return field;
    }

    private CheckBoxField createScientificCheckBox() {
        CheckBoxField field = new CheckBoxField(this.viewContext.getMessage("scientific_formating", new Object[0]), false);
        field.setValue(this.getRealNumberFormatingParameters().isScientific());
        return field;
    }

    private CheckBoxField createDebuggingModeCheckBox() {
        CheckBoxField field = new CheckBoxField(this.viewContext.getMessage("debugging_mode", new Object[0]), false);
        GWTUtils.setToolTip((Component)field, this.viewContext.getMessage("debugging_mode_info", new Object[0]));
        AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
        FieldUtil.addInfoIcon(field, this.viewContext.getMessage("debugging_mode_info", new Object[0]), infoIcon.createImage());
        field.setValue(this.viewContext.getDisplaySettingsManager().isDebuggingModeEnabled());
        return field;
    }

    private RealNumberFormatingParameters getRealNumberFormatingParameters() {
        return this.viewContext.getDisplaySettingsManager().getRealNumberFormatingParameters();
    }

    private Button createResetButton() {
        String buttonTitle = this.viewContext.getMessage("reset_user_settings_button", new Object[0]);
        Button button = new Button(buttonTitle, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                String title = ChangeUserSettingsDialog.this.viewContext.getMessage("confirm_title", new Object[0]);
                String msg = ChangeUserSettingsDialog.this.viewContext.getMessage("reset_user_settings_confirmation_msg", new Object[0]);
                MessageBox.confirm((String)title, (String)msg, (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent messageEvent) {
                        if (messageEvent.getButtonClicked().getItemId().equals("yes")) {
                            ChangeUserSettingsDialog.this.resetUserSettings();
                        }
                    }
                });
            }
        });
        return button;
    }

    private void resetUserSettings() {
        this.viewContext.getService().resetDisplaySettings(new ResetUserSettingsCallback(this.viewContext));
    }

    private HelpPageIdentifier createHelpPageIdentifier() {
        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.CHANGE_USER_SETTINGS, HelpPageIdentifier.HelpPageAction.ACTION);
    }

    public final class ResetUserSettingsCallback
    extends AbstractAsyncCallback<DisplaySettings> {
        private ResetUserSettingsCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        public final void process(DisplaySettings defaultDisplaySettings) {
            this.viewContext.getModel().getSessionContext().setDisplaySettings(defaultDisplaySettings);
            this.viewContext.initDisplaySettingsManager();
            ChangeUserSettingsDialog.this.resetCallback.execute();
            ChangeUserSettingsDialog.this.hide();
        }
    }
}

