/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class VocabularyTermSingleCodeValidator
implements Validator {
    private final IMessageProvider messageProvider;
    private final Set<String> existingTerms;

    VocabularyTermSingleCodeValidator(IMessageProvider messageProvider) {
        this(messageProvider, Collections.emptyList());
    }

    public VocabularyTermSingleCodeValidator(IMessageProvider messageProvider, List<VocabularyTerm> terms) {
        this.messageProvider = messageProvider;
        this.existingTerms = new HashSet<String>();
        for (VocabularyTerm vocabularyTerm : terms) {
            this.existingTerms.add(vocabularyTerm.getCode());
        }
    }

    static final VocabularyTerm getTerm(String value) {
        ArrayList<VocabularyTerm> terms = new ArrayList<VocabularyTerm>();
        if (!StringUtils.isBlank((String)value)) {
            VocabularyTerm term = new VocabularyTerm();
            term.setCode(value);
            terms.add(term);
            return term;
        }
        return null;
    }

    public final String validate(Field<?> field, String value) {
        VocabularyTerm term = VocabularyTermSingleCodeValidator.getTerm(value);
        if (term == null) {
            return this.messageProvider.getMessage("missing_vocabulary_terms", new Object[0]);
        }
        CodeField.CodeFieldKind codeKind = CodeField.CodeFieldKind.CODE_WITH_COLON;
        if (!term.getCode().matches(codeKind.getPattern())) {
            return this.messageProvider.getMessage("invalid_code_message", codeKind.getAllowedCharacters());
        }
        if (this.existingTerms.contains(term.getCode().toUpperCase())) {
            return this.messageProvider.getMessage("vocabulary_terms_validation_message", term);
        }
        return null;
    }
}

