/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp.WebAppUrlParameter;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;

public class WebAppUrl {
    private URLMethodWithParameters builder;

    public WebAppUrl(String openbisProtocol, String openbisHost, String url, String webAppCode, String sessionId) {
        if (openbisProtocol == null) {
            throw new IllegalArgumentException("OpenBIS protocol cannot be null");
        }
        if (openbisHost == null) {
            throw new IllegalArgumentException("OpenBIS host cannot be null");
        }
        if (url == null) {
            throw new IllegalArgumentException("OpenBIS applicationURL cannot be null");
        }
        if (webAppCode == null) {
            throw new IllegalArgumentException("Web application code cannot be null");
        }
        if (sessionId == null) {
            throw new IllegalArgumentException("Session id cannot be null");
        }
        String applicationURL = url;
        if (!url.endsWith("/")) {
            int lastIndexFileDelim = url.lastIndexOf(47);
            applicationURL = url.substring(0, lastIndexFileDelim + 1);
        }
        this.builder = new URLMethodWithParameters(openbisProtocol + "//" + openbisHost + applicationURL + "webapp/" + webAppCode + "/");
        this.builder.addParameter(WebAppUrlParameter.WEBAPP_CODE.getName(), webAppCode);
        this.builder.addParameter(WebAppUrlParameter.SESSION_ID.getName(), sessionId);
    }

    public void addEntityKind(EntityKind entityKind) {
        if (entityKind != null) {
            this.builder.addParameter(WebAppUrlParameter.ENTITY_KIND.getName(), entityKind.name());
        }
    }

    public void addEntityType(BasicEntityType entityType) {
        if (entityType != null) {
            this.builder.addParameter(WebAppUrlParameter.ENTITY_TYPE.getName(), entityType.getCode());
        }
    }

    public void addEntityIdentifier(String entityIdentifier) {
        if (entityIdentifier != null) {
            this.builder.addParameter(WebAppUrlParameter.ENTITY_IDENTIFIER.getName(), entityIdentifier);
        }
    }

    public void addEntityPermId(String entityPermId) {
        if (entityPermId != null) {
            this.builder.addParameter(WebAppUrlParameter.ENTITY_PERM_ID.getName(), entityPermId);
        }
    }

    public String toString() {
        return this.builder.toString();
    }
}

