/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.ArrayList;
import java.util.List;

public class ButtonWithConfirmations
extends Button {
    private ConfirmationChain confirmationChain = new ConfirmationChain(new IConfirmation(){

        @Override
        public void confirm(IConfirmationChain chain) {
            ButtonWithConfirmations.this.fireEvent(Events.Select);
        }
    });

    public ButtonWithConfirmations() {
        this.addBeforeSelectListener();
    }

    public void addConfirmation(IConfirmation confirmation) {
        this.confirmationChain.add(confirmation);
    }

    public void clearConfirmations() {
        this.confirmationChain.clear();
    }

    public void removeAllListeners() {
        super.removeAllListeners();
        this.addBeforeSelectListener();
    }

    private void addBeforeSelectListener() {
        this.addListener(Events.BeforeSelect, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                be.setCancelled(true);
                ButtonWithConfirmations.this.confirmationChain.reset();
                ButtonWithConfirmations.this.confirmationChain.next();
            }
        });
    }

    private static class ConfirmationChain
    implements IConfirmationChain {
        private List<IConfirmation> confirmations = new ArrayList<IConfirmation>();
        private IConfirmation lastConfirmation;
        private int currentConfirmationIndex;

        public ConfirmationChain(IConfirmation lastConfirmation) {
            this.lastConfirmation = lastConfirmation;
        }

        public void add(IConfirmation confirmation) {
            this.confirmations.add(confirmation);
        }

        public void clear() {
            this.confirmations.clear();
            this.reset();
        }

        public void reset() {
            this.currentConfirmationIndex = 0;
        }

        @Override
        public void next() {
            if (this.currentConfirmationIndex < this.confirmations.size()) {
                this.confirmations.get(this.currentConfirmationIndex++).confirm(this);
            } else {
                this.lastConfirmation.confirm(this);
            }
        }
    }

    public static interface IConfirmationChain {
        public void next();
    }

    public static interface IConfirmation {
        public void confirm(IConfirmationChain var1);
    }
}

