/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.CheckBoxGroup;
import com.extjs.gxt.ui.client.widget.form.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CheckBoxGroupWithModel<T>
extends CheckBoxGroup {
    private final Set<T> selected = new HashSet<T>();
    private final Set<CheckBoxGroupListner<T>> listeners = new HashSet<CheckBoxGroupListner<T>>();

    public CheckBoxGroupWithModel(List<LabeledItem<T>> items) {
        for (LabeledItem<T> item : items) {
            this.addCheckBox(item);
        }
    }

    public void addCheckBox(LabeledItem<T> item) {
        final CheckBoxWithModel<T> checkBox = new CheckBoxWithModel<T>(item, false);
        checkBox.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                Object changedItem = checkBox.getItem();
                if (checkBox.getValue().booleanValue()) {
                    CheckBoxGroupWithModel.this.selected.add(changedItem);
                } else {
                    CheckBoxGroupWithModel.this.selected.remove(changedItem);
                }
                CheckBoxGroupWithModel.this.notifyListeners();
            }
        });
        this.add((Field)checkBox);
    }

    private void notifyListeners() {
        for (CheckBoxGroupListner<T> listener : this.listeners) {
            listener.onChange(this.selected);
        }
    }

    public void addListener(CheckBoxGroupListner<T> listener) {
        this.listeners.add(listener);
    }

    public Set<T> getSelected() {
        return this.selected;
    }

    private static final class CheckBoxWithModel<T>
    extends CheckBox {
        private final T item;

        public CheckBoxWithModel(LabeledItem<T> item, Boolean isSelected) {
            this.item = item.getItem();
            this.setBoxLabel(item.toString());
            this.setValue(isSelected);
        }

        public T getItem() {
            return this.item;
        }
    }

    public static interface CheckBoxGroupListner<T> {
        public void onChange(Set<T> var1);
    }
}

