/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.VoidAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.core.El;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreFilter;
import com.extjs.gxt.ui.client.util.Size;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class DropDownList<M extends ModelData, E>
extends ComboBox<M>
implements IDisposableComponent {
    private static final int DEFAULT_WIDTH = 200;
    private static final String PREFIX = "select_";
    public static final String ID = "openbis_select_";
    private final String valueNotInListMsg;
    private final boolean mandatory;
    private final boolean reloadWhenRendering;
    private boolean autoSelectFirst;
    private final IViewContext<?> viewContextOrNull;
    protected boolean allowValueNotFromList = false;
    protected String chooseMsg;
    protected String emptyMsg;
    public String callbackIdOrNull;
    protected String resultSetKey;
    private final List<IDataRefreshCallback> dataRefreshCallbacks;
    private final boolean twinTriggerEnabled;
    protected El twinTrigger;
    private String twinTriggerStyle = "x-form-trigger-add";
    protected El span;

    protected abstract void loadData(AbstractAsyncCallback<List<E>> var1);

    protected abstract List<M> convertItems(List<E> var1);

    public DropDownList(IViewContext<?> viewContext, String idSuffix, String labelDictCode, String displayField, String chooseSuffix, String nothingFoundSuffix, boolean twinTriggerEnabled) {
        this(idSuffix, displayField, viewContext.getMessage(labelDictCode, new Object[0]), viewContext.getMessage("combobox_choose", chooseSuffix), viewContext.getMessage("combobox_empty", nothingFoundSuffix), viewContext.getMessage("combo_box_expected_value_from_the_list", new Object[0]), true, viewContext, true, twinTriggerEnabled);
    }

    public DropDownList(IViewContext<?> viewContext, String idSuffix, String labelDictCode, String displayField, String chooseSuffix, String nothingFoundSuffix) {
        this(viewContext, idSuffix, labelDictCode, displayField, chooseSuffix, nothingFoundSuffix, false);
    }

    public DropDownList(String idSuffix, String displayField, String label, String chooseMsg, String emptyMsg, String valueNotInListMsg, boolean mandatory, IViewContext<?> viewContextOrNull, boolean reloadWhenRendering) {
        this(idSuffix, displayField, label, chooseMsg, emptyMsg, valueNotInListMsg, mandatory, viewContextOrNull, reloadWhenRendering, false);
    }

    protected DropDownList(String idSuffix, String displayField, String label, String chooseMsg, String emptyMsg, String valueNotInListMsg, boolean mandatory, IViewContext<?> viewContextOrNull, boolean reloadWhenRendering, boolean twinTriggerEnabled) {
        this.twinTriggerEnabled = twinTriggerEnabled;
        this.chooseMsg = chooseMsg;
        this.emptyMsg = emptyMsg;
        this.valueNotInListMsg = valueNotInListMsg;
        this.mandatory = mandatory;
        this.reloadWhenRendering = reloadWhenRendering;
        this.viewContextOrNull = viewContextOrNull;
        this.dataRefreshCallbacks = new ArrayList<IDataRefreshCallback>();
        this.setId(DropDownList.createId(idSuffix));
        this.setEnabled(true);
        this.setValidateOnBlur(true);
        this.setAllowBlank(!mandatory);
        this.setWidth(200);
        this.setDisplayField(displayField);
        this.setFieldLabel(label);
        this.setStore(DropDownList.createEmptyStoreWithContainsFilter(this));
        GWTUtils.setupAutoWidth(this);
    }

    public static <M extends ModelData> ListStore<M> createEmptyStoreWithContainsFilter(final ComboBox<M> comboBox) {
        StoreFilter filter = new StoreFilter<M>(){

            public boolean select(Store<M> s, M parent, M item, String property) {
                String displayFieldValue;
                String v = comboBox.getRawValue();
                if (StringUtils.isBlank((String)v) || !comboBox.isExpanded()) {
                    return true;
                }
                if (item != null && (displayFieldValue = (String)item.get(comboBox.getDisplayField())) != null) {
                    return displayFieldValue.toLowerCase().indexOf(v.toLowerCase()) >= 0;
                }
                return false;
            }
        };
        ListStore newStore = new ListStore<M>(){

            public void filter(String property, String beginsWith) {
                super.filter(property, null);
            }

            public void add(List<? extends M> models) {
                this.clearFilters();
                super.add(models);
                this.applyFilters(comboBox.getDisplayField());
            }
        };
        newStore.addFilter(filter);
        return newStore;
    }

    protected void setCallbackId(String callbackId) {
        this.callbackIdOrNull = callbackId;
    }

    private static String createId(String idSuffix) {
        return ID + idSuffix;
    }

    public DatabaseModificationAwareField<M> asDatabaseModificationAware() {
        return new DatabaseModificationAwareField(this, (IDatabaseModificationObserver)this);
    }

    public void setAutoSelectFirst(boolean autoSelectFirst) {
        this.autoSelectFirst = autoSelectFirst;
    }

    public void setAllowValueNotFromList(boolean allowValueNotFromList) {
        this.allowValueNotFromList = allowValueNotFromList;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
        this.removeResultSetFromCache();
    }

    protected void removeResultSetFromCache() {
        if (this.resultSetKey != null && this.viewContextOrNull != null) {
            this.viewContextOrNull.getCommonService().removeResultSet(this.resultSetKey, new VoidAsyncCallback<Void>(this.viewContextOrNull));
        }
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.refreshStore();
    }

    public void refreshStore() {
        this.refreshStore(new ListItemsCallback(this.viewContextOrNull));
    }

    public void refreshStore(IDataRefreshCallback dataRefreshCallback) {
        if (this.viewContextOrNull == null) {
            return;
        }
        AbstractAsyncCallback<List<E>> callback = this.mergeWithStandardCallback(dataRefreshCallback);
        this.refreshStore(callback);
    }

    private AbstractAsyncCallback<List<E>> mergeWithStandardCallback(final IDataRefreshCallback dataRefreshCallback) {
        return new AbstractAsyncCallback<List<E>>(this.viewContextOrNull){

            @Override
            protected void process(List<E> result) {
                new ListItemsCallback(DropDownList.this.viewContextOrNull).process(result);
                dataRefreshCallback.postRefresh(true);
            }
        };
    }

    private void refreshStore(AbstractAsyncCallback<List<E>> callback) {
        if (this.viewContextOrNull != null) {
            this.loadData(callback);
        } else {
            callback.ignore();
        }
    }

    protected final void updateStore(List<M> models) {
        ListStore termsStore = this.getStore();
        termsStore.removeAll();
        termsStore.add(models);
        int termsCount = termsStore.getCount();
        if (termsCount == 0) {
            this.setEmptyText(this.emptyMsg);
            this.setReadOnly(true);
        } else if (termsCount == 1) {
            this.selectFirstModel(models);
        } else {
            this.setEmptyText(this.chooseMsg);
            this.setReadOnly(false);
            if (this.getValue() != null && this.getSelection().size() == 0) {
                this.validate();
            }
            this.restoreSelection(this.getSelection());
            if (this.autoSelectFirst && this.getSelection().size() == 0) {
                this.selectFirstModel(models);
            }
        }
        this.applyEmptyText();
    }

    private void selectFirstModel(List<M> models) {
        this.setSelection(models);
    }

    private void restoreSelection(List<M> previousSelection) {
        List<M> newSelection = DropDownList.cleanSelection(previousSelection, this.getStore());
        if (previousSelection.size() != newSelection.size()) {
            this.setSelection(newSelection);
        }
    }

    private static <M extends ModelData> List<M> cleanSelection(List<M> previousSelection, Store<M> newStore) {
        ArrayList<ModelData> newSelection = new ArrayList<ModelData>();
        for (ModelData prevItem : previousSelection) {
            if (!DropDownList.containsModel(newStore, prevItem)) continue;
            newSelection.add(prevItem);
        }
        return newSelection;
    }

    private static <M extends ModelData> boolean containsModel(Store<M> store, M item) {
        for (ModelData elem : store.getModels()) {
            if (!DropDownList.equalsModel(elem, item)) continue;
            return true;
        }
        return false;
    }

    private static <M extends ModelData> boolean equalsModel(M model1, M model2) {
        Collection props2;
        Collection props1 = model1.getPropertyNames();
        if (!props1.equals(props2 = model1.getPropertyNames())) {
            return false;
        }
        for (String propName : props1) {
            Object val1 = model1.get(propName);
            Object val2 = model2.get(propName);
            if (!(val1 == null ? val2 != null : !val1.equals(val2))) continue;
            return false;
        }
        return true;
    }

    public String getRawValue() {
        if (this.mandatory && this.optionNoneSelected()) {
            return "";
        }
        return super.getRawValue();
    }

    public M getValue() {
        ModelData val = super.getValue();
        if (this.optionNoneSelected()) {
            return null;
        }
        return (M)val;
    }

    private boolean optionNoneSelected() {
        return super.getRawValue() != null && super.getRawValue().equals("(None)");
    }

    public E tryGetSelected() {
        if (this.optionNoneSelected()) {
            return null;
        }
        return (E)GWTUtils.tryGetSingleSelected(this);
    }

    protected boolean isAnythingSelected() {
        if (this.optionNoneSelected()) {
            return false;
        }
        return GWTUtils.tryGetSingleSelectedCode(this) != null;
    }

    private boolean valueNotInTheList() {
        return this.isEnabled() && this.getValue() == null && this.getRawValue() != null && !this.getRawValue().equals("") && !this.getRawValue().equals(this.getEmptyText()) && !this.optionNoneSelected();
    }

    private boolean clearInvalidAndCheckValueFromList() {
        this.clearInvalid();
        if (!this.allowValueNotFromList && this.valueNotInTheList()) {
            this.forceInvalid(this.valueNotInListMsg);
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.clearInvalidAndCheckValueFromList() && super.isValid();
    }

    public boolean validate() {
        return this.clearInvalidAndCheckValueFromList() && super.validate();
    }

    protected void onRender(Element target, int index) {
        if (this.twinTriggerEnabled) {
            this.input = new El(DOM.createInputText());
            this.setElement(DOM.createDiv(), target, index);
            this.addStyleName("x-form-field-wrap");
            this.trigger = new El(DOM.createImg());
            this.trigger.dom.setClassName("x-form-trigger " + this.triggerStyle);
            this.trigger.dom.setPropertyString("src", GXT.BLANK_IMAGE_URL);
            this.twinTrigger = new El(DOM.createImg());
            this.twinTrigger.dom.setClassName("x-form-trigger " + this.twinTriggerStyle);
            this.twinTrigger.dom.setPropertyString("src", GXT.BLANK_IMAGE_URL);
            this.span = new El(DOM.createSpan());
            this.span.dom.setClassName("x-form-twin-triggers");
            this.span.appendChild(this.trigger.dom);
            this.span.appendChild(this.twinTrigger.dom);
            this.el().appendChild(this.input.dom);
            this.el().appendChild(this.span.dom);
            if (this.isHideTrigger()) {
                this.span.setVisible(false);
            }
            this.addStyleOnOver(this.twinTrigger.dom, "x-form-trigger-over");
        }
        super.onRender(target, index);
        if (this.reloadWhenRendering) {
            this.refreshStore();
        }
    }

    public void onComponentEvent(ComponentEvent ce) {
        super.onComponentEvent(ce);
        if (this.twinTriggerEnabled) {
            int type = ce.getEventTypeInt();
            if (ce.getTarget() == this.twinTrigger.dom && type == 1) {
                this.onTwinTriggerClick(ce);
            }
        }
    }

    protected Size adjustInputSize() {
        return this.twinTriggerEnabled ? new Size(this.isHideTrigger() ? 0 : this.trigger.getStyleSize().width + this.twinTrigger.getStyleSize().width, 0) : super.adjustInputSize();
    }

    protected void onTwinTriggerClick(ComponentEvent ce) {
        this.fireEvent(Events.TwinTriggerClick, ce);
    }

    public void addPostRefreshCallback(IDataRefreshCallback callback) {
        this.dataRefreshCallbacks.add(callback);
    }

    protected void updateOriginalValue() {
        this.setOriginalValue(this.getValue());
    }

    protected void trySelectByPropertyValue(String property, String propertyValue, String errorMsg) {
        if (this.allowValueNotFromList && GWTUtils.isPropertyNotInList(this, property, propertyValue)) {
            this.setRawValue(propertyValue);
        } else {
            try {
                GWTUtils.setSelectedItem(this, property, propertyValue);
            }
            catch (IllegalArgumentException ex) {
                GWTUtils.alert("Error", errorMsg);
            }
        }
    }

    protected class ListItemsCallback
    extends AbstractAsyncCallback<List<E>> {
        protected ListItemsCallback(IViewContext<?> viewContext) {
            super(viewContext);
        }

        @Override
        public void process(List<E> result) {
            List convertedItems = DropDownList.this.convertItems(result);
            DropDownList.this.updateStore(convertedItems);
            for (IDataRefreshCallback c : DropDownList.this.dataRefreshCallbacks) {
                c.postRefresh(true);
            }
        }

        @Override
        public String getCallbackId() {
            if (DropDownList.this.callbackIdOrNull != null) {
                return DropDownList.this.callbackIdOrNull;
            }
            return super.getCallbackId();
        }
    }
}

