/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentWithCloseConfirmationUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IComponentWithCloseConfirmation;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class EntityRegistrationPanel<T extends ModelData, S extends DropDownList<T, ?>>
extends ContentPanel
implements IDatabaseModificationObserver,
IComponentWithCloseConfirmation {
    private final S entityTypeSelection;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final EntityKind entityKind;
    private DatabaseModificationAwareWidget registrationWidget;
    private final PreviousSelection previousSelection = new PreviousSelection();
    private final ActionContext actionContext;

    protected static String createId(EntityKind entityKind) {
        return "openbis_" + entityKind.name().toLowerCase() + "-registration";
    }

    public EntityRegistrationPanel(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKind, S entityTypeSelection, ActionContext context) {
        this.entityTypeSelection = entityTypeSelection;
        this.viewContext = viewContext;
        this.entityKind = entityKind;
        this.actionContext = context;
        this.setHeaderVisible(false);
        this.setId(EntityRegistrationPanel.createId(entityKind));
        this.setScrollMode(Style.Scroll.AUTO);
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)new LabelToolItem(entityTypeSelection.getFieldLabel() + ":"));
        toolBar.add(entityTypeSelection);
        this.setTopComponent((Component)toolBar);
        entityTypeSelection.addSelectionChangedListener(this.createSelectionChangedListener());
    }

    private SelectionChangedListener<T> createSelectionChangedListener() {
        return new SelectionChangedListener<T>(){

            public void selectionChanged(SelectionChangedEvent<T> se) {
                ModelData entityTypeModel = se.getSelectedItem();
                if (entityTypeModel != null) {
                    EntityRegistrationPanel.this.onSelectionChanged(entityTypeModel);
                }
            }
        };
    }

    private void onSelectionChanged(T entityTypeModel) {
        EntityType entityType = (EntityType)((Object)entityTypeModel.get("object"));
        if (this.registrationWidget == null || !this.shouldAskForCloseConfirmation()) {
            this.showAndUpdateRegistrationForm(entityTypeModel, entityType);
        } else {
            new ConfirmationDialog(this.viewContext.getMessage("confirm_title", new Object[0]), this.viewContext.getMessage("confirm_close_msg", new Object[0]), (ModelData)entityTypeModel, entityType){
                final /* synthetic */ ModelData val$entityTypeModel;
                final /* synthetic */ EntityType val$entityType;
                {
                    this.val$entityTypeModel = modelData;
                    this.val$entityType = entityType;
                    super(heading, message);
                }

                @Override
                protected void onYes() {
                    EntityRegistrationPanel.this.showAndUpdateRegistrationForm(this.val$entityTypeModel, this.val$entityType);
                }

                @Override
                protected void onNo() {
                    ArrayList selection = new ArrayList();
                    selection.add(EntityRegistrationPanel.this.previousSelection.getValue());
                    EntityRegistrationPanel.this.entityTypeSelection.disableEvents(true);
                    EntityRegistrationPanel.this.entityTypeSelection.setSelection(selection);
                    EntityRegistrationPanel.this.entityTypeSelection.disableEvents(false);
                }
            }.show();
        }
    }

    private void showAndUpdateRegistrationForm(final T entityTypeModel, final EntityType entityType) {
        this.viewContext.getService().listManagedInputWidgetDescriptions(this.entityKind, entityType.getCode(), (AsyncCallback<Map<String, List<IManagedInputWidgetDescription>>>)new AbstractAsyncCallback<Map<String, List<IManagedInputWidgetDescription>>>(this.viewContext){

            @Override
            protected void process(Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions) {
                EntityRegistrationPanel.this.showRegistrationForm(entityType, inputWidgetDescriptions);
                EntityRegistrationPanel.this.previousSelection.update(entityTypeModel);
            }
        });
    }

    private void showRegistrationForm(EntityType entityType, Map<String, List<IManagedInputWidgetDescription>> inputWidgetDescriptions) {
        this.removeAll();
        IClientPlugin clientPlugin = this.viewContext.getClientPluginFactoryProvider().getClientPluginFactory(this.entityKind, entityType).createClientPlugin(this.entityKind);
        this.registrationWidget = clientPlugin.createRegistrationForEntityType(entityType, inputWidgetDescriptions, this.actionContext);
        this.add((Widget)this.registrationWidget.get());
        this.layout();
    }

    private IDatabaseModificationObserver createCompositeDatabaseModificationObserver() {
        CompositeDatabaseModificationObserver observer = new CompositeDatabaseModificationObserver();
        if (this.registrationWidget != null) {
            observer.addObserver(this.registrationWidget);
        }
        observer.addObserver((IDatabaseModificationObserver)this.entityTypeSelection);
        return observer;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.createCompositeDatabaseModificationObserver().getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.createCompositeDatabaseModificationObserver().update(observedModifications);
    }

    @Override
    public boolean shouldAskForCloseConfirmation() {
        if (this.registrationWidget != null) {
            return ComponentWithCloseConfirmationUtil.shouldAskForCloseConfirmation(this.registrationWidget.get());
        }
        return false;
    }

    private class PreviousSelection {
        T value;

        private PreviousSelection() {
        }

        void update(T newValue) {
            this.value = newValue;
        }

        T getValue() {
            return this.value;
        }
    }
}

