/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IMessageElement;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;

public class HtmlMessageElement
implements IMessageElement {
    private final String content;
    private static final String TRUNCATE_SUFFIX = "...";

    public HtmlMessageElement(String content) {
        this.content = content;
    }

    @Override
    public int length() {
        return this.content.length();
    }

    @Override
    public Widget render() {
        return this.createHTMLWidget(this.content);
    }

    @Override
    public Widget render(int maxLength) {
        return this.createHTMLWidget(this.truncate(this.content, maxLength));
    }

    private Widget createHTMLWidget(String truncatedContent) {
        return new HTML(truncatedContent);
    }

    private String truncate(String text, int maxLength) {
        if (this.shouldTruncate(text, maxLength)) {
            return text.substring(0, maxLength) + TRUNCATE_SUFFIX;
        }
        return text;
    }

    private boolean shouldTruncate(String text, int maxLength) {
        return text != null && text.length() > maxLength;
    }

    public String getHtml() {
        return this.content;
    }

    public String toString() {
        return this.content;
    }
}

