/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.HtmlMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IInfoHandler;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IMessageElement;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.InfoType;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.PopupDialogBasedInfoHandler;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.FlowData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public final class InfoBox
extends Composite
implements IInfoHandler {
    private static final int TRUNCATE_THRESHOLD = 200;
    private static final String PLACEHOLDER_TEXT = "X";
    private static final String WHITE = "#ffffff";
    private Panel mainPanel;
    private String fullMessage;
    private InfoType messageType;
    private LayoutContainer message = new LayoutContainer();
    private PopupDialogBasedInfoHandler fullMessageDialog;
    private Anchor showFullMessageLink;
    private Timer progressTimer;

    public InfoBox(IMessageProvider messageProvider) {
        this(messageProvider, HasHorizontalAlignment.ALIGN_DEFAULT);
    }

    public InfoBox(final IMessageProvider messageProvider, HasHorizontalAlignment.HorizontalAlignmentConstant alignment) {
        this.showFullMessageLink = new Anchor(messageProvider.getMessage("info_box_show_full_message", new Object[0]));
        this.showFullMessageLink.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (InfoBox.this.fullMessageDialog != null) {
                    InfoBox.this.fullMessageDialog.hide();
                }
                InfoBox.this.fullMessageDialog = new PopupDialogBasedInfoHandler(messageProvider);
                InfoBox.this.fullMessageDialog.display(InfoBox.this.messageType, InfoBox.this.fullMessage);
            }
        });
        TableLayout layout = new TableLayout(1);
        layout.setWidth("100%");
        LayoutContainer verticalPanel = new LayoutContainer((Layout)layout);
        verticalPanel.add((Widget)this.message);
        verticalPanel.add((Widget)this.showFullMessageLink);
        this.mainPanel = new SimplePanel();
        Style mainPanelStyle = this.mainPanel.getElement().getStyle();
        mainPanelStyle.setBorderStyle(Style.BorderStyle.SOLID);
        mainPanelStyle.setBorderWidth(1.0, Style.Unit.PX);
        mainPanelStyle.setPadding(3.0, Style.Unit.PX);
        this.mainPanel.add((Widget)verticalPanel);
        this.initWidget((Widget)this.mainPanel);
        this.reset();
    }

    @Override
    public final void displayError(String text) {
        this.display(text, InfoType.ERROR);
    }

    @Override
    public final void displayInfo(String text) {
        this.display(text, InfoType.INFO);
    }

    @Override
    public void displayInfo(List<? extends IMessageElement> elements) {
        this.stopProgress();
        this.setInfoBoxStyle(InfoType.INFO);
        boolean nonHtmlMessageElements = this.containsNonHtmlMessageElements(elements);
        int currentLength = 0;
        StringBuilder builder = new StringBuilder();
        this.message.removeAll();
        for (IMessageElement iMessageElement : elements) {
            Widget widget;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append(iMessageElement);
            FlowData layoutData = new FlowData(new Margins(0, 5, 0, 0));
            if (nonHtmlMessageElements) {
                widget = iMessageElement.render();
                widget.getElement().getStyle().setDisplay(Style.Display.INLINE);
                this.message.add(widget, (LayoutData)layoutData);
                continue;
            }
            if (200 < currentLength) continue;
            widget = iMessageElement.render(200 - currentLength);
            widget.getElement().getStyle().setDisplay(Style.Display.INLINE);
            currentLength += iMessageElement.length();
            this.message.add(widget, (LayoutData)layoutData);
        }
        this.fullMessage = builder.toString();
        this.showFullMessageLink.setVisible(!nonHtmlMessageElements && 200 < currentLength);
        this.message.layout(false);
        this.getElement().scrollIntoView();
    }

    private boolean containsNonHtmlMessageElements(List<? extends IMessageElement> elements) {
        for (IMessageElement iMessageElement : elements) {
            if (iMessageElement instanceof HtmlMessageElement) continue;
            return true;
        }
        return false;
    }

    private void setInfoBoxStyle(InfoType type) {
        Style mainPanelStyle = this.mainPanel.getElement().getStyle();
        mainPanelStyle.setColor("#000000");
        mainPanelStyle.setBackgroundColor(type.getBackgroundColor());
        mainPanelStyle.setBorderColor(type.getBorderColor());
        this.messageType = type;
    }

    @Override
    public final void displayProgress(final String text) {
        this.display(text, InfoType.PROGRESS);
        this.progressTimer = new Timer(){
            String dots;

            public void run() {
                this.dots = this.dots != null && this.dots.length() < 6 ? this.dots + "." : "...";
                InfoBox.this.setHtmlMessage(text + this.dots);
            }
        };
        this.progressTimer.run();
        this.progressTimer.scheduleRepeating(500);
    }

    public final void display(String text, InfoType type) {
        this.stopProgress();
        if (!StringUtils.isBlank((String)text)) {
            this.setInfoBoxStyle(type);
            this.fullMessage = text;
            this.setHtmlMessage(text);
            this.showFullMessageLink.setVisible(this.shouldTruncate(text));
            if (this.fullMessageDialog != null) {
                this.fullMessageDialog.hide();
                this.fullMessageDialog = null;
            }
            this.getElement().scrollIntoView();
        }
    }

    private void stopProgress() {
        if (this.progressTimer != null) {
            this.progressTimer.cancel();
            this.progressTimer = null;
        }
    }

    private void setHtmlMessage(String messageElement) {
        this.message.removeAll();
        this.message.add(new HtmlMessageElement(messageElement).render(200));
        this.message.layout(true);
    }

    public final void reset() {
        this.stopProgress();
        Style mainPanelStyle = this.mainPanel.getElement().getStyle();
        mainPanelStyle.setBackgroundColor(WHITE);
        mainPanelStyle.setBorderColor(WHITE);
        mainPanelStyle.setColor(WHITE);
        this.fullMessage = null;
        this.setHtmlMessage(PLACEHOLDER_TEXT);
        this.showFullMessageLink.setVisible(false);
        if (this.fullMessageDialog != null) {
            this.fullMessageDialog.hide();
            this.fullMessageDialog = null;
        }
    }

    private boolean shouldTruncate(String text) {
        return text != null && text.length() > 200;
    }
}

