/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SampleChildrenInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EntityDeletionConfirmationUtils {
    public static String getMessageForSingleSample(IViewContext<?> viewContext, SampleChildrenInfo sampleChildrenInfo) {
        int MAX_DISPLAY_SIZE = 10;
        StringBuffer additionalMessage = new StringBuffer();
        StringBuffer sampleSb = new StringBuffer();
        StringBuffer dataSetSb = new StringBuffer();
        for (String child : sampleChildrenInfo.getDerivedSamples()) {
            sampleSb.append("<br>" + child);
        }
        for (String ds : sampleChildrenInfo.getDataSets()) {
            dataSetSb.append("<br>" + ds);
        }
        String sampleText = viewContext.getMessage("sample", new Object[0]).toLowerCase();
        if (sampleSb.length() > 0) {
            additionalMessage.append("<br>The " + sampleText + " has " + sampleChildrenInfo.getChildCount() + " children " + viewContext.getMessage("samples", new Object[0]).toLowerCase() + ", these relationships will be broken but the children will remain:");
            additionalMessage.append("<br>");
            additionalMessage.append(sampleSb);
            if (sampleChildrenInfo.getChildCount() > 10) {
                additionalMessage.append("<br> and " + (sampleChildrenInfo.getChildCount() - 10) + " more");
            }
            additionalMessage.append("<br>");
        }
        if (dataSetSb.length() > 0) {
            additionalMessage.append("<br>The " + sampleText + " has " + sampleChildrenInfo.getDataSetCount() + " datasets, these will be deleted with the " + sampleText + ":");
            additionalMessage.append("<br>");
            additionalMessage.append(dataSetSb);
            if (sampleChildrenInfo.getDataSetCount() > 10) {
                additionalMessage.append("<br>and " + (sampleChildrenInfo.getDataSetCount() - 10) + " more");
            }
            additionalMessage.append("<br>");
        }
        return additionalMessage.toString();
    }

    public static String getMessageForMultipleSamples(IViewContext<?> viewContext, List<SampleChildrenInfo> sampleChildrenInfo, Map<String, String> techIdsToSampleIds) {
        StringBuffer additionalMessage = new StringBuffer();
        int samplesWithChildren = 0;
        int samplesWithDataSets = 0;
        int MAX_DISPLAY_SIZE = 10;
        HashSet<String> samplesWithChildrenToDisplay = new HashSet<String>();
        HashSet<String> samplesWithDataSetsToDisplay = new HashSet<String>();
        for (SampleChildrenInfo info : sampleChildrenInfo) {
            if (info.getChildCount() > 0 && ++samplesWithChildren <= 10) {
                samplesWithChildrenToDisplay.add(techIdsToSampleIds.get(info.getSampleIdentifier()));
            }
            if (info.getDataSetCount() <= 0 || ++samplesWithDataSets > 10) continue;
            samplesWithDataSetsToDisplay.add(techIdsToSampleIds.get(info.getSampleIdentifier()));
        }
        String sampleText = viewContext.getMessage("sample", new Object[0]).toLowerCase();
        String samplesText = viewContext.getMessage("samples", new Object[0]).toLowerCase();
        if (samplesWithChildren > 0) {
            additionalMessage.append("<br>There are " + samplesWithChildren + " " + (samplesWithChildren > 1 ? samplesText : sampleText) + " with children " + samplesText + ", these relationships will be broken but the children will remain:<br>");
            for (String sample : samplesWithChildrenToDisplay) {
                additionalMessage.append("<br>" + sample);
            }
            if (samplesWithChildren > 10) {
                additionalMessage.append("<br>and " + (samplesWithChildren - 10) + " more");
            }
            additionalMessage.append("<br>");
        }
        if (samplesWithDataSets > 0) {
            additionalMessage.append("<br>There are " + samplesWithDataSets + " " + (samplesWithDataSets > 1 ? samplesText : sampleText) + " with data sets, these will be deleted with the " + sampleText + ":<br>");
            for (String sample : samplesWithDataSetsToDisplay) {
                additionalMessage.append("<br>" + sample);
            }
            if (samplesWithDataSets > 10) {
                additionalMessage.append("<br>and " + (samplesWithDataSets - 10) + " more");
            }
            additionalMessage.append("<br>");
        }
        return additionalMessage.toString();
    }
}

