/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.TableLayout;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.user.client.ui.Widget;

public class WidgetUtils {
    public static RadioGroup createAllOrSelectedRadioGroup(Radio selected, Radio all, String label, long selectedSize, final IDelegatedAction onChangeActionOrNull) {
        RadioGroup result = new RadioGroup();
        result.setFieldLabel(label);
        result.setSelectionRequired(true);
        result.setOrientation(Style.Orientation.HORIZONTAL);
        if (selectedSize > 0L) {
            result.add(selected);
        }
        result.add(all);
        result.setValue(selectedSize > 0L ? selected : all);
        result.setAutoHeight(true);
        if (onChangeActionOrNull != null) {
            result.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    onChangeActionOrNull.execute();
                }
            });
        }
        return result;
    }

    public static RadioGroup createAllOrSelectedRadioGroup(Radio selected, Radio all, String label, long selectedSize) {
        return WidgetUtils.createAllOrSelectedRadioGroup(selected, all, label, selectedSize, null);
    }

    public static final Radio createRadio(String label) {
        Radio result = new Radio();
        result.setBoxLabel(label);
        return result;
    }

    public static boolean isSelected(Radio radioOrNull) {
        if (radioOrNull == null) {
            return false;
        }
        return radioOrNull.getValue();
    }

    public static final boolean ifSpecialKeyPressed(NativeEvent e) {
        boolean result = e.getAltKey();
        if (result) {
            e.stopPropagation();
            e.preventDefault();
        }
        return result;
    }

    public static LayoutContainer inRow(Widget ... containers) {
        return WidgetUtils.asTable(containers.length, containers);
    }

    public static LayoutContainer asTable(int columns, Widget ... containers) {
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new TableLayout(columns));
        container.setBorders(false);
        container.setScrollMode(Style.Scroll.AUTO);
        for (Widget w : containers) {
            container.add(w, (LayoutData)new TableData(Style.HorizontalAlignment.LEFT, Style.VerticalAlignment.TOP));
        }
        return container;
    }
}

