/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DOMUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.log.LogImpl;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Html;
import com.google.gwt.core.client.Duration;

final class WebModeLog
extends LogImpl {
    private final LoggingDialog loggingDialog = new LoggingDialog();

    WebModeLog() {
    }

    @Override
    public final void hide() {
        this.loggingDialog.hide();
    }

    @Override
    public final void show() {
        this.loggingDialog.show();
    }

    @Override
    public final void log(String message) {
        this.loggingDialog.append(message);
    }

    @Override
    public final void logTimeTaken(Duration duration, String taskName) {
        String message = taskName + " took " + (float)duration.elapsedMillis() / 1000.0f + "s";
        this.loggingDialog.append(message);
    }

    private static final class LoggingDialog
    extends Dialog {
        private StringBuffer buffer;
        private Html html;

        LoggingDialog() {
            this.setHeading("Logging Console");
            this.setScrollMode(Style.Scroll.AUTO);
            this.setWidth(500);
            this.setHeight(300);
            this.setBodyStyle("backgroundColor: #ffffff;");
            this.setCollapsible(true);
            this.setHideOnButtonClick(true);
        }

        final void append(String text) {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            if (this.buffer.length() > 0) {
                this.buffer.append(DOMUtils.BR);
            }
            this.buffer.append(text);
            System.out.println(this.buffer);
            if (this.html == null) {
                this.html = this.addText(this.buffer.toString());
            } else {
                this.html.setHtml(this.buffer.toString());
            }
            this.layout();
        }
    }
}

