/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.annotation.DoNotEscape;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImport;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebApp;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@DoNotEscape
public final class ApplicationInfo
implements IsSerializable {
    private String version;
    private String cifexURL;
    private String cifexRecipient;
    private boolean archivingConfigured;
    private boolean projectSamplesEnabled;
    private boolean projectLevelAuthorizationEnabled;
    private boolean projectLevelAuthorizationUser;
    private WebClientConfiguration webClientConfiguration;
    private Set<String> enabledTechnologies;
    private int maxResults = 100000;
    private List<CustomImport> customImports;
    private List<WebApp> webapps;

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        if (maxResults > 0) {
            this.maxResults = maxResults;
        }
    }

    public String getCifexRecipient() {
        return this.cifexRecipient;
    }

    public void setCifexRecipient(String cifexRecipient) {
        this.cifexRecipient = cifexRecipient;
    }

    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(String version) {
        this.version = version;
    }

    public void setCifexURL(String cifexURL) {
        this.cifexURL = cifexURL;
    }

    public final String getCifexURL() {
        return this.cifexURL;
    }

    public boolean isArchivingConfigured() {
        return this.archivingConfigured;
    }

    public void setArchivingConfigured(boolean archivingConfigured) {
        this.archivingConfigured = archivingConfigured;
    }

    public void setWebClientConfiguration(WebClientConfiguration configuration) {
        this.webClientConfiguration = configuration;
    }

    public WebClientConfiguration getWebClientConfiguration() {
        return this.webClientConfiguration;
    }

    public boolean isTechnologyEnabled(String technology) {
        for (String pattern : this.enabledTechnologies) {
            if (RegExp.compile((String)pattern).exec(technology) == null) continue;
            return true;
        }
        return false;
    }

    public void setEnabledTechnologies(Set<String> enabledTechnologies) {
        this.enabledTechnologies = enabledTechnologies;
    }

    public void setCustomImports(List<CustomImport> customImports) {
        this.customImports = customImports == null ? new ArrayList<CustomImport>() : customImports;
    }

    public List<CustomImport> getCustomImports() {
        return this.customImports;
    }

    public void setWebapps(List<WebApp> webapps) {
        this.webapps = webapps;
    }

    public List<WebApp> getWebapps() {
        if (this.webapps == null) {
            return Collections.emptyList();
        }
        return this.webapps;
    }

    public boolean isProjectSamplesEnabled() {
        return this.projectSamplesEnabled;
    }

    public void setProjectSamplesEnabled(boolean projectSamplesEnabled) {
        this.projectSamplesEnabled = projectSamplesEnabled;
    }

    public boolean isProjectLevelAuthorizationEnabled() {
        return this.projectLevelAuthorizationEnabled;
    }

    public void setProjectLevelAuthorizationEnabled(boolean projectLevelAuthorizationEnabled) {
        this.projectLevelAuthorizationEnabled = projectLevelAuthorizationEnabled;
    }

    public boolean isProjectLevelAuthorizationUser() {
        return this.projectLevelAuthorizationUser;
    }

    public void setProjectLevelAuthorizationUser(boolean projectLevelAuthorizationUser) {
        this.projectLevelAuthorizationUser = projectLevelAuthorizationUser;
    }
}

